/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.pattern.BlockStateMatcher;
import net.minecraft.state.Property;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="paraglider", bus=Mod.EventBusSubscriber.Bus.MOD)
public final class ModCfg {
    private static ForgeConfigSpec.BooleanValue ascendingWinds;
    private static ForgeConfigSpec.BooleanValue paraglidingConsumesStamina;
    private static ForgeConfigSpec.BooleanValue runningConsumesStamina;
    private static ForgeConfigSpec.ConfigValue<List<? extends String>> windSources;
    private static Map<Block, Predicate<BlockState>> windSourcesParsed;
    private static ForgeConfigSpec.BooleanValue debugPlayerMovement;
    private static ForgeConfigSpec.BooleanValue traceMovementPacket;
    private static ForgeConfigSpec.BooleanValue traceParaglidingPacket;
    private static ForgeConfigSpec.BooleanValue traceVesselPacket;
    private static ForgeConfigSpec.BooleanValue forceFlightDisabled;
    private static final Pattern REGEX;
    private static final Matcher MATCH;

    private ModCfg() {
    }

    public static boolean ascendingWinds() {
        return (Boolean)ascendingWinds.get();
    }

    public static boolean paraglidingConsumesStamina() {
        return (Boolean)paraglidingConsumesStamina.get();
    }

    public static boolean runningConsumesStamina() {
        return (Boolean)runningConsumesStamina.get();
    }

    public static boolean isWindSource(BlockState state) {
        Predicate<BlockState> p = windSourcesParsed.get(state.func_177230_c());
        return p != null && p.test(state);
    }

    public static boolean debugPlayerMovement() {
        return (Boolean)debugPlayerMovement.get();
    }

    public static boolean traceMovementPacket() {
        return (Boolean)traceMovementPacket.get();
    }

    public static boolean traceParaglidingPacket() {
        return (Boolean)traceParaglidingPacket.get();
    }

    public static boolean traceVesselPacket() {
        return (Boolean)traceVesselPacket.get();
    }

    public static boolean forceFlightDisabled() {
        return (Boolean)forceFlightDisabled.get();
    }

    public static void init() {
        ForgeConfigSpec.Builder server = new ForgeConfigSpec.Builder();
        ascendingWinds = server.comment("Fire will float you upward.").define("ascendingWinds", true);
        windSources = server.comment("You can customize which block produces wind.\nWrite each blockstate to one of this format:\n  [block ID]   (Matches all state of the block)\n  [block ID]#[property1=value],[property2=value],[property3=value]   (Matches state of the block that has specified properties)\nSame property cannot be specified multiple times. Wind sources with any invalid part will be excluded.").defineList("windSources", (List)ImmutableList.of((Object)"fire", (Object)"campfire#lit=true", (Object)"soul_campfire#lit=true"), o -> MATCH.reset(o.toString()).matches());
        paraglidingConsumesStamina = server.comment("Paragliding will consume stamina.").define("paraglidingConsumesStamina", true);
        runningConsumesStamina = server.comment("Actions other than paragliding will consume stamina.").define("runningAndSwimmingConsumesStamina", false);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, server.build());
        ForgeConfigSpec.Builder common = new ForgeConfigSpec.Builder();
        common.push("debug");
        debugPlayerMovement = common.define("debugPlayerMovement", false);
        traceMovementPacket = common.define("traceMovementPacket", false);
        traceParaglidingPacket = common.define("traceParaglidingPacket", false);
        traceVesselPacket = common.define("traceVesselPacket", false);
        common.pop();
        forceFlightDisabled = common.worldRestart().comment("Forces the server to not kick the shit out of 'cheaters' who also happened to be using paraglider.\nFeel free to disable it if you hate 'cheaters'. Or paraglider. If disabled, 'allow-flight' inside server.properties will be used.").define("forceFlightDisabled", true);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, common.build());
    }

    @SubscribeEvent
    public static void onLoad(ModConfig.ModConfigEvent event) {
        ModConfig cfg = event.getConfig();
        if (cfg.getModId().equals("paraglider") && cfg.getType() == ModConfig.Type.SERVER) {
            windSourcesParsed = Collections.unmodifiableMap(ModCfg.parseWindSources());
        }
    }

    private static Map<Block, Predicate<BlockState>> parseWindSources() {
        IdentityHashMap<Block, Predicate<BlockState>> map = new IdentityHashMap<Block, Predicate<BlockState>>();
        for (String s : (List)windSources.get()) {
            Predicate<BlockState> p;
            Block block;
            if (!MATCH.reset(s).matches() || (block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(MATCH.group(1)))) == null || (p = ModCfg.parsePredicate(block)) == null) continue;
            map.compute(block, (k, v) -> v == null ? p : v.or(p));
        }
        return map;
    }

    @Nullable
    private static Predicate<BlockState> parsePredicate(Block block) {
        String match = MATCH.group(2);
        if (match == null) {
            return s -> true;
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        for (String s2 : match.split(",")) {
            int i = s2.indexOf(61);
            String key = s2.substring(0, i);
            if (properties.containsKey(key)) {
                return null;
            }
            properties.put(key, s2.substring(i + 1));
        }
        IdentityHashMap parsedProperties = new IdentityHashMap();
        for (Map.Entry e : properties.entrySet()) {
            String key = (String)e.getKey();
            Property property = block.func_176194_O().func_185920_a(key);
            if (property == null || parsedProperties.containsKey(property)) {
                return null;
            }
            Optional o2 = property.func_185929_b((String)e.getValue());
            if (!o2.isPresent()) {
                return null;
            }
            parsedProperties.put(property, o2.get());
        }
        BlockStateMatcher m = BlockStateMatcher.func_177638_a((Block)block);
        for (Map.Entry e : parsedProperties.entrySet()) {
            Object v = e.getValue();
            m.func_201028_a((Property)e.getKey(), o -> o != null && o.equals(v));
        }
        return m;
    }

    static {
        REGEX = Pattern.compile("^((?:[a-z0-9_.-]+:)?[a-z0-9_.-]+)(?:\\s*#\\s*([A-Za-z0-9_.-]+\\s*=\\s*[A-Za-z0-9_.-]+(?:\\s*,\\s*[A-Za-z0-9_.-]+\\s*=\\s*[A-Za-z0-9_.-]+)*))?$");
        MATCH = REGEX.matcher("");
    }
}

