/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider;

import javax.annotation.Nullable;
import javax.naming.OperationNotSupportedException;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.IDyeableArmorItem;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemModelsProperties;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import tictim.paraglider.ModCfg;
import tictim.paraglider.capabilities.Paraglider;
import tictim.paraglider.capabilities.PlayerMovement;
import tictim.paraglider.contents.Contents;
import tictim.paraglider.contents.WindEntity;
import tictim.paraglider.item.ParagliderItem;
import tictim.paraglider.network.ModNet;

@Mod(value="paraglider")
@Mod.EventBusSubscriber(modid="paraglider", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ParagliderMod {
    public static final String MODID = "paraglider";
    public static final Logger LOGGER = LogManager.getLogger((String)"Paraglider");

    public ParagliderMod() {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        Contents.registerEventHandlers(eventBus);
        ModCfg.init();
        ModNet.init();
    }

    @SubscribeEvent
    public static void setup(FMLCommonSetupEvent event) {
        ParagliderMod.registerDefaultCapability(PlayerMovement.class);
        ParagliderMod.registerDefaultCapability(Paraglider.class);
    }

    private static <T> void registerDefaultCapability(Class<T> classOf) {
        CapabilityManager.INSTANCE.register(classOf, new Capability.IStorage<T>(){

            @Nullable
            public INBT writeNBT(Capability<T> capability, T instance, Direction side) {
                return null;
            }

            public void readNBT(Capability<T> capability, T instance, Direction side, INBT nbt) {
            }
        }, () -> {
            throw new OperationNotSupportedException();
        });
    }

    @Mod.EventBusSubscriber(modid="paraglider", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    private static final class ClientHandler {
        private ClientHandler() {
        }

        @SubscribeEvent
        public static void clientSetup(FMLClientSetupEvent event) {
            RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)Contents.WIND.get()), m -> new EntityRenderer<WindEntity>(m){

                public ResourceLocation getEntityTexture(WindEntity entity) {
                    return new ResourceLocation("missing");
                }
            });
            IItemPropertyGetter itemPropertyGetter = (stack, world, entity) -> entity instanceof PlayerEntity && ParagliderItem.hasParaglidingFlag(stack) ? 1.0f : 0.0f;
            ItemModelsProperties.func_239418_a_((Item)((Item)Contents.PARAGLIDER.get()), (ResourceLocation)new ResourceLocation("paragliding"), (IItemPropertyGetter)itemPropertyGetter);
            ItemModelsProperties.func_239418_a_((Item)((Item)Contents.DEKU_LEAF.get()), (ResourceLocation)new ResourceLocation("paragliding"), (IItemPropertyGetter)itemPropertyGetter);
        }

        @SubscribeEvent
        public static void addColorHandler(ColorHandlerEvent.Item event) {
            event.getItemColors().func_199877_a((stack, tint) -> tint > 0 ? -1 : ((IDyeableArmorItem)stack.func_77973_b()).func_200886_f(stack), new IItemProvider[]{(IItemProvider)Contents.PARAGLIDER.get(), (IItemProvider)Contents.DEKU_LEAF.get()});
        }
    }
}

