/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.event;

import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.server.FMLServerStartedEvent;
import net.minecraftforge.fml.network.PacketDistributor;
import tictim.paraglider.ModCfg;
import tictim.paraglider.ParagliderMod;
import tictim.paraglider.capabilities.ClientPlayerMovement;
import tictim.paraglider.capabilities.PlayerMovement;
import tictim.paraglider.capabilities.RemotePlayerMovement;
import tictim.paraglider.capabilities.ServerPlayerMovement;
import tictim.paraglider.item.ParagliderItem;
import tictim.paraglider.network.ModNet;
import tictim.paraglider.network.SyncParaglidingMsg;

@Mod.EventBusSubscriber(modid="paraglider")
public final class ParagliderEventHandler {
    private static final ResourceLocation MOVEMENT_HANDLER_KEY = new ResourceLocation("paraglider", "paragliding_movement_handler");

    private ParagliderEventHandler() {
    }

    @SubscribeEvent
    public static void serverSetup(FMLServerStartedEvent event) {
        if (ModCfg.forceFlightDisabled()) {
            event.getServer().func_71245_h(true);
        }
    }

    @SubscribeEvent
    public static void onPlayerInteract(PlayerInteractEvent event) {
        if (event.isCancelable() && event.getHand() == Hand.OFF_HAND && ParagliderItem.hasParaglidingFlag(event.getPlayer().func_184614_ca())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onClone(PlayerEvent.Clone event) {
        PlayerMovement m1 = (PlayerMovement)event.getOriginal().getCapability(PlayerMovement.CAP).orElse(null);
        PlayerMovement m2 = (PlayerMovement)event.getPlayer().getCapability(PlayerMovement.CAP).orElse(null);
        if (m1 != null && m2 != null) {
            m2.setRecoveryDelay(m1.getRecoveryDelay());
            m2.setStaminaVessels(m1.getStaminaVessels());
            m2.setHeartContainers(m1.getHeartContainers());
            m2.setStamina(m2.getMaxStamina());
        }
    }

    @SubscribeEvent
    public static void onPlayerUseItem(LivingEntityUseItemEvent.Tick event) {
        if (event.getEntityLiving().func_184600_cs() == Hand.OFF_HAND && event.getEntityLiving() instanceof PlayerEntity && ParagliderItem.hasParaglidingFlag(event.getEntityLiving().func_184614_ca())) {
            event.getEntityLiving().func_184602_cy();
        }
    }

    @SubscribeEvent
    public static void onAttachPlayerCapabilities(AttachCapabilitiesEvent<Entity> event) {
        Entity o = (Entity)event.getObject();
        if (o instanceof PlayerEntity) {
            PlayerEntity p = (PlayerEntity)o;
            PlayerMovement m = p instanceof ServerPlayerEntity ? new ServerPlayerMovement((ServerPlayerEntity)p) : (PlayerMovement)DistExecutor.unsafeRunForDist(() -> () -> Client.createPlayerMovement(p), () -> () -> new RemotePlayerMovement(p));
            event.addCapability(MOVEMENT_HANDLER_KEY, (ICapabilityProvider)m);
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        PlayerMovement h;
        if (event.phase == TickEvent.Phase.END && (h = (PlayerMovement)event.player.getCapability(PlayerMovement.CAP).orElse(null)) != null) {
            h.update();
        }
    }

    @SubscribeEvent
    public static void onLogin(PlayerEvent.PlayerLoggedInEvent event) {
        PlayerMovement h = (PlayerMovement)event.getPlayer().getCapability(PlayerMovement.CAP).orElse(null);
        if (h instanceof ServerPlayerMovement) {
            ServerPlayerMovement sh = (ServerPlayerMovement)h;
            sh.movementNeedsSync = true;
            sh.paraglidingNeedsSync = true;
            sh.vesselNeedsSync = true;
        }
    }

    @SubscribeEvent
    public static void onStartTracking(PlayerEvent.StartTracking event) {
        PlayerMovement h;
        PlayerEntity player = event.getPlayer();
        if (player instanceof ServerPlayerEntity && (h = (PlayerMovement)event.getTarget().getCapability(PlayerMovement.CAP).orElse(null)) != null) {
            SyncParaglidingMsg msg = new SyncParaglidingMsg(h);
            if (ModCfg.traceParaglidingPacket()) {
                ParagliderMod.LOGGER.debug("Sending packet {} from player {} to player {}", (Object)msg, (Object)h.player, (Object)player);
            }
            ModNet.NET.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)msg);
        }
    }

    private static final class Client {
        private Client() {
        }

        public static PlayerMovement createPlayerMovement(PlayerEntity player) {
            return player instanceof ClientPlayerEntity ? new ClientPlayerMovement(player) : new RemotePlayerMovement(player);
        }
    }
}

