/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.reap.corelib.client.obj;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import de.maxhenkel.reap.corelib.client.RenderUtils;
import de.maxhenkel.reap.corelib.client.obj.OBJLoader;
import java.util.List;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class OBJModel {
    private ResourceLocation model;
    private OBJModelData data;

    public OBJModel(ResourceLocation model) {
        this.model = model;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void load() {
        if (this.data == null) {
            this.data = OBJLoader.load(this.model);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void render(ResourceLocation texture, MatrixStack matrixStack, IRenderTypeBuffer buffer, int light) {
        this.load();
        matrixStack.func_227860_a_();
        IVertexBuilder builder = buffer.getBuffer(OBJModel.getRenderType(texture, true));
        for (int i = 0; i < this.data.faces.size(); ++i) {
            int[][] face = (int[][])this.data.faces.get(i);
            RenderUtils.vertex(builder, matrixStack, (Vector3f)this.data.positions.get(face[0][0]), (Vector2f)this.data.texCoords.get(face[0][1]), (Vector3f)this.data.normals.get(face[0][2]), light, OverlayTexture.field_229196_a_);
            RenderUtils.vertex(builder, matrixStack, (Vector3f)this.data.positions.get(face[1][0]), (Vector2f)this.data.texCoords.get(face[1][1]), (Vector3f)this.data.normals.get(face[1][2]), light, OverlayTexture.field_229196_a_);
            RenderUtils.vertex(builder, matrixStack, (Vector3f)this.data.positions.get(face[2][0]), (Vector2f)this.data.texCoords.get(face[2][1]), (Vector3f)this.data.normals.get(face[2][2]), light, OverlayTexture.field_229196_a_);
        }
        matrixStack.func_227865_b_();
    }

    @OnlyIn(value=Dist.CLIENT)
    private static RenderType getRenderType(ResourceLocation resourceLocation, boolean culling) {
        RenderType.State state = RenderType.State.func_228694_a_().func_228724_a_(new RenderState.TextureState(resourceLocation, false, false)).func_228726_a_(new RenderState.TransparencyState("no_transparency", RenderSystem::disableBlend, () -> {})).func_228716_a_(new RenderState.DiffuseLightingState(false)).func_228713_a_(new RenderState.AlphaState(0.003921569f)).func_228719_a_(new RenderState.LightmapState(true)).func_228722_a_(new RenderState.OverlayState(true)).func_228714_a_(new RenderState.CullState(culling)).func_228728_a_(true);
        return RenderType.func_228633_a_((String)"entity_cutout", (VertexFormat)DefaultVertexFormats.field_227849_i_, (int)4, (int)256, (boolean)true, (boolean)false, (RenderType.State)state);
    }

    static class OBJModelData {
        private List<Vector3f> positions;
        private List<Vector2f> texCoords;
        private List<Vector3f> normals;
        private List<int[][]> faces;

        public OBJModelData(List<Vector3f> positions, List<Vector2f> texCoords, List<Vector3f> normals, List<int[][]> faces) {
            this.positions = positions;
            this.texCoords = texCoords;
            this.normals = normals;
            this.faces = faces;
        }

        public List<Vector3f> getPositions() {
            return this.positions;
        }

        public List<Vector2f> getTexCoords() {
            return this.texCoords;
        }

        public List<Vector3f> getNormals() {
            return this.normals;
        }

        public List<int[][]> getFaces() {
            return this.faces;
        }
    }
}

