/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.reap.corelib.inventory;

import de.maxhenkel.reap.corelib.sound.SoundUtils;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.LootTable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.server.ServerWorld;

public abstract class ShulkerBoxInventory
implements IInventory,
INamedContainerProvider {
    protected NonNullList<ItemStack> items;
    protected ItemStack shulkerBox;
    protected int invSize;
    protected CompoundNBT blockEntityTag;
    protected ResourceLocation lootTable;
    protected long lootTableSeed;

    public ShulkerBoxInventory(PlayerEntity player, ItemStack shulkerBox, int invSize) {
        this.shulkerBox = shulkerBox;
        this.invSize = invSize;
        this.items = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        this.func_174889_b(player);
        CompoundNBT c = shulkerBox.func_77978_p();
        if (c == null) {
            return;
        }
        if (!c.func_74764_b("BlockEntityTag")) {
            return;
        }
        this.blockEntityTag = c.func_74775_l("BlockEntityTag");
        if (this.blockEntityTag.func_74764_b("Items")) {
            ItemStackHelper.func_191283_b((CompoundNBT)this.blockEntityTag, this.items);
        } else if (this.blockEntityTag.func_74764_b("LootTable")) {
            this.lootTable = new ResourceLocation(this.blockEntityTag.func_74779_i("LootTable"));
            this.lootTableSeed = this.blockEntityTag.func_74763_f("LootTableSeed");
            this.fillWithLoot(player);
            this.blockEntityTag.func_82580_o("LootTable");
            this.blockEntityTag.func_82580_o("LootTableSeed");
        }
    }

    public ShulkerBoxInventory(PlayerEntity player, ItemStack shulkerBox) {
        this(player, shulkerBox, 27);
    }

    public void fillWithLoot(@Nullable PlayerEntity player) {
        if (this.lootTable != null && player != null) {
            LootTable loottable = player.field_70170_p.func_73046_m().func_200249_aQ().func_186521_a(this.lootTable);
            this.lootTable = null;
            LootContext.Builder builder = new LootContext.Builder((ServerWorld)player.field_70170_p);
            if (this.lootTableSeed != 0L) {
                builder.func_216016_a(this.lootTableSeed);
            }
            builder.func_186469_a(player.func_184817_da()).func_216015_a(LootParameters.field_216281_a, (Object)player);
            loottable.func_216118_a((IInventory)this, builder.func_216022_a(LootParameterSets.field_216261_b));
            this.func_70296_d();
        }
    }

    public int func_70302_i_() {
        return this.invSize;
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.items.get(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        ItemStack itemstack = ItemStackHelper.func_188382_a(this.items, (int)index, (int)count);
        this.func_70296_d();
        return itemstack;
    }

    public ItemStack func_70304_b(int index) {
        ItemStack stack = ItemStackHelper.func_188383_a(this.items, (int)index);
        this.func_70296_d();
        return stack;
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.items.set(index, (Object)stack);
        this.func_70296_d();
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
        CompoundNBT tag = this.shulkerBox.func_196082_o();
        if (this.blockEntityTag == null) {
            this.blockEntityTag = new CompoundNBT();
            tag.func_218657_a("BlockEntityTag", (INBT)this.blockEntityTag);
        } else {
            tag.func_218657_a("BlockEntityTag", (INBT)this.blockEntityTag);
        }
        ItemStackHelper.func_191281_a((CompoundNBT)this.blockEntityTag, this.items, (boolean)true);
    }

    public void func_174889_b(PlayerEntity player) {
        player.field_70170_p.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), this.getOpenSound(), SoundCategory.BLOCKS, 0.5f, SoundUtils.getVariatedPitch(player.field_70170_p));
    }

    public void func_174886_c(PlayerEntity player) {
        this.func_70296_d();
        player.field_70170_p.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), this.getCloseSound(), SoundCategory.BLOCKS, 0.5f, player.field_70170_p.field_73012_v.nextFloat() * 0.1f + 0.9f);
    }

    protected SoundEvent getOpenSound() {
        return SoundEvents.field_191262_fB;
    }

    protected SoundEvent getCloseSound() {
        return SoundEvents.field_191261_fA;
    }

    public void func_174888_l() {
        this.items.clear();
        this.func_70296_d();
    }

    public boolean func_191420_l() {
        return this.items.isEmpty();
    }

    public boolean func_70300_a(PlayerEntity player) {
        for (Hand hand : Hand.values()) {
            if (!player.func_184586_b(hand).equals(this.shulkerBox)) continue;
            return true;
        }
        return false;
    }

    public ITextComponent func_145748_c_() {
        return this.shulkerBox.func_200301_q();
    }

    @Nullable
    public abstract Container createMenu(int var1, PlayerInventory var2, PlayerEntity var3);
}

