/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.function.Supplier;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.annotation.Nullable;

public class WorldEditManifest {
    public static final String WORLD_EDIT_VERSION = "WorldEdit-Version";
    private final String worldEditVersion;

    public static WorldEditManifest load() {
        Attributes attributes = WorldEditManifest.readAttributes();
        return new WorldEditManifest(WorldEditManifest.readAttribute(attributes, WORLD_EDIT_VERSION, () -> "(unknown)"));
    }

    @Nullable
    private static Attributes readAttributes() {
        Class<WorldEditManifest> clazz = WorldEditManifest.class;
        String className = clazz.getSimpleName() + ".class";
        String classPath = clazz.getResource(className).toString();
        if (!classPath.startsWith("jar")) {
            return null;
        }
        try {
            URL url = new URL(classPath);
            JarURLConnection jarConnection = (JarURLConnection)url.openConnection();
            Manifest manifest = jarConnection.getManifest();
            return manifest.getMainAttributes();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static String readAttribute(@Nullable Attributes attributes, String name, Supplier<String> defaultAction) {
        if (attributes == null) {
            return defaultAction.get();
        }
        String value = attributes.getValue(name);
        return value != null ? value : defaultAction.get();
    }

    private WorldEditManifest(String worldEditVersion) {
        this.worldEditVersion = worldEditVersion;
    }

    public String getWorldEditVersion() {
        return this.worldEditVersion;
    }
}

