/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.forge;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Futures;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.blocks.BaseItem;
import com.sk89q.worldedit.blocks.BaseItemStack;
import com.sk89q.worldedit.entity.BaseEntity;
import com.sk89q.worldedit.entity.Entity;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.forge.ForgeAdapter;
import com.sk89q.worldedit.forge.ForgeEntity;
import com.sk89q.worldedit.forge.ForgeWorldEdit;
import com.sk89q.worldedit.forge.WorldEditFakePlayer;
import com.sk89q.worldedit.forge.WorldEditGenListener;
import com.sk89q.worldedit.forge.internal.ForgeWorldNativeAccess;
import com.sk89q.worldedit.forge.internal.NBTConverter;
import com.sk89q.worldedit.forge.internal.TileEntityUtils;
import com.sk89q.worldedit.internal.Constants;
import com.sk89q.worldedit.internal.block.BlockStateIdAccess;
import com.sk89q.worldedit.internal.util.BiomeMath;
import com.sk89q.worldedit.math.BlockVector2;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.math.Vector3;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.util.Direction;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.util.SideEffect;
import com.sk89q.worldedit.util.SideEffectSet;
import com.sk89q.worldedit.util.TreeGenerator;
import com.sk89q.worldedit.util.io.file.SafeFiles;
import com.sk89q.worldedit.world.AbstractWorld;
import com.sk89q.worldedit.world.RegenOptions;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.item.ItemTypes;
import com.sk89q.worldedit.world.weather.WeatherType;
import com.sk89q.worldedit.world.weather.WeatherTypes;
import java.lang.ref.WeakReference;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IClearable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.resources.IResourceManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.WorldSettingsImport;
import net.minecraft.world.Dimension;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeContainer;
import net.minecraft.world.biome.ColumnFuzzedBiomeMagnifier;
import net.minecraft.world.biome.IBiomeMagnifier;
import net.minecraft.world.chunk.AbstractChunkProvider;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.chunk.listener.IChunkStatusListener;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Features;
import net.minecraft.world.gen.settings.DimensionGeneratorSettings;
import net.minecraft.world.server.ServerChunkProvider;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.IServerWorldInfo;
import net.minecraft.world.storage.IWorldInfo;
import net.minecraft.world.storage.SaveFormat;
import net.minecraft.world.storage.ServerWorldInfo;

public class ForgeWorld
extends AbstractWorld {
    private static final Random random = new Random();
    private final WeakReference<World> worldRef;
    private final ForgeWorldNativeAccess nativeAccess;
    private static final LoadingCache<ServerWorld, WorldEditFakePlayer> fakePlayers = CacheBuilder.newBuilder().weakKeys().softValues().build(CacheLoader.from(WorldEditFakePlayer::new));

    private static ResourceLocation getDimensionRegistryKey(World world) {
        return Objects.requireNonNull(world.func_73046_m(), "server cannot be null").func_244267_aX().func_230520_a_().func_177774_c((Object)world.func_230315_m_());
    }

    ForgeWorld(World world) {
        Preconditions.checkNotNull((Object)world);
        this.worldRef = new WeakReference<World>(world);
        this.nativeAccess = new ForgeWorldNativeAccess(this.worldRef);
    }

    public World getWorld() {
        World world = (World)this.worldRef.get();
        if (world != null) {
            return world;
        }
        throw new RuntimeException("The reference to the world was lost (i.e. the world may have been unloaded)");
    }

    @Override
    public String getName() {
        return ((IServerWorldInfo)this.getWorld().func_72912_H()).func_76065_j();
    }

    @Override
    public String getId() {
        return this.getName() + "_" + ForgeWorld.getDimensionRegistryKey(this.getWorld());
    }

    @Override
    public Path getStoragePath() {
        World world = this.getWorld();
        if (world instanceof ServerWorld) {
            SaveFormat.LevelSave session = ((ServerWorld)world).func_73046_m().field_71310_m;
            return session.func_237291_a_(world.func_234923_W_()).toPath();
        }
        return null;
    }

    @Override
    public <B extends BlockStateHolder<B>> boolean setBlock(BlockVector3 position, B block, SideEffectSet sideEffects) throws WorldEditException {
        this.clearContainerBlockContents(position);
        return this.nativeAccess.setBlock(position, block, sideEffects);
    }

    @Override
    public Set<SideEffect> applySideEffects(BlockVector3 position, BlockState previousType, SideEffectSet sideEffectSet) {
        this.nativeAccess.applySideEffects(position, previousType, sideEffectSet);
        return Sets.intersection(ForgeWorldEdit.inst.getPlatform().getSupportedSideEffects(), sideEffectSet.getSideEffectsToApply());
    }

    @Override
    public int getBlockLightLevel(BlockVector3 position) {
        Preconditions.checkNotNull((Object)position);
        return this.getWorld().func_201696_r(ForgeAdapter.toBlockPos(position));
    }

    @Override
    public boolean clearContainerBlockContents(BlockVector3 position) {
        Preconditions.checkNotNull((Object)position);
        TileEntity tile = this.getWorld().func_175625_s(ForgeAdapter.toBlockPos(position));
        if (tile instanceof IClearable) {
            ((IClearable)tile).func_174888_l();
            return true;
        }
        return false;
    }

    @Override
    public boolean fullySupports3DBiomes() {
        IBiomeMagnifier magnifier = this.getWorld().func_230315_m_().func_227176_e_();
        return !(magnifier instanceof ColumnFuzzedBiomeMagnifier);
    }

    @Override
    public BiomeType getBiome(BlockVector3 position) {
        Preconditions.checkNotNull((Object)position);
        Chunk chunk = this.getWorld().func_212866_a_(position.getBlockX() >> 4, position.getBlockZ() >> 4);
        return this.getBiomeInChunk(position, (IChunk)chunk);
    }

    private BiomeType getBiomeInChunk(BlockVector3 position, IChunk chunk) {
        BiomeContainer biomes = (BiomeContainer)Preconditions.checkNotNull((Object)chunk.func_225549_i_());
        return ForgeAdapter.adapt(biomes.func_225526_b_(position.getX() >> 2, position.getY() >> 2, position.getZ() >> 2));
    }

    @Override
    public boolean setBiome(BlockVector3 position, BiomeType biome) {
        Preconditions.checkNotNull((Object)position);
        Preconditions.checkNotNull((Object)biome);
        Chunk chunk = this.getWorld().func_212866_a_(position.getBlockX() >> 4, position.getBlockZ() >> 4);
        BiomeContainer container = (BiomeContainer)Preconditions.checkNotNull((Object)chunk.func_225549_i_());
        int idx = BiomeMath.computeBiomeIndex(position.getX(), position.getY(), position.getZ());
        container.field_227054_f_[idx] = ForgeAdapter.adapt(biome);
        chunk.func_177427_f(true);
        return true;
    }

    @Override
    public boolean useItem(BlockVector3 position, BaseItem item, Direction face) {
        WorldEditFakePlayer fakePlayer;
        ItemStack stack = ForgeAdapter.adapt(new BaseItemStack(item.getType(), item.getNbtData(), 1));
        ServerWorld world = (ServerWorld)this.getWorld();
        try {
            fakePlayer = (WorldEditFakePlayer)((Object)fakePlayers.get((Object)world));
        }
        catch (ExecutionException ignored) {
            return false;
        }
        fakePlayer.func_184611_a(Hand.MAIN_HAND, stack);
        fakePlayer.func_70012_b(position.getBlockX(), position.getBlockY(), position.getBlockZ(), (float)face.toVector().toYaw(), (float)face.toVector().toPitch());
        BlockPos blockPos = ForgeAdapter.toBlockPos(position);
        BlockRayTraceResult rayTraceResult = new BlockRayTraceResult(ForgeAdapter.toVec3(position), ForgeAdapter.adapt(face), blockPos, false);
        ItemUseContext itemUseContext = new ItemUseContext((PlayerEntity)fakePlayer, Hand.MAIN_HAND, rayTraceResult);
        ActionResultType used = stack.func_196084_a(itemUseContext);
        if (used != ActionResultType.SUCCESS) {
            ActionResultType resultType = this.getWorld().func_180495_p(blockPos).func_227031_a_((World)world, (PlayerEntity)fakePlayer, Hand.MAIN_HAND, rayTraceResult);
            used = resultType.func_226246_a_() ? resultType : stack.func_77973_b().func_77659_a((World)world, (PlayerEntity)fakePlayer, Hand.MAIN_HAND).func_188397_a();
        }
        return used == ActionResultType.SUCCESS;
    }

    @Override
    public void dropItem(Vector3 position, BaseItemStack item) {
        Preconditions.checkNotNull((Object)position);
        Preconditions.checkNotNull((Object)item);
        if (item.getType() == ItemTypes.AIR) {
            return;
        }
        ItemEntity entity = new ItemEntity(this.getWorld(), position.getX(), position.getY(), position.getZ(), ForgeAdapter.adapt(item));
        entity.func_174867_a(10);
        this.getWorld().func_217376_c((net.minecraft.entity.Entity)entity);
    }

    @Override
    public void simulateBlockMine(BlockVector3 position) {
        BlockPos pos = ForgeAdapter.toBlockPos(position);
        this.getWorld().func_175655_b(pos, true);
    }

    @Override
    public boolean canPlaceAt(BlockVector3 position, BlockState blockState) {
        return ForgeAdapter.adapt(blockState).func_196955_c((IWorldReader)this.getWorld(), ForgeAdapter.toBlockPos(position));
    }

    @Override
    public boolean regenerate(Region region, Extent extent, RegenOptions options) {
        AbstractChunkProvider provider = this.getWorld().func_72863_F();
        if (!(provider instanceof ServerChunkProvider)) {
            return false;
        }
        try {
            this.doRegen(region, extent, options);
        }
        catch (Exception e) {
            throw new IllegalStateException("Regen failed", e);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRegen(Region region, Extent extent, RegenOptions options) throws Exception {
        Path tempDir = Files.createTempDirectory("WorldEditWorldGen", new FileAttribute[0]);
        SaveFormat levelStorage = SaveFormat.func_237269_a_((Path)tempDir);
        try (SaveFormat.LevelSave session = levelStorage.func_237274_c_("WorldEditTempGen");){
            DimensionGeneratorSettings newOpts;
            ServerWorld originalWorld = (ServerWorld)this.getWorld();
            long seed = options.getSeed().orElse(originalWorld.func_72905_C());
            ServerWorldInfo levelProperties = (ServerWorldInfo)originalWorld.func_73046_m().func_240793_aU_();
            DimensionGeneratorSettings originalOpts = levelProperties.field_237343_c_;
            WorldSettingsImport nbtRegOps = WorldSettingsImport.func_244335_a((DynamicOps)NBTDynamicOps.field_210820_a, (IResourceManager)originalWorld.func_73046_m().getDataPackRegistries().func_240970_h_(), (DynamicRegistries.Impl)((DynamicRegistries.Impl)originalWorld.func_73046_m().func_244267_aX()));
            Codec dimCodec = DimensionGeneratorSettings.field_236201_a_;
            levelProperties.field_237343_c_ = newOpts = (DimensionGeneratorSettings)dimCodec.encodeStart((DynamicOps)nbtRegOps, (Object)originalOpts).flatMap(tag -> dimCodec.parse(this.recursivelySetSeed((Dynamic<INBT>)new Dynamic((DynamicOps)nbtRegOps, tag), seed, new HashSet<Dynamic<INBT>>()))).get().map(l -> l, error -> {
                throw new IllegalStateException("Unable to map GeneratorOptions: " + error.message());
            });
            RegistryKey worldRegKey = originalWorld.func_234923_W_();
            Dimension dimGenOpts = (Dimension)newOpts.func_236224_e_().func_82594_a(worldRegKey.func_240901_a_());
            Preconditions.checkNotNull((Object)dimGenOpts, (String)"No DimensionOptions for %s", (Object)worldRegKey);
            try (ServerWorld serverWorld = new ServerWorld(originalWorld.func_73046_m(), Util.func_215072_e(), session, (IServerWorldInfo)originalWorld.func_72912_H(), worldRegKey, originalWorld.func_230315_m_(), (IChunkStatusListener)new WorldEditGenListener(), dimGenOpts.func_236064_c_(), originalWorld.func_234925_Z_(), seed, (List)ImmutableList.of(), false);){
                this.regenForWorld(region, extent, serverWorld, options);
                while (originalWorld.func_73046_m().func_213168_p()) {
                    Thread.yield();
                }
            }
            finally {
                levelProperties.field_237343_c_ = originalOpts;
            }
        }
        finally {
            SafeFiles.tryHardToDeleteDir(tempDir);
        }
    }

    private Dynamic<INBT> recursivelySetSeed(Dynamic<INBT> dynamic, long seed, Set<Dynamic<INBT>> seen) {
        if (!seen.add(dynamic)) {
            return dynamic;
        }
        return dynamic.updateMapValues(pair -> {
            if (((Dynamic)pair.getFirst()).asString("").equals("seed")) {
                return pair.mapSecond(v -> v.createLong(seed));
            }
            if (((Dynamic)pair.getSecond()).getValue() instanceof CompoundNBT) {
                return pair.mapSecond(v -> this.recursivelySetSeed((Dynamic<INBT>)v, seed, seen));
            }
            return pair;
        });
    }

    private void regenForWorld(Region region, Extent extent, ServerWorld serverWorld, RegenOptions options) throws WorldEditException {
        List<CompletableFuture<IChunk>> chunkLoadings = this.submitChunkLoadTasks(region, serverWorld);
        ServerChunkProvider.ChunkExecutor executor = serverWorld.func_72863_F().field_217243_i;
        executor.func_213161_c(() -> {
            if (chunkLoadings.stream().anyMatch(ftr -> ftr.isDone() && Futures.getUnchecked((Future)ftr) == null)) {
                return false;
            }
            return chunkLoadings.stream().allMatch(CompletableFuture::isDone);
        });
        HashMap<ChunkPos, IChunk> chunks = new HashMap<ChunkPos, IChunk>();
        for (CompletableFuture<IChunk> future : chunkLoadings) {
            IChunk chunk = future.getNow(null);
            Preconditions.checkState((chunk != null ? 1 : 0) != 0, (Object)"Failed to generate a chunk, regen failed.");
            chunks.put(chunk.func_76632_l(), chunk);
        }
        for (BlockVector3 vec : region) {
            BlockPos pos = ForgeAdapter.toBlockPos(vec);
            IChunk chunk = (IChunk)chunks.get(new ChunkPos(pos));
            BlockStateHolder<BlockState> state = ForgeAdapter.adapt(chunk.func_180495_p(pos));
            TileEntity blockEntity = chunk.func_175625_s(pos);
            if (blockEntity != null) {
                CompoundNBT tag = new CompoundNBT();
                blockEntity.func_189515_b(tag);
                state = state.toBaseBlock(NBTConverter.fromNative(tag));
            }
            extent.setBlock(vec, state.toBaseBlock());
            if (!options.shouldRegenBiomes()) continue;
            BiomeType biome = this.getBiomeInChunk(vec, chunk);
            extent.setBiome(vec, biome);
        }
    }

    private List<CompletableFuture<IChunk>> submitChunkLoadTasks(Region region, ServerWorld world) {
        ArrayList<CompletableFuture<IChunk>> chunkLoadings = new ArrayList<CompletableFuture<IChunk>>();
        for (BlockVector2 chunk : region.getChunks()) {
            chunkLoadings.add((CompletableFuture<IChunk>)world.func_72863_F().func_217233_c(chunk.getX(), chunk.getZ(), ChunkStatus.field_222613_i, true).thenApply(either -> either.left().orElse(null)));
        }
        return chunkLoadings;
    }

    @Nullable
    private static ConfiguredFeature<?, ?> createTreeFeatureGenerator(TreeGenerator.TreeType type) {
        switch (type) {
            case TREE: {
                return Features.field_243862_bH;
            }
            case BIG_TREE: {
                return Features.field_243869_bO;
            }
            case REDWOOD: {
                return Features.field_243866_bL;
            }
            case TALL_REDWOOD: {
                return Features.field_243872_bR;
            }
            case MEGA_REDWOOD: {
                return Features.field_243873_bS;
            }
            case BIRCH: {
                return Features.field_243864_bJ;
            }
            case JUNGLE: {
                return Features.field_243871_bQ;
            }
            case SMALL_JUNGLE: {
                return Features.field_243868_bN;
            }
            case SHORT_JUNGLE: {
                return Features.field_243870_bP;
            }
            case JUNGLE_BUSH: {
                return Features.field_243876_bV;
            }
            case SWAMP: {
                return Features.field_243875_bU;
            }
            case ACACIA: {
                return Features.field_243865_bK;
            }
            case DARK_OAK: {
                return Features.field_243863_bI;
            }
            case TALL_BIRCH: {
                return Features.field_243940_cw;
            }
            case RED_MUSHROOM: {
                return Features.field_243860_bF;
            }
            case BROWN_MUSHROOM: {
                return Features.field_243861_bG;
            }
            case WARPED_FUNGUS: {
                return Features.field_243858_bD;
            }
            case CRIMSON_FUNGUS: {
                return Features.field_243856_bB;
            }
            case CHORUS_PLANT: {
                return Features.field_243944_d;
            }
            case RANDOM: {
                return ForgeWorld.createTreeFeatureGenerator(TreeGenerator.TreeType.values()[ThreadLocalRandom.current().nextInt(TreeGenerator.TreeType.values().length)]);
            }
        }
        return null;
    }

    @Override
    public boolean generateTree(TreeGenerator.TreeType type, EditSession editSession, BlockVector3 position) {
        ConfiguredFeature<?, ?> generator = ForgeWorld.createTreeFeatureGenerator(type);
        ServerWorld world = (ServerWorld)this.getWorld();
        ServerChunkProvider chunkManager = world.func_72863_F();
        return generator != null && generator.func_242765_a((ISeedReader)world, chunkManager.func_201711_g(), random, ForgeAdapter.toBlockPos(position));
    }

    @Override
    public void checkLoadedChunk(BlockVector3 pt) {
        this.getWorld().func_217349_x(ForgeAdapter.toBlockPos(pt));
    }

    @Override
    public void fixAfterFastMode(Iterable<BlockVector2> chunks) {
        this.fixLighting(chunks);
    }

    @Override
    public void fixLighting(Iterable<BlockVector2> chunks) {
        World world = this.getWorld();
        for (BlockVector2 chunk : chunks) {
            world.func_72863_F().func_212863_j_().func_223115_b(new ChunkPos(chunk.getBlockX(), chunk.getBlockZ()), true);
        }
    }

    @Override
    public boolean playEffect(Vector3 position, int type, int data) {
        this.getWorld().func_217379_c(type, ForgeAdapter.toBlockPos(position.toBlockPoint()), data);
        return true;
    }

    @Override
    public WeatherType getWeather() {
        IWorldInfo info = this.getWorld().func_72912_H();
        if (info.func_76061_m()) {
            return WeatherTypes.THUNDER_STORM;
        }
        if (info.func_76059_o()) {
            return WeatherTypes.RAIN;
        }
        return WeatherTypes.CLEAR;
    }

    @Override
    public long getRemainingWeatherDuration() {
        IServerWorldInfo info = (IServerWorldInfo)this.getWorld().func_72912_H();
        if (info.func_76061_m()) {
            return info.func_76071_n();
        }
        if (info.func_76059_o()) {
            return info.func_76083_p();
        }
        return info.func_230395_g_();
    }

    @Override
    public void setWeather(WeatherType weatherType) {
        this.setWeather(weatherType, 0L);
    }

    @Override
    public void setWeather(WeatherType weatherType, long duration) {
        IServerWorldInfo info = (IServerWorldInfo)this.getWorld().func_72912_H();
        if (weatherType == WeatherTypes.THUNDER_STORM) {
            info.func_230391_a_(0);
            info.func_76069_a(true);
            info.func_76090_f((int)duration);
        } else if (weatherType == WeatherTypes.RAIN) {
            info.func_230391_a_(0);
            info.func_76084_b(true);
            info.func_76080_g((int)duration);
        } else if (weatherType == WeatherTypes.CLEAR) {
            info.func_76084_b(false);
            info.func_76069_a(false);
            info.func_230391_a_((int)duration);
        }
    }

    @Override
    public int getMinY() {
        return 0;
    }

    @Override
    public int getMaxY() {
        return this.getWorld().func_217301_I() - 1;
    }

    @Override
    public BlockVector3 getSpawnPosition() {
        IWorldInfo worldInfo = this.getWorld().func_72912_H();
        return BlockVector3.at(worldInfo.func_76079_c(), worldInfo.func_76075_d(), worldInfo.func_76074_e());
    }

    @Override
    public BlockState getBlock(BlockVector3 position) {
        net.minecraft.block.BlockState mcState = this.getWorld().func_212866_a_(position.getBlockX() >> 4, position.getBlockZ() >> 4).func_180495_p(ForgeAdapter.toBlockPos(position));
        BlockState matchingBlock = BlockStateIdAccess.getBlockStateById(Block.func_196246_j((net.minecraft.block.BlockState)mcState));
        if (matchingBlock != null) {
            return matchingBlock;
        }
        return ForgeAdapter.adapt(mcState);
    }

    @Override
    public BaseBlock getFullBlock(BlockVector3 position) {
        BlockPos pos = new BlockPos(position.getBlockX(), position.getBlockY(), position.getBlockZ());
        TileEntity tile = this.getWorld().func_217349_x(pos).func_175625_s(pos);
        if (tile != null) {
            return this.getBlock(position).toBaseBlock(NBTConverter.fromNative(TileEntityUtils.copyNbtData(tile)));
        }
        return this.getBlock(position).toBaseBlock();
    }

    @Override
    public int hashCode() {
        return this.getWorld().hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof ForgeWorld) {
            ForgeWorld other = (ForgeWorld)o;
            World otherWorld = (World)other.worldRef.get();
            World thisWorld = (World)this.worldRef.get();
            return otherWorld != null && otherWorld.equals(thisWorld);
        }
        if (o instanceof com.sk89q.worldedit.world.World) {
            return ((com.sk89q.worldedit.world.World)o).getName().equals(this.getName());
        }
        return false;
    }

    @Override
    public List<? extends Entity> getEntities(Region region) {
        World world = this.getWorld();
        AxisAlignedBB box = new AxisAlignedBB(ForgeAdapter.toBlockPos(region.getMinimumPoint()), ForgeAdapter.toBlockPos(region.getMaximumPoint().add(BlockVector3.ONE)));
        List nmsEntities = world.func_217394_a((EntityType)null, box, e -> region.contains(ForgeAdapter.adapt(e.func_233580_cy_())));
        return ImmutableList.copyOf((Collection)Lists.transform((List)nmsEntities, ForgeEntity::new));
    }

    @Override
    public List<? extends Entity> getEntities() {
        World world = this.getWorld();
        if (!(world instanceof ServerWorld)) {
            return Collections.emptyList();
        }
        return ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)((ServerWorld)world).func_241136_z_(), ForgeEntity::new));
    }

    @Override
    @Nullable
    public Entity createEntity(Location location, BaseEntity entity) {
        World world = this.getWorld();
        Optional entityType = EntityType.func_220327_a((String)entity.getType().getId());
        if (!entityType.isPresent()) {
            return null;
        }
        net.minecraft.entity.Entity createdEntity = ((EntityType)entityType.get()).func_200721_a(world);
        if (createdEntity != null) {
            CompoundTag nativeTag = entity.getNbtData();
            if (nativeTag != null) {
                CompoundNBT tag = NBTConverter.toNative(entity.getNbtData());
                for (String name : Constants.NO_COPY_ENTITY_NBT_FIELDS) {
                    tag.func_82580_o(name);
                }
                createdEntity.func_70020_e(tag);
            }
            createdEntity.func_70012_b(location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
            world.func_217376_c(createdEntity);
            return new ForgeEntity(createdEntity);
        }
        return null;
    }
}

