/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.modenforcer;

import de.maxhenkel.modenforcer.Main;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ServerEvents {
    private static ServerEvents instance;
    private Map<UUID, Long> players = new HashMap<UUID, Long>();

    private ServerEvents() {
    }

    @SubscribeEvent
    public void onLogIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (!(event.getPlayer() instanceof ServerPlayerEntity)) {
            return;
        }
        ServerPlayerEntity player = (ServerPlayerEntity)event.getPlayer();
        this.players.put(player.func_110124_au(), System.currentTimeMillis());
    }

    @SubscribeEvent
    public void onLogOut(PlayerEvent.PlayerLoggedOutEvent event) {
        if (!(event.getPlayer() instanceof ServerPlayerEntity)) {
            return;
        }
        ServerPlayerEntity player = (ServerPlayerEntity)event.getPlayer();
        this.players.remove(player.func_110124_au());
    }

    @SubscribeEvent
    public void onTick(TickEvent.PlayerTickEvent event) {
        if (!event.phase.equals((Object)TickEvent.Phase.END)) {
            return;
        }
        if (!(event.player instanceof ServerPlayerEntity)) {
            return;
        }
        ServerPlayerEntity player = (ServerPlayerEntity)event.player;
        Long timestamp = this.players.get(player.func_110124_au());
        if (timestamp == null) {
            return;
        }
        if (System.currentTimeMillis() - timestamp > ((Integer)Main.SERVER_CONFIG.playerTimeout.get()).longValue()) {
            player.field_71135_a.func_194028_b((ITextComponent)new StringTextComponent("Missing mods"));
        }
    }

    public void setPlayerAuthorized(PlayerEntity playerEntity) {
        this.players.remove(playerEntity.func_110124_au());
    }

    public static ServerEvents instance() {
        if (instance == null) {
            instance = new ServerEvents();
        }
        return instance;
    }
}

