/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.modenforcer.net;

import de.maxhenkel.modenforcer.ServerEvents;
import de.maxhenkel.modenforcer.corelib.net.Message;
import de.maxhenkel.modenforcer.types.BasicModInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.moddiscovery.ModInfo;
import net.minecraftforge.fml.network.NetworkEvent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class MessageModList
implements Message<MessageModList> {
    private List<BasicModInfo> mods;

    public MessageModList() {
    }

    public MessageModList(List<ModInfo> mods) {
        this.mods = mods.stream().map(BasicModInfo::new).collect(Collectors.toList());
    }

    @Override
    public Dist getExecutingSide() {
        return Dist.DEDICATED_SERVER;
    }

    @Override
    public void executeServerSide(NetworkEvent.Context context) {
        ArrayList<ImmutablePair> mismatches = new ArrayList<ImmutablePair>();
        for (ModInfo i : ModList.get().getMods()) {
            BasicModInfo basicModInfo = new BasicModInfo(i);
            BasicModInfo matchedInfo = this.mods.stream().filter(info -> info.getModid().equals(basicModInfo.getModid())).findFirst().orElse(null);
            if (matchedInfo == null) {
                mismatches.add(new ImmutablePair((Object)basicModInfo, null));
                continue;
            }
            if (matchedInfo.getVersion().equals(basicModInfo.getVersion())) continue;
            mismatches.add(new ImmutablePair((Object)basicModInfo, (Object)matchedInfo));
        }
        if (mismatches.isEmpty()) {
            ServerEvents.instance().setPlayerAuthorized((PlayerEntity)context.getSender());
            return;
        }
        TranslationTextComponent text = new TranslationTextComponent("message.modenforcer.mismatching_mods");
        text.func_240702_b_("\n");
        for (Pair pair : mismatches) {
            text.func_240702_b_("\n");
            IFormattableTextComponent comp = pair.getRight() == null ? new TranslationTextComponent("message.modenforcer.missing_mod").func_240699_a_(TextFormatting.RED) : new TranslationTextComponent("message.modenforcer.version_mismatch", new Object[]{new StringTextComponent(((BasicModInfo)pair.getRight()).getVersion()).func_240699_a_(TextFormatting.RED), new StringTextComponent(((BasicModInfo)pair.getLeft()).getVersion()).func_240699_a_(TextFormatting.GREEN)}).func_240699_a_(TextFormatting.GRAY);
            text.func_230529_a_((ITextComponent)new TranslationTextComponent("message.modenforcer.mismatched_mod", new Object[]{new StringTextComponent(((BasicModInfo)pair.getLeft()).getName()).func_240699_a_(TextFormatting.WHITE), comp}).func_240699_a_(TextFormatting.GRAY));
        }
        context.getSender().field_71135_a.func_194028_b((ITextComponent)text);
    }

    @Override
    public MessageModList fromBytes(PacketBuffer buf) {
        int count = buf.readInt();
        this.mods = new ArrayList<BasicModInfo>();
        for (int i = 0; i < count; ++i) {
            this.mods.add(new BasicModInfo(buf.func_150789_c(256), buf.func_150789_c(256), buf.func_150789_c(256)));
        }
        return this;
    }

    @Override
    public void toBytes(PacketBuffer buf) {
        buf.writeInt(this.mods.size());
        for (BasicModInfo modInfo : this.mods) {
            buf.func_180714_a(modInfo.getName());
            buf.func_180714_a(modInfo.getModid());
            buf.func_180714_a(modInfo.getVersion());
        }
    }
}

