/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap;

import com.mamiyaotaru.voxelmap.MapSettingsManager;
import com.mamiyaotaru.voxelmap.interfaces.AbstractVoxelMap;
import com.mamiyaotaru.voxelmap.interfaces.IVoxelMap;
import com.mamiyaotaru.voxelmap.interfaces.IWaypointManager;
import com.mamiyaotaru.voxelmap.textures.IIconCreator;
import com.mamiyaotaru.voxelmap.textures.Sprite;
import com.mamiyaotaru.voxelmap.textures.TextureAtlas;
import com.mamiyaotaru.voxelmap.util.BackgroundImageInfo;
import com.mamiyaotaru.voxelmap.util.DimensionContainer;
import com.mamiyaotaru.voxelmap.util.GLUtils;
import com.mamiyaotaru.voxelmap.util.GameVariableAccessShim;
import com.mamiyaotaru.voxelmap.util.ImageUtils;
import com.mamiyaotaru.voxelmap.util.MessageUtils;
import com.mamiyaotaru.voxelmap.util.TextUtils;
import com.mamiyaotaru.voxelmap.util.Waypoint;
import com.mamiyaotaru.voxelmap.util.WaypointContainer;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.network.play.ClientPlayNetHandler;
import net.minecraft.network.NetworkManager;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.storage.FolderName;

public class WaypointManager
implements IWaypointManager {
    IVoxelMap master;
    private Minecraft game;
    public MapSettingsManager options = null;
    TextureAtlas textureAtlas;
    TextureAtlas textureAtlasChooser;
    private boolean loaded = false;
    private boolean needSave = false;
    private ArrayList<Waypoint> wayPts = new ArrayList();
    private Waypoint highlightedWaypoint = null;
    private String worldName = "";
    private String latestRealmsID = "";
    private String currentSubWorldName = "";
    private String currentSubWorldHash = "";
    private String currentSubworldDescriptor = "";
    private String currentSubworldDescriptorNoCodes = "";
    private boolean multiworld = false;
    private boolean gotAutoSubworldName = false;
    private DimensionContainer currentDimension = null;
    private TreeSet<String> knownSubworldNames = new TreeSet(String.CASE_INSENSITIVE_ORDER);
    private HashSet<String> oldNorthWorldNames = new HashSet();
    private HashMap<String, String> worldSeeds = new HashMap();
    private BackgroundImageInfo backgroundImageInfo = null;
    private WaypointContainer waypointContainer = null;
    private File settingsFile;
    private Long lastNewWorldNameTime = 0L;
    private Object waypointLock = new Object();

    public WaypointManager(IVoxelMap master) {
        this.master = master;
        this.options = master.getMapOptions();
        this.textureAtlas = new TextureAtlas("waypoints");
        this.textureAtlas.func_174937_a(false, false);
        this.textureAtlasChooser = new TextureAtlas("chooser");
        this.textureAtlasChooser.func_174937_a(false, false);
        this.waypointContainer = new WaypointContainer(this.options);
    }

    @Override
    public void onResourceManagerReload(IResourceManager resourceManager) {
        final ArrayList images = new ArrayList();
        IIconCreator iconCreator = new IIconCreator(){

            @Override
            public void addIcons(TextureAtlas textureAtlas) {
                Minecraft mc = Minecraft.func_71410_x();
                Collection allImages = mc.func_195551_G().func_199003_a("images", asset -> asset.endsWith(".png"));
                for (ResourceLocation candidate : allImages) {
                    if (!candidate.func_110624_b().equals("voxelmap") || !candidate.func_110623_a().contains("images/waypoints")) continue;
                    images.add(candidate);
                }
                Sprite markerIcon = textureAtlas.registerIconForResource(new ResourceLocation("voxelmap", "images/waypoints/marker.png"), Minecraft.func_71410_x().func_195551_G());
                Sprite markerIconSmall = textureAtlas.registerIconForResource(new ResourceLocation("voxelmap", "images/waypoints/markersmall.png"), Minecraft.func_71410_x().func_195551_G());
                for (ResourceLocation resourceLocation : images) {
                    Sprite icon = textureAtlas.registerIconForResource(resourceLocation, Minecraft.func_71410_x().func_195551_G());
                    String name = resourceLocation.toString();
                    if (name.toLowerCase().contains("waypoints/waypoint") && !name.toLowerCase().contains("small")) {
                        textureAtlas.registerMaskedIcon(name.replace(".png", "Small.png"), icon);
                        textureAtlas.registerMaskedIcon(name.replace("waypoints/waypoint", "waypoints/marker"), markerIcon);
                        textureAtlas.registerMaskedIcon(name.replace("waypoints/waypoint", "waypoints/marker").replace(".png", "Small.png"), markerIconSmall);
                        continue;
                    }
                    if (!name.toLowerCase().contains("waypoints/marker") || name.toLowerCase().contains("small")) continue;
                    textureAtlas.registerMaskedIcon(name.replace(".png", "Small.png"), icon);
                }
            }
        };
        this.textureAtlas.loadTextureAtlas(iconCreator);
        this.textureAtlasChooser.reset();
        int expectedSize = 32;
        for (ResourceLocation resourceLocation : images) {
            String name = resourceLocation.toString();
            if (!name.toLowerCase().contains("waypoints/waypoint") || name.toLowerCase().contains("small")) continue;
            try {
                IResource imageResource = resourceManager.func_199002_a(resourceLocation);
                BufferedImage bufferedImage = ImageIO.read(imageResource.func_199027_b());
                imageResource.close();
                float scale = (float)expectedSize / (float)bufferedImage.getWidth();
                bufferedImage = ImageUtils.scaleImage(bufferedImage, scale);
                this.textureAtlasChooser.registerIconForBufferedImage(name, bufferedImage);
            }
            catch (IOException e) {
                this.textureAtlasChooser.registerIconForResource(resourceLocation, Minecraft.func_71410_x().func_195551_G());
            }
        }
        this.textureAtlasChooser.stitch();
    }

    @Override
    public TextureAtlas getTextureAtlas() {
        return this.textureAtlas;
    }

    @Override
    public TextureAtlas getTextureAtlasChooser() {
        return this.textureAtlasChooser;
    }

    @Override
    public ArrayList<Waypoint> getWaypoints() {
        return this.wayPts;
    }

    @Override
    public void newWorld(World world) {
        if (world == null) {
            this.currentDimension = null;
        } else {
            String mapName;
            this.game = Minecraft.func_71410_x();
            if (this.game.func_71387_A()) {
                mapName = this.getMapName();
            } else {
                mapName = this.getServerName();
                if (mapName != null) {
                    mapName = mapName.toLowerCase();
                }
            }
            if (!this.worldName.equals(mapName) && mapName != null && !mapName.equals("")) {
                this.currentDimension = null;
                this.worldName = mapName;
                this.master.getDimensionManager().populateDimensions(world);
                this.loadWaypoints();
            }
            this.master.getDimensionManager().enteredWorld(world);
            DimensionContainer dim = this.master.getDimensionManager().getDimensionContainerByWorld(world);
            this.enteredDimension(dim);
            this.setSubWorldDescriptor("");
        }
    }

    public String getMapName() {
        return this.game.func_71401_C().func_240776_a_(FolderName.field_237253_i_).normalize().toFile().getName();
    }

    public String getServerName() {
        String serverName = "";
        try {
            ServerData serverData = this.game.func_147104_D();
            if (serverData != null) {
                boolean isOnLAN = false;
                isOnLAN = serverData.func_181041_d();
                if (isOnLAN) {
                    System.out.println("LAN server detected!");
                    serverName = serverData.field_78847_a;
                } else {
                    serverName = serverData.field_78845_b;
                }
            } else if (!this.latestRealmsID.equals("")) {
                System.out.println("REALMS server detected!");
                serverName = this.latestRealmsID;
            } else {
                ClientPlayNetHandler netHandler = this.game.func_147114_u();
                NetworkManager networkManager = netHandler.func_147298_b();
                InetSocketAddress socketAddress = (InetSocketAddress)networkManager.func_74430_c();
                serverName = socketAddress.getHostString() + ":" + socketAddress.getPort();
            }
        }
        catch (Exception e) {
            System.err.println("error getting ServerData");
            e.printStackTrace();
        }
        return serverName;
    }

    @Override
    public void setConnectedRealm(String id) {
        this.latestRealmsID = id;
    }

    @Override
    public String getCurrentWorldName() {
        return this.worldName;
    }

    @Override
    public void handleDeath() {
        HashSet<Waypoint> toDel = new HashSet<Waypoint>();
        for (Waypoint pt : this.wayPts) {
            if (pt.name.equals("Latest Death")) {
                pt.name = "Previous Death";
            }
            if (!pt.name.startsWith("Previous Death")) continue;
            int n = this.options.deathpoints;
            this.options.getClass();
            if (n == 2) {
                int num = 0;
                try {
                    if (pt.name.length() > 15) {
                        num = Integer.parseInt(pt.name.substring(15));
                    }
                }
                catch (Exception e) {
                    num = 0;
                }
                pt.red -= (pt.red - 0.5f) / 8.0f;
                pt.green -= (pt.green - 0.5f) / 8.0f;
                pt.blue -= (pt.blue - 0.5f) / 8.0f;
                pt.name = "Previous Death " + (num + 1);
                continue;
            }
            toDel.add(pt);
        }
        int n = this.options.deathpoints;
        this.options.getClass();
        if (n != 2 && toDel.size() > 0) {
            for (Waypoint pt : toDel) {
                this.deleteWaypoint(pt);
            }
        }
        int n2 = this.options.deathpoints;
        this.options.getClass();
        if (n2 != 0) {
            ClientPlayerEntity thePlayer = Minecraft.func_71410_x().field_71439_g;
            TreeSet<DimensionContainer> dimensions = new TreeSet<DimensionContainer>();
            dimensions.add(AbstractVoxelMap.getInstance().getDimensionManager().getDimensionContainerByWorld((World)Minecraft.func_71410_x().field_71441_e));
            double dimensionScale = thePlayer.field_70170_p.func_230315_m_().func_242724_f();
            this.addWaypoint(new Waypoint("Latest Death", (int)((double)GameVariableAccessShim.xCoord() * dimensionScale), (int)((double)GameVariableAccessShim.zCoord() * dimensionScale), GameVariableAccessShim.yCoord() - 1, true, 1.0f, 1.0f, 1.0f, "Skull", this.getCurrentSubworldDescriptor(false), dimensions));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enteredDimension(DimensionContainer dimension) {
        this.highlightedWaypoint = null;
        if (dimension == this.currentDimension) {
            this.multiworld = true;
        }
        this.currentDimension = dimension;
        Object object = this.waypointLock;
        synchronized (object) {
            this.waypointContainer = new WaypointContainer(this.options);
            for (Waypoint pt : this.wayPts) {
                pt.inDimension = pt.dimensions.size() == 0 || pt.dimensions.contains(dimension);
                this.waypointContainer.addWaypoint(pt);
            }
            this.waypointContainer.setHighlightedWaypoint(this.highlightedWaypoint);
        }
        this.loadBackgroundMapImage();
    }

    @Override
    public void setOldNorth(boolean oldNorth) {
        String oldNorthWorldName = "";
        oldNorthWorldName = this.knownSubworldNames.size() == 0 ? "all" : this.getCurrentSubworldDescriptor(false);
        if (oldNorth) {
            this.oldNorthWorldNames.add(oldNorthWorldName);
        } else {
            this.oldNorthWorldNames.remove(oldNorthWorldName);
        }
        this.saveWaypoints();
    }

    @Override
    public TreeSet<String> getKnownSubworldNames() {
        return this.knownSubworldNames;
    }

    @Override
    public boolean receivedAutoSubworldName() {
        return this.gotAutoSubworldName;
    }

    @Override
    public boolean isMultiworld() {
        return this.multiworld;
    }

    @Override
    public synchronized void setSubworldName(String name, boolean fromServer) {
        boolean notNull;
        boolean bl = notNull = !name.equals("");
        if (notNull || System.currentTimeMillis() - this.lastNewWorldNameTime > 2000L) {
            if (notNull) {
                if (fromServer) {
                    this.gotAutoSubworldName = true;
                }
                if (!name.equals(this.currentSubWorldName)) {
                    System.out.println("New world name: " + TextUtils.scrubCodes(name));
                }
                this.lastNewWorldNameTime = System.currentTimeMillis();
            }
            this.currentSubWorldName = name;
            this.setSubWorldDescriptor(this.currentSubWorldName);
        }
    }

    @Override
    public synchronized void setSubworldHash(String hash) {
        this.currentSubWorldHash = hash;
        if (this.currentSubWorldName.equals("")) {
            this.setSubWorldDescriptor(this.currentSubWorldHash);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSubWorldDescriptor(String descriptor) {
        boolean serverSaysOldNorth = false;
        if (descriptor.endsWith("\u00a7o\u00a7n")) {
            descriptor = descriptor.substring(0, descriptor.length() - 4);
            serverSaysOldNorth = true;
        }
        this.currentSubworldDescriptor = descriptor;
        this.currentSubworldDescriptorNoCodes = TextUtils.scrubCodes(this.currentSubworldDescriptor);
        this.newSubworldName(this.currentSubworldDescriptorNoCodes);
        String currentSubWorldDescriptorScrubbed = TextUtils.scrubName(this.currentSubworldDescriptorNoCodes);
        Object object = this.waypointLock;
        synchronized (object) {
            for (Waypoint pt : this.wayPts) {
                if (currentSubWorldDescriptorScrubbed == "" || pt.world == "" || currentSubWorldDescriptorScrubbed.equals(pt.world)) {
                    pt.inWorld = true;
                    continue;
                }
                pt.inWorld = false;
            }
        }
        if (serverSaysOldNorth) {
            if (this.currentSubworldDescriptorNoCodes.equals("")) {
                this.oldNorthWorldNames.add("all");
            } else {
                this.oldNorthWorldNames.add(this.currentSubworldDescriptorNoCodes);
            }
        }
        this.master.getMapOptions().oldNorth = this.oldNorthWorldNames.contains(this.currentSubworldDescriptorNoCodes);
    }

    private void newSubworldName(String name) {
        if (name != null && !name.equals("")) {
            this.multiworld = true;
            if (this.knownSubworldNames.add(name)) {
                if (this.loaded) {
                    this.saveWaypoints();
                } else {
                    this.needSave = true;
                }
            }
        }
        this.loadBackgroundMapImage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void changeSubworldName(String oldName, String newName) {
        if (!newName.equals(oldName) && this.knownSubworldNames.remove(oldName)) {
            this.knownSubworldNames.add(newName);
            Object object = this.waypointLock;
            synchronized (object) {
                for (Waypoint pt : this.wayPts) {
                    if (!pt.world.equals(oldName)) continue;
                    pt.world = newName;
                }
            }
            this.master.getPersistentMap().renameSubworld(oldName, newName);
            String worldName = this.getCurrentWorldName();
            String worldNamePathPart = TextUtils.scrubNameFile(worldName);
            String subWorldNamePathPart = TextUtils.scrubNameFile(oldName) + "/";
            File oldCachedRegionFileDir = new File(Minecraft.func_71410_x().field_71412_D, "/mods/mamiyaotaru/voxelmap/cache/" + worldNamePathPart + "/" + subWorldNamePathPart);
            if (oldCachedRegionFileDir.exists() && oldCachedRegionFileDir.isDirectory()) {
                subWorldNamePathPart = TextUtils.scrubNameFile(newName) + "/";
                File newCachedRegionFileDir = new File(Minecraft.func_71410_x().field_71412_D, "/mods/mamiyaotaru/voxelmap/cache/" + worldNamePathPart + "/" + subWorldNamePathPart);
                boolean success = oldCachedRegionFileDir.renameTo(newCachedRegionFileDir);
                if (!success) {
                    System.out.println("Failed renaming " + oldCachedRegionFileDir.getPath() + " to " + newCachedRegionFileDir.getPath());
                }
            }
            if (oldName.equals(this.getCurrentSubworldDescriptor(false))) {
                this.setSubworldName(newName, false);
            }
            this.saveWaypoints();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteSubworld(String name) {
        if (this.knownSubworldNames.remove(name)) {
            Object object = this.waypointLock;
            synchronized (object) {
                for (Waypoint pt : this.wayPts) {
                    if (!pt.world.equals(name)) continue;
                    pt.world = "";
                    pt.inWorld = true;
                }
            }
            this.saveWaypoints();
            this.lastNewWorldNameTime = 0L;
            this.setSubworldName("", false);
        }
    }

    @Override
    public String getCurrentSubworldDescriptor(boolean withCodes) {
        return withCodes ? this.currentSubworldDescriptor : this.currentSubworldDescriptorNoCodes;
    }

    @Override
    public String getWorldSeed() {
        String seed;
        String key = "all";
        if (this.knownSubworldNames.size() > 0) {
            key = this.getCurrentSubworldDescriptor(false);
        }
        if ((seed = this.worldSeeds.get(key)) == null) {
            seed = "";
        }
        return seed;
    }

    @Override
    public void setWorldSeed(String newSeed) {
        System.out.println("waypoint manager gets new world seed: " + newSeed);
        String worldName = "all";
        if (this.knownSubworldNames.size() > 0) {
            worldName = this.getCurrentSubworldDescriptor(false);
        }
        this.worldSeeds.put(worldName, newSeed);
        this.saveWaypoints();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void saveWaypoints() {
        int portSepLoc;
        String worldNameSave = this.getCurrentWorldName();
        if (worldNameSave.endsWith(":25565") && (portSepLoc = worldNameSave.lastIndexOf(":")) != -1) {
            worldNameSave = worldNameSave.substring(0, portSepLoc);
        }
        worldNameSave = TextUtils.scrubNameFile(worldNameSave);
        File saveDir = new File(Minecraft.func_71410_x().field_71412_D, "/voxelmap/");
        if (!saveDir.exists()) {
            saveDir.mkdirs();
        }
        this.settingsFile = new File(saveDir, worldNameSave + ".points");
        try {
            void var6_11;
            PrintWriter out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.settingsFile), StandardCharsets.UTF_8));
            String knownSubworldsString = "";
            for (String string : this.knownSubworldNames) {
                knownSubworldsString = knownSubworldsString + TextUtils.scrubName(string) + ",";
            }
            out.println("subworlds:" + knownSubworldsString);
            String oldNorthWorldsString = "";
            for (String oldNorthWorldName : this.oldNorthWorldNames) {
                oldNorthWorldsString = oldNorthWorldsString + TextUtils.scrubName(oldNorthWorldName) + ",";
            }
            out.println("oldNorthWorlds:" + oldNorthWorldsString);
            String string = "";
            for (Map.Entry<String, String> entry : this.worldSeeds.entrySet()) {
                String string2 = (String)var6_11 + TextUtils.scrubName(entry.getKey()) + "#" + entry.getValue() + ",";
            }
            out.println("seeds:" + (String)var6_11);
            for (Waypoint pt : this.wayPts) {
                if (pt.name.startsWith("^")) continue;
                String dimensionsString = "";
                for (DimensionContainer dimension : pt.dimensions) {
                    dimensionsString = dimensionsString + "" + dimension.getStorageName() + "#";
                }
                if (dimensionsString.equals("")) {
                    dimensionsString = dimensionsString + AbstractVoxelMap.getInstance().getDimensionManager().getDimensionContainerByResourceLocation(DimensionType.field_235999_c_.func_240901_a_()).getStorageName();
                }
                out.println("name:" + TextUtils.scrubName(pt.name) + ",x:" + pt.x + ",z:" + pt.z + ",y:" + pt.y + ",enabled:" + Boolean.toString(pt.enabled) + ",red:" + pt.red + ",green:" + pt.green + ",blue:" + pt.blue + ",suffix:" + pt.imageSuffix + ",world:" + TextUtils.scrubName(pt.world) + ",dimensions:" + dimensionsString);
            }
            out.close();
        }
        catch (Exception local) {
            MessageUtils.chatInfo("\u00a7EError Saving Waypoints");
            local.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadWaypoints() {
        this.loaded = false;
        this.multiworld = false;
        this.gotAutoSubworldName = false;
        this.currentDimension = null;
        this.setSubWorldDescriptor("");
        this.knownSubworldNames.clear();
        this.oldNorthWorldNames.clear();
        this.worldSeeds.clear();
        Object object = this.waypointLock;
        synchronized (object) {
            int portSepLoc;
            boolean loaded = false;
            this.wayPts = new ArrayList();
            String worldNameStandard = this.getCurrentWorldName();
            if (worldNameStandard.endsWith(":25565") && (portSepLoc = worldNameStandard.lastIndexOf(":")) != -1) {
                worldNameStandard = worldNameStandard.substring(0, portSepLoc);
            }
            if (!(loaded = this.loadWaypointsExtensible(worldNameStandard = TextUtils.scrubNameFile(worldNameStandard)))) {
                MessageUtils.chatInfo("\u00a7ENo waypoints exist for this world/server.");
            }
        }
        this.loaded = true;
        if (this.needSave) {
            this.needSave = false;
            this.saveWaypoints();
        }
        this.multiworld = this.multiworld || this.knownSubworldNames.size() > 0;
    }

    private boolean loadWaypointsExtensible(String worldNameStandard) {
        File settingsFileNew = new File(Minecraft.func_71410_x().field_71412_D, "/voxelmap/" + worldNameStandard + ".points");
        File settingsFileOld = new File(Minecraft.func_71410_x().field_71412_D, "/mods/mamiyaotaru/voxelmap/" + worldNameStandard + ".points");
        if (!settingsFileOld.exists() && !settingsFileNew.exists()) {
            return false;
        }
        this.settingsFile = !settingsFileOld.exists() ? settingsFileNew : (!settingsFileNew.exists() ? settingsFileOld : settingsFileNew);
        if (this.settingsFile.exists()) {
            try {
                Properties properties = new Properties();
                FileReader fr = new FileReader(this.settingsFile);
                properties.load(fr);
                String subWorldsS = properties.getProperty("subworlds", "");
                String[] subWorlds = subWorldsS.split(",");
                for (int t = 0; t < subWorlds.length; ++t) {
                    if (subWorlds[t].equals("")) continue;
                    this.knownSubworldNames.add(TextUtils.descrubName(subWorlds[t]));
                }
                String oldNorthWorldsS = properties.getProperty("oldNorthWorlds", "");
                String[] oldNorthWorlds = oldNorthWorldsS.split(",");
                for (int t = 0; t < oldNorthWorlds.length; ++t) {
                    if (oldNorthWorlds[t].equals("")) continue;
                    this.oldNorthWorldNames.add(TextUtils.descrubName(oldNorthWorlds[t]));
                }
                String worldSeedsS = properties.getProperty("seeds", "");
                String[] worldSeedPairs = worldSeedsS.split(",");
                for (int t = 0; t < worldSeedPairs.length; ++t) {
                    String pair = worldSeedPairs[t];
                    String[] worldSeedPair = pair.split("#");
                    if (worldSeedPair.length != 2) continue;
                    this.worldSeeds.put(worldSeedPair[0], worldSeedPair[1]);
                }
                fr.close();
            }
            catch (IOException properties) {
                // empty catch block
            }
            try {
                String sCurrentLine;
                BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.settingsFile), StandardCharsets.UTF_8));
                while ((sCurrentLine = in.readLine()) != null) {
                    try {
                        String[] pairs = sCurrentLine.split(",");
                        if (pairs.length <= 1) continue;
                        String name = "";
                        int x = 0;
                        int z = 0;
                        int y = -1;
                        boolean enabled = false;
                        float red = 0.5f;
                        float green = 0.0f;
                        float blue = 0.0f;
                        String suffix = "";
                        String world = "";
                        TreeSet<DimensionContainer> dimensions = new TreeSet<DimensionContainer>();
                        for (int t = 0; t < pairs.length; ++t) {
                            int splitIndex = pairs[t].indexOf(":");
                            if (splitIndex == -1) continue;
                            String key = pairs[t].substring(0, splitIndex).toLowerCase().trim();
                            String value = pairs[t].substring(splitIndex + 1).trim();
                            if (key.equals("name")) {
                                name = TextUtils.descrubName(value);
                                continue;
                            }
                            if (key.equals("x")) {
                                x = Integer.parseInt(value);
                                continue;
                            }
                            if (key.equals("z")) {
                                z = Integer.parseInt(value);
                                continue;
                            }
                            if (key.equals("y")) {
                                y = Integer.parseInt(value);
                                continue;
                            }
                            if (key.equals("enabled")) {
                                enabled = Boolean.parseBoolean(value);
                                continue;
                            }
                            if (key.equals("red")) {
                                red = Float.parseFloat(value);
                                continue;
                            }
                            if (key.equals("green")) {
                                green = Float.parseFloat(value);
                                continue;
                            }
                            if (key.equals("blue")) {
                                blue = Float.parseFloat(value);
                                continue;
                            }
                            if (key.equals("suffix")) {
                                suffix = value;
                                continue;
                            }
                            if (key.equals("world")) {
                                world = TextUtils.descrubName(value);
                                continue;
                            }
                            if (!key.equals("dimensions")) continue;
                            String[] dimensionStrings = value.split("#");
                            for (int s = 0; s < dimensionStrings.length; ++s) {
                                dimensions.add(AbstractVoxelMap.getInstance().getDimensionManager().getDimensionContainerByIdentifier(dimensionStrings[s]));
                            }
                            if (dimensions.size() != 0) continue;
                            dimensions.add(AbstractVoxelMap.getInstance().getDimensionManager().getDimensionContainerByResourceLocation(DimensionType.field_235999_c_.func_240901_a_()));
                        }
                        if (name.equals("")) continue;
                        this.loadWaypoint(name, x, z, y, enabled, red, green, blue, suffix, world, dimensions);
                        if (world.equals("")) continue;
                        this.knownSubworldNames.add(TextUtils.descrubName(world));
                    }
                    catch (Exception exception) {}
                }
                in.close();
            }
            catch (Exception local) {
                MessageUtils.chatInfo("\u00a7EError Loading Waypoints");
                System.err.println("waypoint load error: " + local.getLocalizedMessage());
                local.printStackTrace();
                return false;
            }
            return true;
        }
        return false;
    }

    private void loadWaypoint(String name, int x, int z, int y, boolean enabled, float red, float green, float blue, String suffix, String world, TreeSet<DimensionContainer> dimensions) {
        Waypoint newWaypoint = new Waypoint(name, x, z, y, enabled, red, green, blue, suffix, world, dimensions);
        if (!this.wayPts.contains(newWaypoint)) {
            this.wayPts.add(newWaypoint);
        }
    }

    @Override
    public void deleteWaypoint(Waypoint point) {
        this.waypointContainer.removeWaypoint(point);
        this.wayPts.remove(point);
        this.saveWaypoints();
        if (point == this.highlightedWaypoint) {
            this.setHighlightedWaypoint(null, false);
        }
    }

    @Override
    public void addWaypoint(Waypoint newWaypoint) {
        this.wayPts.add(newWaypoint);
        this.waypointContainer.addWaypoint(newWaypoint);
        this.saveWaypoints();
        if (this.highlightedWaypoint != null && this.highlightedWaypoint.getX() == newWaypoint.getX() && this.highlightedWaypoint.getZ() == newWaypoint.getZ()) {
            this.setHighlightedWaypoint(newWaypoint, false);
        }
    }

    @Override
    public void setHighlightedWaypoint(Waypoint waypoint, boolean toggle) {
        if (toggle && waypoint == this.highlightedWaypoint) {
            this.highlightedWaypoint = null;
        } else {
            if (waypoint != null && !this.wayPts.contains(waypoint)) {
                waypoint.red = 2.0f;
                waypoint.blue = 0.0f;
                waypoint.green = 0.0f;
            }
            this.highlightedWaypoint = waypoint;
        }
        this.waypointContainer.setHighlightedWaypoint(this.highlightedWaypoint);
    }

    @Override
    public Waypoint getHighlightedWaypoint() {
        return this.highlightedWaypoint;
    }

    @Override
    public void renderWaypoints(float partialTicks, MatrixStack matrixStack, boolean beacons, boolean signs, boolean withDepth, boolean withoutDepth) {
        if (this.waypointContainer != null) {
            this.waypointContainer.renderWaypoints(partialTicks, matrixStack, beacons, signs, withDepth, withoutDepth);
        }
    }

    private void loadBackgroundMapImage() {
        if (this.backgroundImageInfo != null) {
            GLUtils.glah(this.backgroundImageInfo.glid);
            this.backgroundImageInfo = null;
        }
        try {
            String path = this.getCurrentWorldName();
            String subworldDescriptor = this.getCurrentSubworldDescriptor(false);
            if (subworldDescriptor != null && !subworldDescriptor.equals("")) {
                path = path + "/" + subworldDescriptor;
            }
            path = path + "/" + this.currentDimension.getStorageName();
            InputStream is = this.game.func_195551_G().func_199002_a(new ResourceLocation("voxelmap", "images/backgroundmaps/" + path + "/map.png")).func_199027_b();
            BufferedImage image = ImageIO.read(is);
            is.close();
            BufferedImage mapImage = new BufferedImage(((Image)image).getWidth(null), ((Image)image).getHeight(null), 2);
            Graphics2D gfx = mapImage.createGraphics();
            gfx.drawImage((Image)image, 0, 0, null);
            gfx.dispose();
            is = this.game.func_195551_G().func_199002_a(new ResourceLocation("voxelmap", "images/backgroundmaps/" + path + "/map.txt")).func_199027_b();
            InputStreamReader isr = new InputStreamReader(is);
            Properties mapProperties = new Properties();
            mapProperties.load(isr);
            String left = mapProperties.getProperty("left");
            String right = mapProperties.getProperty("right");
            String top = mapProperties.getProperty("top");
            String bottom = mapProperties.getProperty("bottom");
            String width = mapProperties.getProperty("width");
            String height = mapProperties.getProperty("height");
            String scale = mapProperties.getProperty("scale");
            if (left != null && top != null && width != null && height != null) {
                this.backgroundImageInfo = new BackgroundImageInfo(mapImage, Integer.parseInt(left), Integer.parseInt(top), Integer.parseInt(width), Integer.parseInt(height));
            } else if (left != null && top != null && scale != null) {
                this.backgroundImageInfo = new BackgroundImageInfo(mapImage, Integer.parseInt(left), Integer.parseInt(top), Float.parseFloat(scale));
            } else if (left != null && top != null && right != null && bottom != null) {
                int widthInt = Integer.parseInt(right) - Integer.parseInt(left);
                int heightInt = Integer.parseInt(right) - Integer.parseInt(left);
                this.backgroundImageInfo = new BackgroundImageInfo(mapImage, Integer.parseInt(left), Integer.parseInt(top), widthInt, heightInt);
            }
            isr.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public BackgroundImageInfo getBackgroundImageInfo() {
        return this.backgroundImageInfo;
    }
}

