/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.gui;

import com.mamiyaotaru.voxelmap.MapSettingsManager;
import com.mamiyaotaru.voxelmap.gui.GuiMinimapControls;
import com.mamiyaotaru.voxelmap.gui.GuiMinimapPerformance;
import com.mamiyaotaru.voxelmap.gui.GuiRadarOptions;
import com.mamiyaotaru.voxelmap.gui.overridden.EnumOptionsMinimap;
import com.mamiyaotaru.voxelmap.gui.overridden.GuiOptionButtonMinimap;
import com.mamiyaotaru.voxelmap.gui.overridden.GuiScreenMinimap;
import com.mamiyaotaru.voxelmap.interfaces.IVoxelMap;
import com.mamiyaotaru.voxelmap.persistent.GuiPersistentMapOptions;
import com.mamiyaotaru.voxelmap.util.I18nUtils;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class GuiMinimapOptions
extends GuiScreenMinimap {
    private Screen parent;
    private IVoxelMap master;
    private static EnumOptionsMinimap[] relevantOptions;
    private final MapSettingsManager options;
    protected String screenTitle = "Minimap Options";

    public GuiMinimapOptions(Screen parent, IVoxelMap master) {
        this.parent = parent;
        this.master = master;
        this.options = master.getMapOptions();
    }

    public void func_231160_c_() {
        relevantOptions = new EnumOptionsMinimap[]{EnumOptionsMinimap.COORDS, EnumOptionsMinimap.HIDE, EnumOptionsMinimap.LOCATION, EnumOptionsMinimap.SIZE, EnumOptionsMinimap.SQUARE, EnumOptionsMinimap.ROTATES, EnumOptionsMinimap.BEACONS, EnumOptionsMinimap.CAVEMODE};
        int var2 = 0;
        this.screenTitle = I18nUtils.getString("options.minimap.title", new Object[0]);
        for (int t = 0; t < relevantOptions.length; ++t) {
            EnumOptionsMinimap option = relevantOptions[t];
            GuiOptionButtonMinimap optionButton = new GuiOptionButtonMinimap(this.getWidth() / 2 - 155 + var2 % 2 * 160, this.getHeight() / 6 + 24 * (var2 >> 1), option, (ITextComponent)new StringTextComponent(this.options.getKeyText(option)), button -> this.optionClicked(button));
            this.func_230480_a_((Widget)optionButton);
            if (option.equals((Object)EnumOptionsMinimap.CAVEMODE)) {
                optionButton.field_230693_o_ = this.options.cavesAllowed;
            }
            ++var2;
        }
        Button radarOptionsButton = new Button(this.getWidth() / 2 - 155, this.getHeight() / 6 + 120 - 6, 150, 20, (ITextComponent)new TranslationTextComponent("options.minimap.radar"), button -> this.getMinecraft().func_147108_a((Screen)new GuiRadarOptions(this, this.master)));
        radarOptionsButton.field_230693_o_ = this.master.getRadarOptions().radarAllowed != false || this.master.getRadarOptions().radarMobsAllowed != false || this.master.getRadarOptions().radarPlayersAllowed != false;
        this.func_230480_a_((Widget)radarOptionsButton);
        this.func_230480_a_((Widget)new Button(this.getWidth() / 2 + 5, this.getHeight() / 6 + 120 - 6, 150, 20, (ITextComponent)new TranslationTextComponent("options.minimap.detailsperformance"), button -> this.getMinecraft().func_147108_a((Screen)new GuiMinimapPerformance(this, this.master))));
        this.func_230480_a_((Widget)new Button(this.getWidth() / 2 - 155, this.getHeight() / 6 + 144 - 6, 150, 20, (ITextComponent)new TranslationTextComponent("options.controls"), button -> this.getMinecraft().func_147108_a((Screen)new GuiMinimapControls(this, this.master))));
        this.func_230480_a_((Widget)new Button(this.getWidth() / 2 + 5, this.getHeight() / 6 + 144 - 6, 150, 20, (ITextComponent)new TranslationTextComponent("options.minimap.worldmap"), button -> this.getMinecraft().func_147108_a((Screen)new GuiPersistentMapOptions(this, this.master))));
        this.func_230480_a_((Widget)new Button(this.getWidth() / 2 - 100, this.getHeight() / 6 + 168, 200, 20, (ITextComponent)new TranslationTextComponent("gui.done"), button -> this.getMinecraft().func_147108_a(this.parent)));
    }

    protected void optionClicked(Button par1GuiButton) {
        EnumOptionsMinimap option = ((GuiOptionButtonMinimap)par1GuiButton).returnEnumOptions();
        this.options.setOptionValue(option);
        par1GuiButton.func_238482_a_((ITextComponent)new StringTextComponent(this.options.getKeyText(option)));
        if (option == EnumOptionsMinimap.OLDNORTH) {
            this.master.getWaypointManager().setOldNorth(this.options.oldNorth);
        }
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.drawMap(matrixStack);
        this.func_230446_a_(matrixStack);
        GuiMinimapOptions.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)this.getFontRenderer(), (String)this.screenTitle, (int)(this.getWidth() / 2), (int)20, (int)0xFFFFFF);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
    }
}

