/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.gui;

import com.mamiyaotaru.voxelmap.MapSettingsManager;
import com.mamiyaotaru.voxelmap.gui.GuiAddWaypoint;
import com.mamiyaotaru.voxelmap.gui.GuiSlotWaypoints;
import com.mamiyaotaru.voxelmap.gui.GuiWaypointsOptions;
import com.mamiyaotaru.voxelmap.gui.IGuiWaypoints;
import com.mamiyaotaru.voxelmap.gui.overridden.GuiScreenMinimap;
import com.mamiyaotaru.voxelmap.interfaces.AbstractVoxelMap;
import com.mamiyaotaru.voxelmap.interfaces.IVoxelMap;
import com.mamiyaotaru.voxelmap.interfaces.IWaypointManager;
import com.mamiyaotaru.voxelmap.util.CommandUtils;
import com.mamiyaotaru.voxelmap.util.DimensionContainer;
import com.mamiyaotaru.voxelmap.util.GameVariableAccessShim;
import com.mamiyaotaru.voxelmap.util.I18nUtils;
import com.mamiyaotaru.voxelmap.util.Waypoint;
import com.mojang.blaze3d.matrix.MatrixStack;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.util.Random;
import java.util.TreeSet;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.ConfirmScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class GuiWaypoints
extends GuiScreenMinimap
implements IGuiWaypoints {
    private final Screen parentScreen;
    private IVoxelMap master;
    protected final MapSettingsManager options;
    protected final IWaypointManager waypointManager;
    protected ITextComponent screenTitle;
    private GuiSlotWaypoints waypointList;
    private Button buttonEdit;
    private boolean editClicked = false;
    private Button buttonDelete;
    private boolean deleteClicked = false;
    private Button buttonHighlight;
    private Button buttonShare;
    private Button buttonTeleport;
    private Button buttonSortName;
    private Button buttonSortCreated;
    private Button buttonSortDistance;
    private Button buttonSortColor;
    protected TextFieldWidget filter;
    private boolean addClicked = false;
    private ITextComponent tooltip = null;
    protected Waypoint selectedWaypoint = null;
    protected Waypoint highlightedWaypoint = null;
    protected Waypoint newWaypoint = null;
    private Random generator = new Random();
    private boolean changedSort = false;

    public GuiWaypoints(Screen parentScreen, IVoxelMap master) {
        this.master = master;
        this.parentScreen = parentScreen;
        this.options = master.getMapOptions();
        this.waypointManager = master.getWaypointManager();
        this.highlightedWaypoint = this.waypointManager.getHighlightedWaypoint();
    }

    public void func_231023_e_() {
        this.filter.func_146178_a();
    }

    public void func_231160_c_() {
        boolean isSomethingSelected;
        this.screenTitle = new TranslationTextComponent("minimap.waypoints.title");
        this.getMinecraft().field_195559_v.func_197967_a(true);
        this.waypointList = new GuiSlotWaypoints(this);
        this.buttonSortName = new Button(this.getWidth() / 2 - 154, 34, 77, 20, (ITextComponent)new TranslationTextComponent("minimap.waypoints.sortbyname"), button -> {
            this.options.getClass();
            this.sortClicked(2);
        });
        this.func_230480_a_((Widget)this.buttonSortName);
        this.buttonSortDistance = new Button(this.getWidth() / 2 - 77, 34, 77, 20, (ITextComponent)new TranslationTextComponent("minimap.waypoints.sortbydistance"), button -> {
            this.options.getClass();
            this.sortClicked(3);
        });
        this.func_230480_a_((Widget)this.buttonSortDistance);
        this.buttonSortCreated = new Button(this.getWidth() / 2, 34, 77, 20, (ITextComponent)new TranslationTextComponent("minimap.waypoints.sortbycreated"), button -> {
            this.options.getClass();
            this.sortClicked(1);
        });
        this.func_230480_a_((Widget)this.buttonSortCreated);
        this.buttonSortColor = new Button(this.getWidth() / 2 + 77, 34, 77, 20, (ITextComponent)new TranslationTextComponent("minimap.waypoints.sortbycolor"), button -> {
            this.options.getClass();
            this.sortClicked(4);
        });
        this.func_230480_a_((Widget)this.buttonSortColor);
        int filterStringWidth = this.getFontRenderer().func_78256_a(I18nUtils.getString("minimap.waypoints.filter", new Object[0]) + ":");
        this.filter = new TextFieldWidget(this.getFontRenderer(), this.getWidth() / 2 - 153 + filterStringWidth + 5, this.getHeight() - 80, 305 - filterStringWidth - 5, 20, null);
        this.filter.func_146203_f(35);
        this.func_230480_a_((Widget)this.filter);
        this.buttonEdit = new Button(this.getWidth() / 2 - 154, this.getHeight() - 52, 74, 20, (ITextComponent)new TranslationTextComponent("selectServer.edit"), button -> this.editWaypoint(this.selectedWaypoint));
        this.func_230480_a_((Widget)this.buttonEdit);
        this.buttonDelete = new Button(this.getWidth() / 2 - 76, this.getHeight() - 52, 74, 20, (ITextComponent)new TranslationTextComponent("selectServer.delete"), button -> this.deleteClicked());
        this.func_230480_a_((Widget)this.buttonDelete);
        this.buttonHighlight = new Button(this.getWidth() / 2 + 2, this.getHeight() - 52, 74, 20, (ITextComponent)new TranslationTextComponent("minimap.waypoints.highlight"), button -> this.setHighlightedWaypoint());
        this.func_230480_a_((Widget)this.buttonHighlight);
        this.buttonTeleport = new Button(this.getWidth() / 2 + 80, this.getHeight() - 52, 74, 20, (ITextComponent)new TranslationTextComponent("minimap.waypoints.teleportto"), button -> this.teleportClicked());
        this.func_230480_a_((Widget)this.buttonTeleport);
        this.buttonShare = new Button(this.getWidth() / 2 - 154, this.getHeight() - 28, 74, 20, (ITextComponent)new TranslationTextComponent("minimap.waypoints.share"), button -> CommandUtils.sendWaypoint(this.selectedWaypoint));
        this.func_230480_a_((Widget)this.buttonShare);
        this.func_230480_a_((Widget)new Button(this.getWidth() / 2 - 76, this.getHeight() - 28, 74, 20, (ITextComponent)new TranslationTextComponent("minimap.waypoints.newwaypoint"), button -> this.addWaypoint()));
        this.func_230480_a_((Widget)new Button(this.getWidth() / 2 + 2, this.getHeight() - 28, 74, 20, (ITextComponent)new TranslationTextComponent("menu.options"), button -> this.getMinecraft().func_147108_a((Screen)new GuiWaypointsOptions(this, this.options))));
        this.func_230480_a_((Widget)new Button(this.getWidth() / 2 + 80, this.getHeight() - 28, 74, 20, (ITextComponent)new TranslationTextComponent("gui.done"), button -> this.getMinecraft().func_147108_a(this.parentScreen)));
        this.func_231035_a_((IGuiEventListener)this.filter);
        this.filter.func_146195_b(true);
        this.buttonEdit.field_230693_o_ = isSomethingSelected = this.selectedWaypoint != null;
        this.buttonDelete.field_230693_o_ = isSomethingSelected;
        this.buttonHighlight.field_230693_o_ = isSomethingSelected;
        this.buttonShare.field_230693_o_ = isSomethingSelected;
        this.buttonTeleport.field_230693_o_ = isSomethingSelected && this.canTeleport();
        this.sort();
    }

    private void sort() {
        int sortKey = Math.abs(this.options.sort);
        boolean ascending = this.options.sort > 0;
        this.waypointList.sortBy(sortKey, ascending);
        String arrow = ascending ? "\u2191" : "\u2193";
        this.options.getClass();
        if (sortKey == 2) {
            this.buttonSortName.func_238482_a_((ITextComponent)new StringTextComponent(arrow + " " + I18nUtils.getString("minimap.waypoints.sortbyname", new Object[0]) + " " + arrow));
        } else {
            this.buttonSortName.func_238482_a_((ITextComponent)new TranslationTextComponent("minimap.waypoints.sortbyname"));
        }
        this.options.getClass();
        if (sortKey == 3) {
            this.buttonSortDistance.func_238482_a_((ITextComponent)new StringTextComponent(arrow + " " + I18nUtils.getString("minimap.waypoints.sortbydistance", new Object[0]) + " " + arrow));
        } else {
            this.buttonSortDistance.func_238482_a_((ITextComponent)new TranslationTextComponent("minimap.waypoints.sortbydistance"));
        }
        this.options.getClass();
        if (sortKey == 1) {
            this.buttonSortCreated.func_238482_a_((ITextComponent)new StringTextComponent(arrow + " " + I18nUtils.getString("minimap.waypoints.sortbycreated", new Object[0]) + " " + arrow));
        } else {
            this.buttonSortCreated.func_238482_a_((ITextComponent)new TranslationTextComponent("minimap.waypoints.sortbycreated"));
        }
        this.options.getClass();
        if (sortKey == 4) {
            this.buttonSortColor.func_238482_a_((ITextComponent)new StringTextComponent(arrow + " " + I18nUtils.getString("minimap.waypoints.sortbycolor", new Object[0]) + " " + arrow));
        } else {
            this.buttonSortColor.func_238482_a_((ITextComponent)new TranslationTextComponent("minimap.waypoints.sortbycolor"));
        }
    }

    private void deleteClicked() {
        String var2 = this.selectedWaypoint.name;
        if (var2 != null) {
            this.deleteClicked = true;
            TranslationTextComponent title = new TranslationTextComponent("minimap.waypoints.deleteconfirm");
            TranslationTextComponent explanation = new TranslationTextComponent("selectServer.deleteWarning", new Object[]{var2});
            TranslationTextComponent affirm = new TranslationTextComponent("selectServer.deleteButton");
            TranslationTextComponent deny = new TranslationTextComponent("gui.cancel");
            ConfirmScreen confirmScreen = new ConfirmScreen((BooleanConsumer)this, (ITextComponent)title, (ITextComponent)explanation, (ITextComponent)affirm, (ITextComponent)deny);
            this.getMinecraft().func_147108_a((Screen)confirmScreen);
        }
    }

    private void teleportClicked() {
        boolean mp;
        boolean bl = mp = !this.field_230706_i_.func_71387_A();
        int y = this.selectedWaypoint.getY() > 0 ? this.selectedWaypoint.getY() : (!this.options.game.field_71439_g.field_70170_p.func_230315_m_().func_236037_d_() ? 255 : 64);
        this.options.game.field_71439_g.func_71165_d("/tp " + this.options.game.field_71439_g.func_200200_C_().getString() + " " + this.selectedWaypoint.getX() + " " + y + " " + this.selectedWaypoint.getZ());
        if (mp) {
            this.options.game.field_71439_g.func_71165_d("/tppos " + this.selectedWaypoint.getX() + " " + y + " " + this.selectedWaypoint.getZ());
        }
        this.getMinecraft().func_147108_a((Screen)null);
    }

    protected void sortClicked(int id) {
        this.options.setSort(id);
        this.changedSort = true;
        this.sort();
    }

    public boolean func_231046_a_(int keysm, int scancode, int b) {
        boolean OK = super.func_231046_a_(keysm, scancode, b);
        if (this.filter.func_230999_j_()) {
            this.waypointList.updateFilter(this.filter.func_146179_b().toLowerCase());
        }
        return OK;
    }

    public boolean func_231042_a_(char character, int keycode) {
        boolean OK = super.func_231042_a_(character, keycode);
        if (this.filter.func_230999_j_()) {
            this.waypointList.updateFilter(this.filter.func_146179_b().toLowerCase());
        }
        return OK;
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        this.waypointList.func_231044_a_(mouseX, mouseY, mouseButton);
        return super.func_231044_a_(mouseX, mouseY, mouseButton);
    }

    public boolean func_231048_c_(double mouseX, double mouseY, int mouseButton) {
        this.waypointList.func_231048_c_(mouseX, mouseY, mouseButton);
        return super.func_231048_c_(mouseX, mouseY, mouseButton);
    }

    public boolean func_231045_a_(double mouseX, double mouseY, int mouseEvent, double deltaX, double deltaY) {
        return this.waypointList.func_231045_a_(mouseX, mouseY, mouseEvent, deltaX, deltaY);
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double amount) {
        return this.waypointList.func_231043_a_(mouseX, mouseY, amount);
    }

    @Override
    public boolean isEditing() {
        return this.editClicked;
    }

    public void accept(boolean par1) {
        if (this.deleteClicked) {
            this.deleteClicked = false;
            if (par1) {
                this.waypointManager.deleteWaypoint(this.selectedWaypoint);
                this.selectedWaypoint = null;
            }
            this.getMinecraft().func_147108_a((Screen)this);
        }
        if (this.editClicked) {
            this.editClicked = false;
            if (par1) {
                this.waypointManager.saveWaypoints();
            }
            this.getMinecraft().func_147108_a((Screen)this);
        }
        if (this.addClicked) {
            this.addClicked = false;
            if (par1) {
                this.waypointManager.addWaypoint(this.newWaypoint);
                this.setSelectedWaypoint(this.newWaypoint);
            }
            this.getMinecraft().func_147108_a((Screen)this);
        }
    }

    protected void setSelectedWaypoint(Waypoint waypoint) {
        boolean isSomethingSelected;
        this.selectedWaypoint = waypoint;
        this.buttonEdit.field_230693_o_ = isSomethingSelected = this.selectedWaypoint != null;
        this.buttonDelete.field_230693_o_ = isSomethingSelected;
        this.buttonHighlight.field_230693_o_ = isSomethingSelected;
        this.buttonHighlight.func_238482_a_((ITextComponent)new TranslationTextComponent(isSomethingSelected && this.selectedWaypoint == this.highlightedWaypoint ? "minimap.waypoints.removehighlight" : "minimap.waypoints.highlight"));
        this.buttonShare.field_230693_o_ = isSomethingSelected;
        this.buttonTeleport.field_230693_o_ = isSomethingSelected && this.canTeleport();
    }

    protected void setHighlightedWaypoint() {
        this.waypointManager.setHighlightedWaypoint(this.selectedWaypoint, true);
        this.highlightedWaypoint = this.waypointManager.getHighlightedWaypoint();
        boolean isSomethingSelected = this.selectedWaypoint != null;
        this.buttonHighlight.func_238482_a_((ITextComponent)new TranslationTextComponent(isSomethingSelected && this.selectedWaypoint == this.highlightedWaypoint ? "minimap.waypoints.removehighlight" : "minimap.waypoints.highlight"));
    }

    protected void editWaypoint(Waypoint waypoint) {
        this.editClicked = true;
        this.getMinecraft().func_147108_a((Screen)new GuiAddWaypoint(this, this.master, waypoint, true));
    }

    protected void addWaypoint() {
        float b;
        float g;
        float r;
        this.addClicked = true;
        if (this.waypointManager.getWaypoints().size() == 0) {
            r = 0.0f;
            g = 1.0f;
            b = 0.0f;
        } else {
            r = this.generator.nextFloat();
            g = this.generator.nextFloat();
            b = this.generator.nextFloat();
        }
        TreeSet<DimensionContainer> dimensions = new TreeSet<DimensionContainer>();
        dimensions.add(AbstractVoxelMap.getInstance().getDimensionManager().getDimensionContainerByWorld((World)this.getMinecraft().field_71441_e));
        double dimensionScale = this.options.game.field_71439_g.field_70170_p.func_230315_m_().func_242724_f();
        this.newWaypoint = new Waypoint("", (int)((double)GameVariableAccessShim.xCoord() * dimensionScale), (int)((double)GameVariableAccessShim.zCoord() * dimensionScale), GameVariableAccessShim.yCoord(), true, r, g, b, "", this.master.getWaypointManager().getCurrentSubworldDescriptor(false), dimensions);
        this.getMinecraft().func_147108_a((Screen)new GuiAddWaypoint(this, this.master, this.newWaypoint, false));
    }

    protected void toggleWaypointVisibility() {
        this.selectedWaypoint.enabled = !this.selectedWaypoint.enabled;
        this.waypointManager.saveWaypoints();
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.drawMap(matrixStack);
        this.tooltip = null;
        this.waypointList.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        GuiWaypoints.func_238472_a_((MatrixStack)matrixStack, (FontRenderer)this.getFontRenderer(), (ITextComponent)this.screenTitle, (int)(this.getWidth() / 2), (int)20, (int)0xFFFFFF);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        GuiWaypoints.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)this.getFontRenderer(), (String)(I18nUtils.getString("minimap.waypoints.filter", new Object[0]) + ":"), (int)(this.getWidth() / 2 - 153), (int)(this.getHeight() - 75), (int)0xA0A0A0);
        this.filter.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        if (this.tooltip != null) {
            this.func_238652_a_(matrixStack, this.tooltip, mouseX, mouseY);
        }
    }

    static ITextComponent setTooltip(GuiWaypoints par0GuiWaypoints, ITextComponent par1Str) {
        par0GuiWaypoints.tooltip = par1Str;
        return par0GuiWaypoints.tooltip;
    }

    public boolean canTeleport() {
        boolean allowed = false;
        boolean singlePlayer = this.options.game.func_71387_A();
        if (singlePlayer) {
            try {
                allowed = this.getMinecraft().func_71401_C().func_184103_al().func_152596_g(this.getMinecraft().field_71439_g.func_146103_bH());
            }
            catch (Exception e) {
                allowed = this.getMinecraft().func_71401_C().func_240793_aU_().func_76086_u();
            }
        } else {
            allowed = true;
        }
        return allowed;
    }

    @Override
    public void func_231164_f_() {
        this.field_230706_i_.field_195559_v.func_197967_a(false);
        if (this.changedSort) {
            super.func_231164_f_();
        }
    }
}

