/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.util;

import com.mamiyaotaru.voxelmap.interfaces.IDimensionManager;
import com.mamiyaotaru.voxelmap.interfaces.IVoxelMap;
import com.mamiyaotaru.voxelmap.util.DimensionContainer;
import com.mamiyaotaru.voxelmap.util.I18nUtils;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import net.minecraft.client.Minecraft;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;

public class DimensionManager
implements IDimensionManager {
    IVoxelMap master;
    public ArrayList<DimensionContainer> dimensions;
    private ArrayList<RegistryKey<World>> vanillaWorlds = new ArrayList();

    public DimensionManager(IVoxelMap master) {
        this.master = master;
        this.dimensions = new ArrayList();
        this.vanillaWorlds.add((RegistryKey<World>)World.field_234918_g_);
        this.vanillaWorlds.add((RegistryKey<World>)World.field_234919_h_);
        this.vanillaWorlds.add((RegistryKey<World>)World.field_234920_i_);
    }

    @Override
    public ArrayList<DimensionContainer> getDimensions() {
        return this.dimensions;
    }

    @Override
    public void populateDimensions(World world) {
        this.dimensions.clear();
        Registry dimensionTypeRegistry = Minecraft.func_71410_x().func_147114_u().func_239165_n_().func_230520_a_();
        for (RegistryKey<World> vanillaWorldKey : this.vanillaWorlds) {
            RegistryKey typeKey = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239698_ad_, (ResourceLocation)vanillaWorldKey.func_240901_a_());
            DimensionType dimensionType = (DimensionType)dimensionTypeRegistry.func_230516_a_(typeKey);
            DimensionContainer dimensionContainer = new DimensionContainer(dimensionType, vanillaWorldKey.func_240901_a_().func_110623_a(), vanillaWorldKey.func_240901_a_());
            this.dimensions.add(dimensionContainer);
        }
        this.sort();
    }

    @Override
    public void enteredWorld(World world) {
        ResourceLocation resourceLocation = world.func_234923_W_().func_240901_a_();
        DimensionContainer dim = this.getDimensionContainerByResourceLocation(resourceLocation);
        if (dim == null) {
            dim = new DimensionContainer(world.func_230315_m_(), resourceLocation.func_110623_a(), resourceLocation);
            this.dimensions.add(dim);
            this.sort();
        }
        if (dim.type == null) {
            try {
                dim.type = world.func_230315_m_();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void sort() {
        final Collator collator = I18nUtils.getLocaleAwareCollator();
        Collections.sort(this.dimensions, new Comparator<DimensionContainer>(){

            @Override
            public int compare(DimensionContainer dim1, DimensionContainer dim2) {
                if (dim1.resourceLocation.equals((Object)World.field_234918_g_.func_240901_a_())) {
                    return -1;
                }
                if (dim1.resourceLocation.equals((Object)World.field_234919_h_.func_240901_a_()) && !dim2.resourceLocation.equals((Object)World.field_234918_g_.func_240901_a_())) {
                    return -1;
                }
                if (dim1.resourceLocation.equals((Object)World.field_234920_i_.func_240901_a_()) && !dim2.resourceLocation.equals((Object)World.field_234918_g_.func_240901_a_()) && !dim2.resourceLocation.equals((Object)World.field_234919_h_.func_240901_a_())) {
                    return -1;
                }
                return collator.compare(dim1.name, dim2.name);
            }
        });
    }

    @Override
    public DimensionContainer getDimensionContainerByWorld(World world) {
        ResourceLocation resourceLocation = world.func_234923_W_().func_240901_a_();
        DimensionContainer dim = this.getDimensionContainerByResourceLocation(resourceLocation);
        if (dim == null) {
            dim = new DimensionContainer(world.func_230315_m_(), resourceLocation.func_110623_a(), resourceLocation);
            this.dimensions.add(dim);
            this.sort();
        }
        return dim;
    }

    @Override
    public DimensionContainer getDimensionContainerByIdentifier(String ident) {
        DimensionContainer dim = null;
        ResourceLocation resourceLocation = new ResourceLocation(ident);
        dim = this.getDimensionContainerByResourceLocation(resourceLocation);
        if (dim == null) {
            dim = new DimensionContainer(null, resourceLocation.func_110623_a(), resourceLocation);
            this.dimensions.add(dim);
            this.sort();
        }
        return dim;
    }

    @Override
    public DimensionContainer getDimensionContainerByResourceLocation(ResourceLocation resourceLocation) {
        for (DimensionContainer dim : this.dimensions) {
            if (!resourceLocation.equals((Object)dim.resourceLocation)) continue;
            return dim;
        }
        return null;
    }
}

