/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.mods.ftbessentials.command;

import com.feed_the_beast.mods.ftbessentials.FTBEConfig;
import com.feed_the_beast.mods.ftbessentials.util.FTBEPlayerData;
import com.feed_the_beast.mods.ftbessentials.util.TeleportPos;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Map;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.GameProfileArgument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;

public class HomeCommands {
    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"home").executes(context -> HomeCommands.home(((CommandSource)context.getSource()).func_197035_h(), "home"))).then(Commands.func_197056_a((String)"name", (ArgumentType)StringArgumentType.greedyString()).executes(context -> HomeCommands.home(((CommandSource)context.getSource()).func_197035_h(), StringArgumentType.getString((CommandContext)context, (String)"name")))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"sethome").executes(context -> HomeCommands.sethome(((CommandSource)context.getSource()).func_197035_h(), "home"))).then(Commands.func_197056_a((String)"name", (ArgumentType)StringArgumentType.greedyString()).executes(context -> HomeCommands.sethome(((CommandSource)context.getSource()).func_197035_h(), StringArgumentType.getString((CommandContext)context, (String)"name")))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"delhome").executes(context -> HomeCommands.delhome(((CommandSource)context.getSource()).func_197035_h(), "home"))).then(Commands.func_197056_a((String)"name", (ArgumentType)StringArgumentType.greedyString()).executes(context -> HomeCommands.delhome(((CommandSource)context.getSource()).func_197035_h(), StringArgumentType.getString((CommandContext)context, (String)"name")))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"listhomes").executes(context -> HomeCommands.listhomes((CommandSource)context.getSource(), ((CommandSource)context.getSource()).func_197035_h().func_146103_bH()))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"player", (ArgumentType)GameProfileArgument.func_197108_a()).requires(source -> source.func_197028_i().func_71264_H() || source.func_197034_c(2))).executes(context -> HomeCommands.listhomes((CommandSource)context.getSource(), (GameProfile)GameProfileArgument.func_197109_a((CommandContext)context, (String)"player").iterator().next()))));
    }

    public static int home(ServerPlayerEntity player, String name) {
        FTBEPlayerData data = FTBEPlayerData.get((PlayerEntity)player);
        TeleportPos pos = data.homes.get(name.toLowerCase());
        if (pos == null) {
            player.func_146105_b((ITextComponent)new StringTextComponent("Home not found!"), false);
            return 0;
        }
        return data.homeTeleporter.teleport(player, p -> pos).runCommand(player);
    }

    public static int sethome(ServerPlayerEntity player, String name) {
        FTBEPlayerData data = FTBEPlayerData.get((PlayerEntity)player);
        if ((long)data.homes.size() >= FTBEConfig.getMaxHomes(player) && !data.homes.containsKey(name.toLowerCase())) {
            player.func_146105_b((ITextComponent)new StringTextComponent("Can't add any more homes!"), false);
            return 0;
        }
        data.homes.put(name.toLowerCase(), new TeleportPos((Entity)player));
        data.save();
        player.func_146105_b((ITextComponent)new StringTextComponent("Home set!"), false);
        return 1;
    }

    public static int delhome(ServerPlayerEntity player, String name) {
        FTBEPlayerData data = FTBEPlayerData.get((PlayerEntity)player);
        if (data.homes.remove(name.toLowerCase()) != null) {
            data.save();
            player.func_146105_b((ITextComponent)new StringTextComponent("Home deleted!"), false);
            return 1;
        }
        player.func_146105_b((ITextComponent)new StringTextComponent("Home not found!"), false);
        return 0;
    }

    public static int listhomes(CommandSource source, GameProfile of) {
        FTBEPlayerData data = FTBEPlayerData.get(of);
        if (data.homes.isEmpty()) {
            source.func_197030_a((ITextComponent)new StringTextComponent("None"), false);
            return 1;
        }
        TeleportPos origin = new TeleportPos((RegistryKey<World>)source.func_197023_e().func_234923_W_(), new BlockPos(source.func_197036_d()));
        for (Map.Entry<String, TeleportPos> entry : data.homes.entrySet()) {
            source.func_197030_a((ITextComponent)new StringTextComponent(entry.getKey() + ": " + entry.getValue().distanceString(origin)), false);
        }
        return 1;
    }
}

