/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.mods.ftbessentials.command;

import com.feed_the_beast.mods.ftbessentials.FTBEConfig;
import com.feed_the_beast.mods.ftbessentials.util.FTBEPlayerData;
import com.feed_the_beast.mods.ftbessentials.util.RTPEvent;
import com.feed_the_beast.mods.ftbessentials.util.TeleportPos;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Optional;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.GameProfileArgument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.border.WorldBorder;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class TeleportCommands {
    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.func_197057_a((String)"back").executes(context -> TeleportCommands.back(((CommandSource)context.getSource()).func_197035_h())));
        dispatcher.register((LiteralArgumentBuilder)Commands.func_197057_a((String)"spawn").executes(context -> TeleportCommands.spawn(((CommandSource)context.getSource()).func_197035_h())));
        dispatcher.register((LiteralArgumentBuilder)Commands.func_197057_a((String)"rtp").executes(context -> TeleportCommands.rtp(((CommandSource)context.getSource()).func_197035_h())));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"teleport_last").requires(source -> source.func_197034_c(2))).then(Commands.func_197056_a((String)"player", (ArgumentType)GameProfileArgument.func_197108_a()).executes(context -> TeleportCommands.tpLast(((CommandSource)context.getSource()).func_197035_h(), (GameProfile)GameProfileArgument.func_197109_a((CommandContext)context, (String)"player").iterator().next()))));
    }

    public static int back(ServerPlayerEntity player) {
        FTBEPlayerData data = FTBEPlayerData.get((PlayerEntity)player);
        if (data.teleportHistory.isEmpty()) {
            player.func_146105_b((ITextComponent)new StringTextComponent("Teleportation history is empty!"), false);
            return 0;
        }
        if (data.backTeleporter.teleport(player, serverPlayerEntity -> data.teleportHistory.getLast()).runCommand(player) != 0) {
            data.teleportHistory.removeLast();
            data.save();
            return 1;
        }
        return 0;
    }

    public static int spawn(ServerPlayerEntity player) {
        FTBEPlayerData data = FTBEPlayerData.get((PlayerEntity)player);
        ServerWorld w = player.field_71133_b.func_71218_a(World.field_234918_g_);
        if (w == null) {
            return 0;
        }
        return data.spawnTeleporter.teleport(player, p -> new TeleportPos((World)w, w.func_205770_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, w.func_241135_u_()))).runCommand(player);
    }

    public static int rtp(ServerPlayerEntity player) {
        FTBEPlayerData data = FTBEPlayerData.get((PlayerEntity)player);
        return data.rtpTeleporter.teleport(player, p -> {
            p.func_146105_b((ITextComponent)new StringTextComponent("Looking for random location..."), false);
            return TeleportCommands.findBlockPos(p.field_71133_b.func_71218_a(World.field_234918_g_), p, 1);
        }).runCommand(player);
    }

    private static TeleportPos findBlockPos(ServerWorld world, ServerPlayerEntity player, int attempt) {
        if (attempt > FTBEConfig.rtpMaxTries) {
            player.func_146105_b((ITextComponent)new StringTextComponent("Could not find a valid location to teleport to!"), false);
            return new TeleportPos((Entity)player);
        }
        double dist = FTBEConfig.rtpMinDistance + world.field_73012_v.nextDouble() * (FTBEConfig.rtpMaxDistance - FTBEConfig.rtpMinDistance);
        double angle = world.field_73012_v.nextDouble() * Math.PI * 2.0;
        int x = MathHelper.func_76128_c((double)(Math.cos(angle) * dist));
        int y = 256;
        int z = MathHelper.func_76128_c((double)(Math.sin(angle) * dist));
        BlockPos currentPos = new BlockPos(x, y, z);
        WorldBorder border = world.func_175723_af();
        if (!border.func_177746_a(currentPos)) {
            return TeleportCommands.findBlockPos(world, player, attempt + 1);
        }
        Optional biomeKey = world.func_242406_i(currentPos);
        if (biomeKey.isPresent() && ((RegistryKey)biomeKey.get()).func_240901_a_().func_110623_a().contains("ocean")) {
            return TeleportCommands.findBlockPos(world, player, attempt + 1);
        }
        if (MinecraftForge.EVENT_BUS.post((Event)new RTPEvent(world, player, currentPos, attempt))) {
            return TeleportCommands.findBlockPos(world, player, attempt + 1);
        }
        world.func_217348_a(currentPos.func_177958_n() >> 4, currentPos.func_177952_p() >> 4, ChunkStatus.field_222616_l);
        BlockPos newPos = world.func_205770_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, currentPos);
        if (newPos.func_177956_o() > 0) {
            player.func_146105_b((ITextComponent)new StringTextComponent(String.format("Found good location after %d " + (attempt == 1 ? "attempt" : "attempts") + " @ [x %d, z %d]", attempt, newPos.func_177958_n(), newPos.func_177952_p())), false);
            return new TeleportPos((RegistryKey<World>)world.func_234923_W_(), newPos.func_177984_a());
        }
        return TeleportCommands.findBlockPos(world, player, attempt + 1);
    }

    public static int tpLast(ServerPlayerEntity player, GameProfile to) {
        ServerPlayerEntity p = player.field_71133_b.func_184103_al().func_177451_a(to.getId());
        if (p != null) {
            new TeleportPos((Entity)p).teleport(player);
            return 1;
        }
        FTBEPlayerData dataTo = FTBEPlayerData.get(to);
        dataTo.lastSeen.teleport(player);
        return 1;
    }
}

