/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.mods.ftbessentials.command;

import com.feed_the_beast.mods.ftbessentials.util.FTBEPlayerData;
import com.feed_the_beast.mods.ftbessentials.util.FTBEWorldData;
import com.feed_the_beast.mods.ftbessentials.util.TeleportPos;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Map;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;

public class WarpCommands {
    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.func_197057_a((String)"warp").then(Commands.func_197056_a((String)"name", (ArgumentType)StringArgumentType.greedyString()).executes(context -> WarpCommands.warp(((CommandSource)context.getSource()).func_197035_h(), StringArgumentType.getString((CommandContext)context, (String)"name")))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"setwarp").requires(source -> source.func_197034_c(2))).then(Commands.func_197056_a((String)"name", (ArgumentType)StringArgumentType.greedyString()).executes(context -> WarpCommands.setwarp(((CommandSource)context.getSource()).func_197035_h(), StringArgumentType.getString((CommandContext)context, (String)"name")))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"delwarp").requires(source -> source.func_197034_c(2))).then(Commands.func_197056_a((String)"name", (ArgumentType)StringArgumentType.greedyString()).executes(context -> WarpCommands.delwarp(((CommandSource)context.getSource()).func_197035_h(), StringArgumentType.getString((CommandContext)context, (String)"name")))));
        dispatcher.register((LiteralArgumentBuilder)Commands.func_197057_a((String)"listwarps").executes(context -> WarpCommands.listwarps((CommandSource)context.getSource())));
    }

    public static int warp(ServerPlayerEntity player, String name) {
        FTBEPlayerData data = FTBEPlayerData.get((PlayerEntity)player);
        TeleportPos pos = FTBEWorldData.instance.warps.get(name.toLowerCase());
        if (pos == null) {
            player.func_146105_b((ITextComponent)new StringTextComponent("Warp not found!"), false);
            return 0;
        }
        return data.warpTeleporter.teleport(player, p -> pos).runCommand(player);
    }

    public static int setwarp(ServerPlayerEntity player, String name) {
        FTBEWorldData.instance.warps.put(name.toLowerCase(), new TeleportPos((Entity)player));
        FTBEWorldData.instance.save();
        player.func_146105_b((ITextComponent)new StringTextComponent("Warp set!"), false);
        return 1;
    }

    public static int delwarp(ServerPlayerEntity player, String name) {
        if (FTBEWorldData.instance.warps.remove(name.toLowerCase()) != null) {
            FTBEWorldData.instance.save();
            player.func_146105_b((ITextComponent)new StringTextComponent("Warp deleted!"), false);
            return 1;
        }
        player.func_146105_b((ITextComponent)new StringTextComponent("Warp not found!"), false);
        return 0;
    }

    public static int listwarps(CommandSource source) {
        if (FTBEWorldData.instance.warps.isEmpty()) {
            source.func_197030_a((ITextComponent)new StringTextComponent("None"), false);
            return 1;
        }
        TeleportPos origin = new TeleportPos((RegistryKey<World>)source.func_197023_e().func_234923_W_(), new BlockPos(source.func_197036_d()));
        for (Map.Entry<String, TeleportPos> entry : FTBEWorldData.instance.warps.entrySet()) {
            source.func_197030_a((ITextComponent)new StringTextComponent(entry.getKey() + ": " + entry.getValue().distanceString(origin)), false);
        }
        return 1;
    }
}

