/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.mods.ftbessentials.util;

import com.feed_the_beast.mods.ftbessentials.util.FTBEPlayerData;
import com.feed_the_beast.mods.ftbessentials.util.TeleportPos;
import java.util.function.Function;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;

public class CooldownTeleporter {
    public final FTBEPlayerData playerData;
    public final Function<ServerPlayerEntity, Long> cooldownGetter;
    public long cooldown;

    public static String prettyTimeString(long seconds) {
        if (seconds <= 0L) {
            return "0 seconds";
        }
        StringBuilder builder = new StringBuilder();
        CooldownTeleporter.prettyTimeString(builder, seconds, true);
        return builder.toString();
    }

    private static void prettyTimeString(StringBuilder builder, long seconds, boolean addAnother) {
        if (seconds <= 0L) {
            return;
        }
        if (!addAnother) {
            builder.append(" and ");
        }
        if (seconds < 60L) {
            builder.append(seconds);
            builder.append(seconds == 1L ? " second" : " seconds");
        } else if (seconds < 3600L) {
            builder.append(seconds / 60L);
            builder.append(seconds / 60L == 1L ? " minute" : " minutes");
            if (addAnother) {
                CooldownTeleporter.prettyTimeString(builder, seconds % 60L, false);
            }
        } else if (seconds < 86400L) {
            builder.append(seconds / 3600L);
            builder.append(seconds / 3600L == 1L ? " hour" : " hours");
            if (addAnother) {
                CooldownTeleporter.prettyTimeString(builder, seconds % 3600L, false);
            }
        } else {
            builder.append(seconds / 86400L);
            builder.append(seconds / 86400L == 1L ? " day" : " days");
            if (addAnother) {
                CooldownTeleporter.prettyTimeString(builder, seconds % 86400L, false);
            }
        }
    }

    public CooldownTeleporter(FTBEPlayerData d, Function<ServerPlayerEntity, Long> c) {
        this.playerData = d;
        this.cooldownGetter = c;
        this.cooldown = 0L;
    }

    public TeleportPos.TeleportResult checkCooldown() {
        long now = System.currentTimeMillis();
        if (now < this.cooldown) {
            return () -> this.cooldown - now;
        }
        return TeleportPos.TeleportResult.SUCCESS;
    }

    public TeleportPos.TeleportResult teleport(ServerPlayerEntity player, Function<ServerPlayerEntity, TeleportPos> positionGetter) {
        TeleportPos.TeleportResult res0 = this.checkCooldown();
        if (!res0.isSuccess()) {
            return res0;
        }
        this.cooldown = System.currentTimeMillis() + Math.max(0L, this.cooldownGetter.apply(player));
        TeleportPos p = positionGetter.apply(player);
        TeleportPos currentPos = new TeleportPos((Entity)player);
        res0 = p.teleport(player);
        if (!res0.isSuccess()) {
            return res0;
        }
        if (this != this.playerData.backTeleporter) {
            this.playerData.addTeleportHistory(player, currentPos);
        }
        return TeleportPos.TeleportResult.SUCCESS;
    }
}

