/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.mods.ftbessentials.util;

import com.feed_the_beast.mods.ftbessentials.FTBEConfig;
import com.feed_the_beast.mods.ftbessentials.FTBEssentials;
import com.feed_the_beast.mods.ftbessentials.net.FTBEssentialsNet;
import com.feed_the_beast.mods.ftbessentials.net.UpdateTabNamePacket;
import com.feed_the_beast.mods.ftbessentials.util.CooldownTeleporter;
import com.feed_the_beast.mods.ftbessentials.util.FTBEWorldData;
import com.feed_the_beast.mods.ftbessentials.util.TeleportPos;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.PacketDistributor;

public class FTBEPlayerData {
    public static final Map<UUID, FTBEPlayerData> MAP = new HashMap<UUID, FTBEPlayerData>();
    public final UUID uuid;
    public String name;
    private boolean save;
    public boolean muted;
    public boolean fly;
    public boolean god;
    public String nick;
    public TeleportPos lastSeen;
    public final LinkedHashMap<String, TeleportPos> homes;
    public int recording;
    public final CooldownTeleporter backTeleporter;
    public final CooldownTeleporter spawnTeleporter;
    public final CooldownTeleporter warpTeleporter;
    public final CooldownTeleporter homeTeleporter;
    public final CooldownTeleporter tpaTeleporter;
    public final CooldownTeleporter rtpTeleporter;
    public final LinkedList<TeleportPos> teleportHistory;

    public static FTBEPlayerData get(GameProfile profile) {
        FTBEPlayerData data = MAP.get(profile.getId());
        if (data == null) {
            data = new FTBEPlayerData(profile.getId());
            if (profile.getName() != null && !profile.getName().isEmpty()) {
                data.name = profile.getName();
            }
            MAP.put(profile.getId(), data);
        }
        return data;
    }

    public static FTBEPlayerData get(PlayerEntity player) {
        return FTBEPlayerData.get(player.func_146103_bH());
    }

    public static void addTeleportHistory(ServerPlayerEntity player, RegistryKey<World> dimension, BlockPos pos) {
        FTBEPlayerData.get((PlayerEntity)player).addTeleportHistory(player, new TeleportPos(dimension, pos));
    }

    public static void addTeleportHistory(ServerPlayerEntity player) {
        FTBEPlayerData.addTeleportHistory(player, (RegistryKey<World>)player.field_70170_p.func_234923_W_(), player.func_233580_cy_());
    }

    public FTBEPlayerData(UUID u) {
        this.uuid = u;
        this.name = "Unknown";
        this.save = false;
        this.muted = false;
        this.fly = false;
        this.god = false;
        this.nick = "";
        this.lastSeen = new TeleportPos((RegistryKey<World>)World.field_234918_g_, BlockPos.field_177992_a);
        this.homes = new LinkedHashMap();
        this.recording = 0;
        this.backTeleporter = new CooldownTeleporter(this, FTBEConfig::getBackCooldown);
        this.spawnTeleporter = new CooldownTeleporter(this, FTBEConfig::getSpawnCooldown);
        this.warpTeleporter = new CooldownTeleporter(this, FTBEConfig::getWarpCooldown);
        this.homeTeleporter = new CooldownTeleporter(this, FTBEConfig::getHomeCooldown);
        this.tpaTeleporter = new CooldownTeleporter(this, FTBEConfig::getTpaCooldown);
        this.rtpTeleporter = new CooldownTeleporter(this, FTBEConfig::getRtpCooldown);
        this.teleportHistory = new LinkedList();
    }

    public void save() {
        this.save = true;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("muted", Boolean.valueOf(this.muted));
        json.addProperty("fly", Boolean.valueOf(this.fly));
        json.addProperty("god", Boolean.valueOf(this.god));
        json.addProperty("nick", this.nick);
        json.add("lastSeen", (JsonElement)this.lastSeen.toJson());
        json.addProperty("recording", (Number)this.recording);
        JsonArray tph = new JsonArray();
        for (TeleportPos pos : this.teleportHistory) {
            tph.add((JsonElement)pos.toJson());
        }
        json.add("teleportHistory", (JsonElement)tph);
        JsonObject hm = new JsonObject();
        for (Map.Entry<String, TeleportPos> h : this.homes.entrySet()) {
            hm.add(h.getKey(), (JsonElement)h.getValue().toJson());
        }
        json.add("homes", (JsonElement)hm);
        return json;
    }

    public void fromJson(JsonObject json) {
        this.muted = json.has("muted") && json.get("muted").getAsBoolean();
        this.fly = json.has("fly") && json.get("fly").getAsBoolean();
        this.god = json.has("god") && json.get("god").getAsBoolean();
        this.nick = json.has("nick") ? json.get("nick").getAsString() : "";
        int n = this.recording = json.has("recording") ? json.get("recording").getAsInt() : 0;
        if (json.has("lastSeen")) {
            this.lastSeen = new TeleportPos(json.get("lastSeen").getAsJsonObject());
        }
        this.teleportHistory.clear();
        if (json.has("teleportHistory")) {
            for (Object e : json.get("teleportHistory").getAsJsonArray()) {
                this.teleportHistory.add(new TeleportPos(e.getAsJsonObject()));
            }
        }
        this.homes.clear();
        if (json.has("homes")) {
            for (Object e : json.get("homes").getAsJsonObject().entrySet()) {
                this.homes.put((String)e.getKey(), new TeleportPos(((JsonElement)e.getValue()).getAsJsonObject()));
            }
        }
    }

    public void addTeleportHistory(ServerPlayerEntity player, TeleportPos pos) {
        this.teleportHistory.add(pos);
        while (this.teleportHistory.size() > FTBEConfig.getMaxBack(player)) {
            this.teleportHistory.removeFirst();
        }
        this.save();
    }

    public void load() {
        block14: {
            try {
                Path dir = FTBEWorldData.instance.mkdirs("playerdata");
                Path file = dir.resolve(this.uuid + ".json");
                if (!Files.exists(file, new LinkOption[0])) break block14;
                try (BufferedReader reader = Files.newBufferedReader(file);){
                    this.fromJson((JsonObject)FTBEssentials.GSON.fromJson((Reader)reader, JsonObject.class));
                }
            }
            catch (Exception ex) {
                FTBEssentials.LOGGER.error("Failed to load player data for " + this.uuid + ":" + this.name + ": " + ex);
                ex.printStackTrace();
            }
        }
    }

    public void saveNow() {
        if (!this.save) {
            return;
        }
        try {
            JsonObject json = this.toJson();
            Path dir = FTBEWorldData.instance.mkdirs("playerdata");
            Path file = dir.resolve(this.uuid + ".json");
            try (BufferedWriter writer = Files.newBufferedWriter(file, new OpenOption[0]);){
                FTBEssentials.GSON.toJson((JsonElement)json, (Appendable)writer);
            }
            this.save = false;
        }
        catch (Exception ex) {
            FTBEssentials.LOGGER.error("Failed to save player data for " + this.uuid + ":" + this.name + ": " + ex);
            ex.printStackTrace();
        }
    }

    public void sendTabName() {
        this.sendTabName(null);
    }

    public void sendTabName(@Nullable ServerPlayerEntity to) {
        FTBEssentialsNet.MAIN.send(to == null ? PacketDistributor.ALL.noArg() : PacketDistributor.PLAYER.with(() -> to), (Object)new UpdateTabNamePacket(this.uuid, this.name, this.nick, this.recording, false));
    }
}

