/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.mods.ftbessentials.util;

import com.feed_the_beast.mods.ftbessentials.util.TeleportPos;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.storage.FolderName;

public class FTBEWorldData {
    public static final FolderName FTBESSENTIALS_DIRECTORY = new FolderName("ftbessentials");
    public static FTBEWorldData instance;
    public final MinecraftServer server;
    public boolean save;
    public final Map<String, TeleportPos> warps;

    public FTBEWorldData(MinecraftServer s) {
        this.server = s;
        this.warps = new LinkedHashMap<String, TeleportPos>();
    }

    public Path mkdirs(String path) {
        Path dir = this.server.func_240776_a_(FTBESSENTIALS_DIRECTORY);
        if (!path.isEmpty()) {
            dir = dir.resolve(path);
        }
        if (Files.notExists(dir, new LinkOption[0])) {
            try {
                Files.createDirectories(dir, new FileAttribute[0]);
            }
            catch (Exception ex) {
                throw new RuntimeException("Could not create FTB Essentials data directory: " + ex);
            }
        }
        return dir;
    }

    public void save() {
        this.save = true;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        JsonObject wm = new JsonObject();
        for (Map.Entry<String, TeleportPos> h : this.warps.entrySet()) {
            wm.add(h.getKey(), (JsonElement)h.getValue().toJson());
        }
        json.add("warps", (JsonElement)wm);
        return json;
    }

    public void fromJson(JsonObject json) {
        this.warps.clear();
        if (json.has("warps")) {
            for (Map.Entry e : json.get("warps").getAsJsonObject().entrySet()) {
                this.warps.put((String)e.getKey(), new TeleportPos(((JsonElement)e.getValue()).getAsJsonObject()));
            }
        }
    }
}

