/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.mods.ftbessentials.util;

import com.feed_the_beast.mods.ftbessentials.util.CooldownTeleporter;
import com.google.gson.JsonObject;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class TeleportPos {
    public final RegistryKey<World> dimension;
    public final BlockPos pos;
    public long time;

    public TeleportPos(RegistryKey<World> d, BlockPos p) {
        this.dimension = d;
        this.pos = p;
        this.time = System.currentTimeMillis();
    }

    public TeleportPos(World world, BlockPos p) {
        this((RegistryKey<World>)world.func_234923_W_(), p);
    }

    public TeleportPos(Entity entity) {
        this(entity.field_70170_p, entity.func_233580_cy_());
    }

    public TeleportPos(JsonObject json) {
        this.dimension = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(json.get("dim").getAsString()));
        this.pos = new BlockPos(json.get("x").getAsInt(), json.get("y").getAsInt(), json.get("z").getAsInt());
        this.time = json.get("time").getAsLong();
    }

    public TeleportResult teleport(ServerPlayerEntity player) {
        ServerWorld world = player.field_71133_b.func_71218_a(this.dimension);
        if (world == null) {
            return TeleportResult.DIMENSION_NOT_FOUND;
        }
        int lvl = player.field_71068_ca;
        player.func_200619_a(world, (double)this.pos.func_177958_n() + 0.5, (double)this.pos.func_177956_o() + 0.1, (double)this.pos.func_177952_p() + 0.5, player.field_70177_z, player.field_70125_A);
        player.func_195399_b(lvl);
        return TeleportResult.SUCCESS;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("dim", this.dimension.func_240901_a_().toString());
        json.addProperty("x", (Number)this.pos.func_177958_n());
        json.addProperty("y", (Number)this.pos.func_177956_o());
        json.addProperty("z", (Number)this.pos.func_177952_p());
        json.addProperty("time", (Number)this.time);
        return json;
    }

    public String distanceString(TeleportPos origin) {
        if (origin.dimension == this.dimension) {
            double dx = this.pos.func_177958_n() - origin.pos.func_177958_n();
            double dz = this.pos.func_177952_p() - origin.pos.func_177952_p();
            return (int)Math.sqrt(dx * dx + dz * dz) + "m";
        }
        ResourceLocation s = this.dimension.func_240901_a_();
        if (s.func_110624_b().equals("minecraft")) {
            switch (s.func_110623_a()) {
                case "overworld": {
                    return "Overworld";
                }
                case "the_nether": {
                    return "The Nether";
                }
                case "the_end": {
                    return "The End";
                }
            }
            return s.func_110623_a();
        }
        return s.func_110623_a() + " [" + s.func_110624_b() + "]";
    }

    @FunctionalInterface
    public static interface CooldownTeleportResult
    extends TeleportResult {
        public long getCooldown();

        @Override
        default public int runCommand(ServerPlayerEntity player) {
            player.func_146105_b((ITextComponent)new StringTextComponent("Can't teleport yet! Cooldown: " + CooldownTeleporter.prettyTimeString(this.getCooldown() / 1000L)), false);
            return 0;
        }
    }

    @FunctionalInterface
    public static interface TeleportResult {
        public static final TeleportResult SUCCESS = new TeleportResult(){

            @Override
            public int runCommand(ServerPlayerEntity player) {
                return 1;
            }

            @Override
            public boolean isSuccess() {
                return true;
            }
        };
        public static final TeleportResult DIMENSION_NOT_FOUND = player -> {
            player.func_146105_b((ITextComponent)new StringTextComponent("Dimension not found!"), false);
            return 0;
        };

        public int runCommand(ServerPlayerEntity var1);

        default public boolean isSuccess() {
            return false;
        }
    }
}

