/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.connector;

import com.google.common.collect.Maps;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.multiplayer.GuiConnecting;
import net.minecraft.client.multiplayer.ServerData;
import org.tlauncher.connector.AbstractConnector;
import org.tlauncher.connector.ExtendedServerListData;
import org.tlauncher.injection.mapping.MappingManager;

public class Connector
extends AbstractConnector {
    private Minecraft client;
    private Map<ServerData, ExtendedServerListData> serverDataTag;

    public Connector(Minecraft minecraft) {
        this.client = minecraft;
    }

    public void showGuiScreen(@Nullable Object clientGuiElement) {
        GuiScreen gui = (GuiScreen)clientGuiElement;
        try {
            Method method = this.client.getClass().getMethod(MappingManager.instance().getMappings().getClass("Minecraft").getMethod("displayGuiScreen").getObfName(), GuiScreen.class);
            method.invoke((Object)this.client, gui);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public void setupServerList() {
        this.serverDataTag = Collections.synchronizedMap(Maps.newHashMap());
    }

    @Override
    public void connectToServer(String host, int port) {
        this.setupServerList();
        ServerData serverData = null;
        String command_line = "Command Line";
        String serverPath = host + ":" + port;
        try {
            ServerData.class.getConstructor(String.class, String.class, Boolean.TYPE);
            serverData = new ServerData(command_line, serverPath, false);
        }
        catch (NoSuchMethodException e) {
            try {
                serverData = (ServerData)ServerData.class.getConstructor(String.class, String.class).newInstance(command_line, serverPath);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException instantiationException) {
                instantiationException.printStackTrace();
            }
        }
        if (serverData != null) {
            this.connectToServer(null, serverData);
        }
    }

    public void connectToServer(GuiScreen guiMultiplayer, ServerData serverEntry) {
        ExtendedServerListData extendedData = this.serverDataTag.get(serverEntry);
        if (extendedData != null && extendedData.isBlocked) {
            this.showGuiScreen(null);
        } else {
            this.showGuiScreen(new GuiConnecting(guiMultiplayer, this.client, serverEntry));
        }
    }
}

