/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.injection;

import java.util.ArrayList;
import java.util.Optional;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.tlauncher.injection.Desc;
import org.tlauncher.injection.InjectionManager;
import org.tlauncher.injection.InjectionResult;
import org.tlauncher.injection.mapping.MappingManager;
import org.tlauncher.injection.mapping.Mappings;
import org.tlauncher.injection.mapping.ObfClass;
import org.tlauncher.tweaker.Tweaker;
import org.tlauncher.util.TLModCfg;

public class Injections {
    void registerInjections(InjectionManager injectionManager) {
        Mappings mappings = MappingManager.instance().getMappings();
        ObfClass abstractClientPlayer = mappings.getClass("AbstractClientPlayer");
        ObfClass entityPlayer = mappings.getClass("EntityPlayer");
        String resourceLocation = mappings.getClass("ResourceLocation").getObfName();
        String locCapeMethodName = abstractClientPlayer.getMethod("getLocationCape").getObfName();
        String abstrPlayerClassName = abstractClientPlayer.getObfName();
        String locSkinMethodName = abstractClientPlayer.getMethod("getLocationSkin").getObfName();
        String skinTypeMethodName = abstractClientPlayer.getMethod("getSkinType").getObfName();
        String playerClassName = entityPlayer.getObfName();
        String wearingMethodName = entityPlayer.getMethod("isWearing").getObfName();
        String locElytraMethodName = abstractClientPlayer.getMethod("getLocationElytra").getObfName();
        String minecraftClassName = mappings.getClass("Minecraft").getObfName();
        String gameProfileClassName = entityPlayer.getMethod("getGameProfile").getObfName();
        String resourceLocationDesc = String.format("()L%s;", resourceLocation);
        String modelPartDesc = String.format("(L%s;)Z", mappings.getClass("EnumPlayerModelParts").getObfName());
        if (Tweaker.isTLSkinCapeEnabled) {
            injectionManager.addInjection(abstrPlayerClassName, (bytes, injectionHelper) -> {
                ArrayList injectionResults = new ArrayList();
                injectionHelper.init(bytes).findMethod(locCapeMethodName, resourceLocationDesc).thenAccept(methodNodeWrap -> {
                    methodNodeWrap.getInstructions().clear();
                    methodNodeWrap.getInstructions().add((AbstractInsnNode)new VarInsnNode(25, 0));
                    methodNodeWrap.getInstructions().add((AbstractInsnNode)new MethodInsnNode(182, abstrPlayerClassName, gameProfileClassName, "()Lcom/mojang/authlib/GameProfile;", false));
                    methodNodeWrap.getInstructions().add((AbstractInsnNode)new MethodInsnNode(184, "org/tlauncher/TLSkinCape", "getLocationCape", String.format("(Lcom/mojang/authlib/GameProfile;)L%s;", resourceLocation), false));
                    methodNodeWrap.getInstructions().add((AbstractInsnNode)new InsnNode(176));
                    injectionResults.add(InjectionResult.SUCCESS);
                }).findMethod(locSkinMethodName, resourceLocationDesc).thenAccept(methodNodeWrap -> {
                    methodNodeWrap.getInstructions().clear();
                    methodNodeWrap.getInstructions().add((AbstractInsnNode)new VarInsnNode(25, 0));
                    methodNodeWrap.getInstructions().add((AbstractInsnNode)new MethodInsnNode(182, abstrPlayerClassName, gameProfileClassName, "()Lcom/mojang/authlib/GameProfile;", false));
                    methodNodeWrap.getInstructions().add((AbstractInsnNode)new MethodInsnNode(184, "org/tlauncher/TLSkinCape", "getLocationSkin", String.format("(Lcom/mojang/authlib/GameProfile;)L%s;", resourceLocation), false));
                    methodNodeWrap.getInstructions().add((AbstractInsnNode)new InsnNode(176));
                    injectionResults.add(InjectionResult.SUCCESS);
                }).findMethod(locElytraMethodName, resourceLocationDesc).nonNull().thenAccept(methodNodeWrap -> {
                    methodNodeWrap.getInstructions().clear();
                    methodNodeWrap.getInstructions().add((AbstractInsnNode)new VarInsnNode(25, 0));
                    methodNodeWrap.getInstructions().add((AbstractInsnNode)new MethodInsnNode(182, abstrPlayerClassName, gameProfileClassName, "()Lcom/mojang/authlib/GameProfile;", false));
                    methodNodeWrap.getInstructions().add((AbstractInsnNode)new MethodInsnNode(184, "org/tlauncher/TLSkinCape", "getLocationElytra", String.format("(Lcom/mojang/authlib/GameProfile;)L%s;", resourceLocation), false));
                    methodNodeWrap.getInstructions().add((AbstractInsnNode)new InsnNode(176));
                    injectionResults.add(InjectionResult.SUCCESS);
                }).findMethod(skinTypeMethodName, "()Ljava/lang/String;").thenAccept(methodNodeWrap -> {
                    methodNodeWrap.getInstructions().clear();
                    methodNodeWrap.getInstructions().add((AbstractInsnNode)new VarInsnNode(25, 0));
                    methodNodeWrap.getInstructions().add((AbstractInsnNode)new MethodInsnNode(182, abstrPlayerClassName, gameProfileClassName, "()Lcom/mojang/authlib/GameProfile;", false));
                    methodNodeWrap.getInstructions().add((AbstractInsnNode)new MethodInsnNode(184, "org/tlauncher/TLSkinCape", "getSkinType", "(Lcom/mojang/authlib/GameProfile;)Ljava/lang/String;", false));
                    methodNodeWrap.getInstructions().add((AbstractInsnNode)new InsnNode(176));
                    injectionResults.add(InjectionResult.SUCCESS);
                });
                for (InjectionResult injectionResult : injectionResults) {
                    if (injectionResult == InjectionResult.SUCCESS) continue;
                    return InjectionResult.FAILURE;
                }
                return InjectionResult.SUCCESS;
            });
            if (!Tweaker.useOldWearing) {
                ObfClass layerCape = mappings.getClass("LayerCape");
                injectionManager.addInjection(layerCape.getObfName(), (bytes, injectionHelper) -> injectionHelper.init(bytes).findMethod(layerCape.getMethod("doRenderLayer").getObfName(), Desc.builder().contains(abstrPlayerClassName).endsWith("FFFFFF)V").build()).thenApply(methodNodeWrap -> {
                    Optional<MethodInsnNode> first = methodNodeWrap.findInstruction().filter(node -> node instanceof MethodInsnNode).map(node -> (MethodInsnNode)node).filter(node -> node.owner.equals(playerClassName) || node.owner.equals(abstrPlayerClassName)).filter(node -> node.name.equals(wearingMethodName)).filter(node -> node.desc.equals(modelPartDesc)).findFirst();
                    if (first.isPresent()) {
                        MethodInsnNode methodInsnNode = first.get();
                        methodInsnNode.setOpcode(184);
                        methodInsnNode.owner = "org/tlauncher/TLSkinCape";
                        methodInsnNode.name = "isWearing";
                        methodInsnNode.desc = "(Ljava/lang/Object;Ljava/lang/Enum;)Z";
                        return InjectionResult.SUCCESS;
                    }
                    return InjectionResult.TARGET_METHOD_NOT_FOUND;
                }));
            } else {
                injectionManager.addInjection(playerClassName, (bytes, injectionHelper) -> injectionHelper.init(bytes).findMethod(wearingMethodName, modelPartDesc).thenApply(methodNodeWrap -> {
                    InsnList list = new InsnList();
                    LabelNode labelNode = new LabelNode();
                    list.add((AbstractInsnNode)new VarInsnNode(58, 2));
                    list.add((AbstractInsnNode)new VarInsnNode(25, 1));
                    list.add((AbstractInsnNode)new MethodInsnNode(184, "org/tlauncher/TLSkinCape", "isCapePart", "(Ljava/lang/Enum;)Z", false));
                    list.add((AbstractInsnNode)new JumpInsnNode(153, labelNode));
                    list.add((AbstractInsnNode)new InsnNode(4));
                    list.add((AbstractInsnNode)new InsnNode(172));
                    list.add((AbstractInsnNode)labelNode);
                    list.add((AbstractInsnNode)new VarInsnNode(25, 2));
                    methodNodeWrap.getInstructions().insertBefore(methodNodeWrap.getInstructions().getLast(), list);
                    return InjectionResult.SUCCESS;
                }));
            }
            ObfClass guiMainMenu = mappings.getClass("GuiMainMenu");
            injectionManager.addInjection(guiMainMenu.getObfName(), (bytes, injectionHelper) -> {
                String descriptor = TLModCfg.getMinecraftVersion().startsWith("1.16") ? String.format("(L%s;IIF)V", mappings.getClass("MatrixStack").getObfName()) : "(IIF)V";
                return injectionHelper.init(bytes).findMethod(guiMainMenu.getMethod("render").getObfName(), descriptor).thenApply(methodNodeWrap -> {
                    InsnList insnList = new InsnList();
                    insnList.add((AbstractInsnNode)new InsnNode(4));
                    insnList.add((AbstractInsnNode)new FieldInsnNode(179, "org/tlauncher/Variables", "isLoaded", "Z"));
                    insnList.add((AbstractInsnNode)new MethodInsnNode(184, "org/tlauncher/TLSkinCape", "onMainMenuRender", "()V", false));
                    methodNodeWrap.getInstructions().insert(methodNodeWrap.getInstructions().getFirst(), insnList);
                    return InjectionResult.SUCCESS;
                });
            });
            injectionManager.addInjection("net.minecraft.client.main.Main", (bytes, injectionHelper) -> injectionHelper.init(bytes).findMethod("main", "([Ljava/lang/String;)V").thenApply(methodNodeWrap -> {
                methodNodeWrap.findInstruction().filter(abstractInsnNode -> abstractInsnNode instanceof MethodInsnNode).map(abstractInsnNode -> (MethodInsnNode)abstractInsnNode).filter(methodInsnNode -> methodInsnNode.owner.equals("joptsimple/OptionParser")).filter(methodInsnNode -> methodInsnNode.name.equals("<init>")).findFirst().ifPresent(methodInsnNode -> {
                    methodInsnNode.desc = "(Z)V";
                    methodNodeWrap.getInstructions().insertBefore((AbstractInsnNode)methodInsnNode, (AbstractInsnNode)new InsnNode(3));
                });
                InsnList list = new InsnList();
                list.add((AbstractInsnNode)new VarInsnNode(25, 0));
                list.add((AbstractInsnNode)new MethodInsnNode(184, "org/tlauncher/TLSkinCape", "processMainArgs", "([Ljava/lang/String;)[Ljava/lang/String;", false));
                list.add((AbstractInsnNode)new VarInsnNode(58, 0));
                methodNodeWrap.getInstructions().insertBefore(methodNodeWrap.getInstructions().getFirst(), list);
                return InjectionResult.SUCCESS;
            }));
            injectionManager.addInjection(minecraftClassName, (bytes, injectionHelper) -> {
                injectionHelper.init(bytes).findMethod("<init>").forEach(objectMethodNodeContainer -> objectMethodNodeContainer.thenAccept(methodNodeWrap -> {
                    AbstractInsnNode instruction = methodNodeWrap.findInstruction(node -> node instanceof MethodInsnNode && ((MethodInsnNode)node).name.equals("<init>"));
                    InsnList list = new InsnList();
                    list.add((AbstractInsnNode)new VarInsnNode(25, 0));
                    list.add((AbstractInsnNode)new MethodInsnNode(184, "org/tlauncher/TLSkinCape", "startConnector", String.format("(L%s;)V", minecraftClassName), false));
                    methodNodeWrap.getInstructions().insert(instruction, list);
                }));
                return InjectionResult.SUCCESS;
            });
        }
    }
}

