/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.renderer.texture;

import com.mojang.blaze3d.systems.RenderSystem;
import java.io.IOException;
import java.lang.reflect.Method;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.resources.IResourceManager;
import org.lwjgl.opengl.GL11;

public class LightTexture
extends Texture
implements AutoCloseable {
    private static Method prepImage;
    private static Method bindTex;
    private static Method delTex;
    private static Method image_getWidth;
    private static Method image_getHeight;
    private static Method image_uploadTexture;
    private static Method image_close;
    protected int glTextureId = -1;

    public LightTexture(Object imageWrap) {
        if (prepImage == null) {
            prepImage = Class.forName("org.tlauncher.util.TextureUtils").getDeclaredMethod("prepareImage", Integer.TYPE, Integer.TYPE, Integer.TYPE);
        }
        if (bindTex == null) {
            bindTex = Class.forName("org.tlauncher.util.TextureUtils").getDeclaredMethod("bindTexture", Integer.TYPE);
        }
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> this.load(imageWrap));
        } else {
            this.load(imageWrap);
        }
    }

    private void load(Object imageWrap) {
        if (image_getWidth == null) {
            image_getWidth = imageWrap.getClass().getMethod("getWidth", new Class[0]);
            image_getHeight = imageWrap.getClass().getMethod("getHeight", new Class[0]);
            image_uploadTexture = imageWrap.getClass().getMethod("uploadTexture", Integer.TYPE);
            image_close = imageWrap.getClass().getMethod("close", new Class[0]);
        }
        Object width = image_getWidth.invoke(imageWrap, new Object[0]);
        Object height = image_getHeight.invoke(imageWrap, new Object[0]);
        prepImage.invoke(null, this.func_110552_b(), width, height);
        bindTex.invoke(null, this.func_110552_b());
        image_uploadTexture.invoke(imageWrap, this.func_110552_b());
        image_close.invoke(imageWrap, new Object[0]);
    }

    public int func_110552_b() {
        if (this.glTextureId == -1) {
            this.glTextureId = GL11.glGenTextures();
        }
        return this.glTextureId;
    }

    public void func_195413_a(IResourceManager resourceManager) throws IOException {
    }

    @Override
    public void close() {
        if (this.glTextureId != -1) {
            if (delTex == null) {
                delTex = Class.forName("org.tlauncher.util.TextureUtils").getDeclaredMethod("deleteTexture", Integer.TYPE);
            }
            delTex.invoke(null, this.glTextureId);
            this.glTextureId = -1;
        }
    }
}

