/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.culinaryconstruct.common.inventory;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.PotionItem;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;
import org.apache.commons.lang3.StringUtils;
import top.theillusivec4.culinaryconstruct.api.CulinaryConstructApi;
import top.theillusivec4.culinaryconstruct.api.capability.ICulinaryIngredient;
import top.theillusivec4.culinaryconstruct.common.CulinaryConstructConfig;
import top.theillusivec4.culinaryconstruct.common.advancement.CraftFoodTrigger;
import top.theillusivec4.culinaryconstruct.common.inventory.CulinaryCalculator;
import top.theillusivec4.culinaryconstruct.common.item.CulinaryItemBase;
import top.theillusivec4.culinaryconstruct.common.registry.CulinaryConstructRegistry;
import top.theillusivec4.culinaryconstruct.common.tag.CulinaryTags;
import top.theillusivec4.culinaryconstruct.common.tileentity.CulinaryStationTileEntity;

public class CulinaryStationContainer
extends Container {
    private final IWorldPosCallable worldPosCallable;
    private ItemStackHandler base = new ItemStackHandler();
    private ItemStackHandler ingredients = new ItemStackHandler(5);
    private ItemStackHandler output = new ItemStackHandler();
    private String outputItemName;

    public CulinaryStationContainer(int windowId, PlayerInventory playerInventory, PacketBuffer unused) {
        this(windowId, playerInventory, IWorldPosCallable.field_221489_a, null);
    }

    public CulinaryStationContainer(int windowId, PlayerInventory playerInventory, IWorldPosCallable worldPosCallable, @Nullable TileEntity tileEntity) {
        super(CulinaryConstructRegistry.CULINARY_STATION_CONTAINER, windowId);
        this.worldPosCallable = worldPosCallable;
        this.init(tileEntity);
        this.addFoodSlots();
        this.addPlayerSlots(playerInventory);
    }

    private void init(@Nullable TileEntity tileEntity) {
        if (tileEntity instanceof CulinaryStationTileEntity) {
            CulinaryStationTileEntity te = (CulinaryStationTileEntity)tileEntity;
            this.base = te.base;
            this.ingredients = te.ingredients;
            this.output = te.output;
        }
    }

    private void addFoodSlots() {
        this.func_75146_a((Slot)new BaseSlot((IItemHandler)this.base, 0, 8, 44));
        for (int i = 0; i < this.ingredients.getSlots(); ++i) {
            this.func_75146_a((Slot)new IngredientSlot((IItemHandler)this.ingredients, i, 44 + i * 18, 44));
        }
        this.func_75146_a((Slot)new OutputSlot((IItemHandler)this.output, 0, 152, 44));
    }

    private void addPlayerSlots(PlayerInventory playerInventory) {
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.func_75146_a(new Slot((IInventory)playerInventory, col + row * 9 + 9, 8 + col * 18, 79 + row * 18));
            }
        }
        for (int hotbar = 0; hotbar < 9; ++hotbar) {
            this.func_75146_a(new Slot((IInventory)playerInventory, hotbar, 8 + hotbar * 18, 137));
        }
    }

    public boolean func_75145_c(@Nonnull PlayerEntity playerIn) {
        return CulinaryStationContainer.func_216963_a((IWorldPosCallable)this.worldPosCallable, (PlayerEntity)playerIn, (Block)CulinaryConstructRegistry.CULINARY_STATION);
    }

    public void updateOutput() {
        ItemStack baseStack = this.base.getStackInSlot(0);
        if (baseStack.func_190926_b()) {
            this.resetOutput();
            return;
        }
        NonNullList ingredientsList = NonNullList.func_191196_a();
        for (int i = 0; i < this.ingredients.getSlots(); ++i) {
            ItemStack stack = this.ingredients.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            ItemStack copy = stack.func_77946_l();
            copy.func_190920_e(1);
            ingredientsList.add((Object)copy);
        }
        if (ingredientsList.isEmpty()) {
            this.resetOutput();
            return;
        }
        ItemStack baseCopy = baseStack.func_77946_l();
        baseCopy.func_190920_e(1);
        CulinaryCalculator calculator = new CulinaryCalculator(baseCopy, (NonNullList<ItemStack>)ingredientsList);
        ItemStack result = calculator.getResult();
        if (result.func_190926_b()) {
            this.resetOutput();
            return;
        }
        if (StringUtils.isBlank((CharSequence)this.outputItemName)) {
            result.func_135074_t();
        } else if (!this.outputItemName.equals(result.func_200301_q().getString())) {
            result.func_200302_a((ITextComponent)new StringTextComponent(this.outputItemName));
        }
        this.setOutput(result);
    }

    private void setOutput(ItemStack stack) {
        this.output.setStackInSlot(0, stack);
        this.func_75142_b();
    }

    private void resetOutput() {
        ItemStack outputStack = this.output.getStackInSlot(0);
        if (!outputStack.func_190926_b()) {
            this.output.setStackInSlot(0, ItemStack.field_190927_a);
            this.func_75142_b();
        }
    }

    @Nonnull
    public ItemStack func_82846_b(PlayerEntity playerIn, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (index == 6) {
                if (!this.func_75135_a(itemstack1, 7, 43, true)) {
                    return ItemStack.field_190927_a;
                }
                slot.func_75220_a(itemstack1, itemstack);
            } else if (index >= 7 && index < 43 ? !this.func_75135_a(itemstack1, 0, 1, false) && !this.func_75135_a(itemstack1, 1, 6, false) : !this.func_75135_a(itemstack1, 7, 43, false)) {
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (itemstack1.func_190916_E() == itemstack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(playerIn, itemstack1);
        }
        return itemstack;
    }

    public void updateItemName(String newName) {
        this.outputItemName = newName;
        this.updateOutput();
    }

    private class OutputSlot
    extends SlotItemHandler {
        public OutputSlot(IItemHandler handler, int index, int xPos, int yPos) {
            super(handler, index, xPos, yPos);
        }

        public boolean func_75214_a(@Nonnull ItemStack stack) {
            return false;
        }

        public void func_75218_e() {
            CulinaryStationContainer.this.updateOutput();
            CulinaryStationContainer.this.func_75142_b();
        }

        @Nonnull
        public ItemStack func_190901_a(PlayerEntity playerEntity, @Nonnull ItemStack stack) {
            ItemStackHandler base;
            ItemStackHandler ingredients;
            if (!playerEntity.field_70170_p.field_72995_K) {
                CraftFoodTrigger.INSTANCE.trigger((ServerPlayerEntity)playerEntity);
            }
            if ((ingredients = CulinaryStationContainer.this.ingredients) != null) {
                for (int i = 0; i < ingredients.getSlots(); ++i) {
                    ItemStack slot = ingredients.getStackInSlot(i);
                    if (slot.func_190926_b()) continue;
                    boolean isPotion = slot.func_77973_b() instanceof PotionItem;
                    ItemStack container = slot.func_77973_b().getContainerItem(slot);
                    slot.func_190918_g(1);
                    if (!container.func_190926_b()) {
                        ingredients.setStackInSlot(i, container);
                        continue;
                    }
                    if (!isPotion) continue;
                    ingredients.setStackInSlot(i, new ItemStack((IItemProvider)Items.field_151069_bo));
                }
            }
            if ((base = CulinaryStationContainer.this.base) != null) {
                base.getStackInSlot(0).func_190918_g(1);
            }
            CulinaryStationContainer.this.updateOutput();
            return stack;
        }
    }

    private class IngredientSlot
    extends SlotItemHandler {
        public IngredientSlot(IItemHandler handler, int index, int xPos, int yPos) {
            super(handler, index, xPos, yPos);
        }

        public void func_75218_e() {
            CulinaryStationContainer.this.updateOutput();
        }

        public boolean func_75214_a(@Nonnull ItemStack stack) {
            LazyOptional<ICulinaryIngredient> culinary = CulinaryConstructApi.getCulinaryIngredient(stack);
            return !(stack.func_77973_b() instanceof CulinaryItemBase) && (stack.func_77973_b().func_219971_r() || culinary.map(ICulinaryIngredient::isValid).orElse(false) != false) && CulinaryConstructConfig.isValidIngredient(stack);
        }
    }

    private class BaseSlot
    extends SlotItemHandler {
        public BaseSlot(IItemHandler handler, int index, int xPos, int yPos) {
            super(handler, index, xPos, yPos);
        }

        public void func_75218_e() {
            CulinaryStationContainer.this.updateOutput();
        }

        public boolean func_75214_a(@Nonnull ItemStack stack) {
            return stack.func_77973_b().func_206844_a(CulinaryTags.BREAD) || stack.func_77973_b().func_206844_a(CulinaryTags.BOWL);
        }
    }
}

