/*
 * Decompiled with CFR 0.152.
 */
package top.seraphjack.simplelogin.command;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.concurrent.CompletableFuture;
import net.minecraft.command.CommandSource;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.forgespi.Environment;
import top.seraphjack.simplelogin.command.EntryNameInput;
import top.seraphjack.simplelogin.server.storage.SLStorage;

public final class ArgumentTypeEntryName
implements ArgumentType<EntryNameInput> {
    private static final DynamicCommandExceptionType ENTRY_NOT_EXIST = new DynamicCommandExceptionType(o -> new TranslationTextComponent("simplelogin.command.error.entry_not_found", new Object[]{o}));

    private ArgumentTypeEntryName() {
    }

    public static ArgumentTypeEntryName entryName() {
        return new ArgumentTypeEntryName();
    }

    public EntryNameInput parse(StringReader reader) throws CommandSyntaxException {
        String name = reader.readString();
        if (Environment.get().getDist() == Dist.DEDICATED_SERVER && !SLStorage.instance().storageProvider.registered(name)) {
            throw ENTRY_NOT_EXIST.create((Object)name);
        }
        return EntryNameInput.of(name);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        if (context.getSource() instanceof CommandSource) {
            return ISuggestionProvider.func_197005_b(SLStorage.instance().storageProvider.getAllRegisteredUsername(), (SuggestionsBuilder)builder);
        }
        if (context.getSource() instanceof ISuggestionProvider) {
            CommandContext<S> ctx = context;
            return ((ISuggestionProvider)context.getSource()).func_197009_a(ctx, builder);
        }
        return Suggestions.empty();
    }

    public static String getEntryName(CommandContext<CommandSource> ctx, String name) {
        return ((EntryNameInput)ctx.getArgument(name, EntryNameInput.class)).getName();
    }
}

