/*
 * Decompiled with CFR 0.152.
 */
package top.seraphjack.simplelogin.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.io.IOException;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.GameType;
import top.seraphjack.simplelogin.command.ArgumentTypeEntryName;
import top.seraphjack.simplelogin.server.storage.SLStorage;

public class SLCommand {
    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"simplelogin").then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"save").requires(c -> c.func_197034_c(3))).executes(SLCommand::save))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"unregister").requires(c -> c.func_197034_c(3))).then(Commands.func_197056_a((String)"entry", (ArgumentType)ArgumentTypeEntryName.entryName()).executes(SLCommand::unregister)))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"setDefaultGameType").requires(c -> c.func_197034_c(3))).then(Commands.func_197056_a((String)"entry", (ArgumentType)ArgumentTypeEntryName.entryName()).then(Commands.func_197056_a((String)"mode", (ArgumentType)IntegerArgumentType.integer((int)0, (int)3)).executes(SLCommand::setDefaultGamemode))));
        dispatcher.register(command);
    }

    private static int save(CommandContext<CommandSource> ctx) {
        try {
            long start = System.currentTimeMillis();
            SLStorage.instance().storageProvider.save();
            long cost = System.currentTimeMillis() - start;
            ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)new StringTextComponent("Done. Took " + cost + " ms."), true);
        }
        catch (IOException e) {
            ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)new StringTextComponent("Error during saving entries, see log for details"), false);
        }
        return 1;
    }

    private static int unregister(CommandContext<CommandSource> ctx) {
        SLStorage.instance().storageProvider.unregister(ArgumentTypeEntryName.getEntryName(ctx, "entry"));
        ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)new StringTextComponent("Successfully unregistered."), false);
        return 1;
    }

    private static int setDefaultGamemode(CommandContext<CommandSource> ctx) {
        GameType gameType = GameType.values()[(Integer)ctx.getArgument("mode", Integer.class) + 1];
        SLStorage.instance().storageProvider.setGameType(ArgumentTypeEntryName.getEntryName(ctx, "entry"), gameType);
        ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)new StringTextComponent("Successfully set entry default game type to " + gameType.func_77149_b() + "."), false);
        return 1;
    }
}

