/*
 * Decompiled with CFR 0.152.
 */
package top.seraphjack.simplelogin.server.storage;

import java.io.IOException;
import java.nio.file.Path;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.ReportedException;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import top.seraphjack.simplelogin.server.storage.StorageProvider;
import top.seraphjack.simplelogin.server.storage.StorageProviderFile;

@OnlyIn(value=Dist.DEDICATED_SERVER)
public class SLStorage {
    public final StorageProvider storageProvider;
    private static SLStorage INSTANCE;

    public static SLStorage instance() {
        return INSTANCE;
    }

    public static void initialize(String method, Path path) {
        if (INSTANCE == null) {
            INSTANCE = new SLStorage(method, path);
        }
    }

    private SLStorage(String method, Path path) {
        switch (method) {
            case "file": {
                try {
                    this.storageProvider = new StorageProviderFile(path);
                    break;
                }
                catch (IOException ex) {
                    throw new ReportedException(new CrashReport("Unable to initialize storage provider", (Throwable)ex));
                }
            }
            default: {
                throw new RuntimeException("Invalid storage method: " + method + ".");
            }
        }
    }
}

