/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.intern.network;

import info.u_team.u_team_core.container.FluidContainer;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.inventory.container.Container;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.network.NetworkEvent;

public class FluidSetSlotContainerMessage {
    private final int id;
    private final int slot;
    private final FluidStack stack;

    public FluidSetSlotContainerMessage(int id, int slot, FluidStack stack) {
        this.id = id;
        this.slot = slot;
        this.stack = stack;
    }

    public static void encode(FluidSetSlotContainerMessage message, PacketBuffer sendBuffer) {
        sendBuffer.writeByte(message.id);
        sendBuffer.writeShort(message.slot);
        sendBuffer.writeFluidStack(message.stack);
    }

    public static FluidSetSlotContainerMessage decode(PacketBuffer sendBuffer) {
        byte id = sendBuffer.readByte();
        short slot = sendBuffer.readShort();
        FluidStack stack = sendBuffer.readFluidStack();
        return new FluidSetSlotContainerMessage(id, slot, stack);
    }

    public static class Handler {
        public static void handle(FluidSetSlotContainerMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> Handler.getFluidContainer(Minecraft.func_71410_x().field_71439_g.field_71070_bA, message.id).ifPresent(container -> container.setFluidStackInSlot(message.slot, message.stack)));
            context.setPacketHandled(true);
        }

        private static final Optional<FluidContainer> getFluidContainer(Container container, int id) {
            if (container instanceof FluidContainer && container.field_75152_c == id) {
                return Optional.of((FluidContainer)container);
            }
            return Optional.empty();
        }
    }
}

