/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.util;

import java.util.Random;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;

public class MathUtil {
    public static final Random RANDOM = new Random();

    public static Vector3d rotateVectorAroundYCC(Vector3d vec, double angle) {
        return MathUtil.rotateVectorCC(vec, new Vector3d(0.0, 1.0, 0.0), angle);
    }

    public static Vector3d rotateVectorCC(Vector3d vec, Vector3d axis, double angle) {
        double x = vec.func_82615_a();
        double y = vec.func_82617_b();
        double z = vec.func_82616_c();
        double u = axis.func_82615_a();
        double v = axis.func_82617_b();
        double w = axis.func_82616_c();
        double rotationX = u * (u * x + v * y + w * z) * (1.0 - Math.cos(angle)) + x * Math.cos(angle) + (-w * y + v * z) * Math.sin(angle);
        double rotationY = v * (u * x + v * y + w * z) * (1.0 - Math.cos(angle)) + y * Math.cos(angle) + (w * x - u * z) * Math.sin(angle);
        double rotationZ = w * (u * x + v * y + w * z) * (1.0 - Math.cos(angle)) + z * Math.cos(angle) + (-v * x + u * y) * Math.sin(angle);
        return new Vector3d(rotationX, rotationY, rotationZ);
    }

    public static int randomNumberInRange(int min, int max) {
        return MathUtil.randomNumberInRange(RANDOM, min, max);
    }

    public static int randomNumberInRange(Random random, int min, int max) {
        return random.nextInt(max - min + 1) + min;
    }

    public static float randomNumberInRange(float min, float max) {
        return MathUtil.randomNumberInRange(RANDOM, min, max);
    }

    public static float randomNumberInRange(Random random, float min, float max) {
        return random.nextFloat() * (max - min) + min;
    }

    public static double randomNumberInRange(double min, double max) {
        return MathUtil.randomNumberInRange(RANDOM, min, max);
    }

    public static double randomNumberInRange(Random random, double min, double max) {
        return random.nextDouble() * (max - min) + min;
    }

    public static int valueInRange(int min, int max, int value) {
        return Math.min(max, Math.max(min, value));
    }

    public static long valueInRange(long min, long max, long value) {
        return Math.min(max, Math.max(min, value));
    }

    public static float valueInRange(float min, float max, float value) {
        return Math.min(max, Math.max(min, value));
    }

    public static double valueInRange(double min, double max, double value) {
        return Math.min(max, Math.max(min, value));
    }

    public static float getPlaneDistance(int x1, int z1, int x2, int z2) {
        int xDiff = x2 - x1;
        int zDiff = z2 - z1;
        return MathHelper.func_76129_c((float)(xDiff * xDiff + zDiff * zDiff));
    }
}

