/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.block;

import com.mrcrayfish.furniture.block.FurnitureBlock;
import com.mrcrayfish.furniture.core.ModSounds;
import com.mrcrayfish.furniture.tileentity.TrampolineTileEntity;
import com.mrcrayfish.furniture.util.VoxelShapeHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class TrampolineBlock
extends FurnitureBlock {
    public static final BooleanProperty NORTH = BooleanProperty.func_177716_a((String)"north");
    public static final BooleanProperty EAST = BooleanProperty.func_177716_a((String)"east");
    public static final BooleanProperty SOUTH = BooleanProperty.func_177716_a((String)"south");
    public static final BooleanProperty WEST = BooleanProperty.func_177716_a((String)"west");
    public static final BooleanProperty CORNER_NORTH_WEST = BooleanProperty.func_177716_a((String)"corner_north_west");
    public static final BooleanProperty CORNER_NORTH_EAST = BooleanProperty.func_177716_a((String)"corner_north_east");
    public static final BooleanProperty CORNER_SOUTH_EAST = BooleanProperty.func_177716_a((String)"corner_south_east");
    public static final BooleanProperty CORNER_SOUTH_WEST = BooleanProperty.func_177716_a((String)"corner_south_west");
    public final Map<BlockState, VoxelShape> SHAPES = new HashMap<BlockState, VoxelShape>();

    public TrampolineBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)NORTH, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)EAST, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)SOUTH, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)WEST, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)CORNER_NORTH_WEST, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)CORNER_NORTH_EAST, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)CORNER_SOUTH_EAST, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)CORNER_SOUTH_WEST, (Comparable)Boolean.valueOf(false)));
    }

    private VoxelShape getShape(BlockState state) {
        if (this.SHAPES.containsKey(state)) {
            return this.SHAPES.get(state);
        }
        VoxelShape BOTTOM_LEFT_SUPPORT_SHORT = Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)4.0, (double)3.0, (double)15.0);
        VoxelShape BOTTOM_LEFT_SUPPORT_LONG = Block.func_208617_a((double)1.0, (double)0.0, (double)0.0, (double)4.0, (double)3.0, (double)16.0);
        VoxelShape BOTTOM_LEFT_SUPPORT_NORTH = Block.func_208617_a((double)1.0, (double)0.0, (double)0.0, (double)4.0, (double)3.0, (double)15.0);
        VoxelShape BOTTOM_LEFT_SUPPORT_SOUTH = Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)4.0, (double)3.0, (double)16.0);
        VoxelShape BACK_LEFT_LEG = Block.func_208617_a((double)1.0, (double)3.0, (double)1.0, (double)4.0, (double)13.0, (double)4.0);
        VoxelShape FRONT_LEFT_LEG = Block.func_208617_a((double)1.0, (double)3.0, (double)12.0, (double)4.0, (double)13.0, (double)15.0);
        VoxelShape TOP = Block.func_208617_a((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        VoxelShape BOTTOM_RIGHT_SUPPORT_SHORT = Block.func_208617_a((double)12.0, (double)0.0, (double)1.0, (double)15.0, (double)3.0, (double)15.0);
        VoxelShape BOTTOM_RIGHT_SUPPORT_LONG = Block.func_208617_a((double)12.0, (double)0.0, (double)0.0, (double)15.0, (double)3.0, (double)16.0);
        VoxelShape BOTTOM_RIGHT_SUPPORT_NORTH = Block.func_208617_a((double)12.0, (double)0.0, (double)0.0, (double)15.0, (double)3.0, (double)15.0);
        VoxelShape BOTTOM_RIGHT_SUPPORT_SOUTH = Block.func_208617_a((double)12.0, (double)0.0, (double)1.0, (double)15.0, (double)3.0, (double)16.0);
        VoxelShape FRONT_RIGHT_LEG = Block.func_208617_a((double)12.0, (double)3.0, (double)12.0, (double)15.0, (double)13.0, (double)15.0);
        VoxelShape BACK_RIGHT_LEG = Block.func_208617_a((double)12.0, (double)3.0, (double)1.0, (double)15.0, (double)13.0, (double)4.0);
        VoxelShape NORTH_WEST_CORNER_SUPPORT = Block.func_208617_a((double)1.0, (double)0.0, (double)0.0, (double)4.0, (double)3.0, (double)4.0);
        VoxelShape NORTH_EAST_CORNER_SUPPORT = Block.func_208617_a((double)12.0, (double)0.0, (double)0.0, (double)15.0, (double)3.0, (double)4.0);
        VoxelShape SOUTH_EAST_CORNER_SUPPORT = Block.func_208617_a((double)12.0, (double)0.0, (double)12.0, (double)15.0, (double)3.0, (double)16.0);
        VoxelShape SOUTH_WEST_CORNER_SUPPORT = Block.func_208617_a((double)1.0, (double)0.0, (double)12.0, (double)4.0, (double)3.0, (double)16.0);
        boolean north = (Boolean)state.func_177229_b((Property)NORTH);
        boolean east = (Boolean)state.func_177229_b((Property)EAST);
        boolean south = (Boolean)state.func_177229_b((Property)SOUTH);
        boolean west = (Boolean)state.func_177229_b((Property)WEST);
        boolean cornerNorthWest = (Boolean)state.func_177229_b((Property)CORNER_NORTH_WEST);
        boolean cornerNorthEast = (Boolean)state.func_177229_b((Property)CORNER_NORTH_EAST);
        boolean cornerSouthEast = (Boolean)state.func_177229_b((Property)CORNER_SOUTH_EAST);
        boolean cornerSouthWest = (Boolean)state.func_177229_b((Property)CORNER_SOUTH_WEST);
        ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
        shapes.add(TOP);
        int count = 0;
        count += north ? 1 : 0;
        count += east ? 1 : 0;
        count += south ? 1 : 0;
        if ((count += west ? 1 : 0) >= 2) {
            if (north && !east && south && !west) {
                shapes.add(BOTTOM_LEFT_SUPPORT_LONG);
                shapes.add(BOTTOM_RIGHT_SUPPORT_LONG);
                VoxelShape shape = VoxelShapeHelper.combineAll(shapes);
                this.SHAPES.put(state, shape);
                return shape;
            }
            if (!north && east && !south && west) {
                VoxelShape shape = VoxelShapeHelper.combineAll(shapes);
                this.SHAPES.put(state, shape);
                return shape;
            }
        }
        if (north && east && !south && !west) {
            shapes.add(FRONT_LEFT_LEG);
        }
        if (north && !east && !south && west) {
            shapes.add(FRONT_RIGHT_LEG);
        }
        if (!north && east && south && !west) {
            shapes.add(BACK_LEFT_LEG);
        }
        if (!north && !east && south && west) {
            shapes.add(BACK_RIGHT_LEG);
        }
        if (!west) {
            if (south) {
                if (!north) {
                    shapes.add(BACK_LEFT_LEG);
                }
                shapes.add(BOTTOM_LEFT_SUPPORT_SOUTH);
            } else if (north) {
                shapes.add(FRONT_LEFT_LEG);
                shapes.add(BOTTOM_LEFT_SUPPORT_NORTH);
            } else {
                shapes.add(FRONT_LEFT_LEG);
                shapes.add(BACK_LEFT_LEG);
                shapes.add(BOTTOM_LEFT_SUPPORT_SHORT);
            }
        }
        if (!east) {
            if (south) {
                if (!north) {
                    shapes.add(BACK_RIGHT_LEG);
                }
                shapes.add(BOTTOM_RIGHT_SUPPORT_SOUTH);
            } else if (north) {
                shapes.add(FRONT_RIGHT_LEG);
                shapes.add(BOTTOM_RIGHT_SUPPORT_NORTH);
            } else {
                shapes.add(FRONT_RIGHT_LEG);
                shapes.add(BACK_RIGHT_LEG);
                shapes.add(BOTTOM_RIGHT_SUPPORT_SHORT);
            }
        }
        if (cornerNorthWest) {
            shapes.add(NORTH_WEST_CORNER_SUPPORT);
            shapes.add(BACK_LEFT_LEG);
        }
        if (cornerNorthEast) {
            shapes.add(NORTH_EAST_CORNER_SUPPORT);
            shapes.add(BACK_RIGHT_LEG);
        }
        if (cornerSouthEast) {
            shapes.add(SOUTH_EAST_CORNER_SUPPORT);
            shapes.add(FRONT_RIGHT_LEG);
        }
        if (cornerSouthWest) {
            shapes.add(SOUTH_WEST_CORNER_SUPPORT);
            shapes.add(FRONT_LEFT_LEG);
        }
        VoxelShape shape = VoxelShapeHelper.combineAll(shapes);
        this.SHAPES.put(state, shape);
        return shape;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader reader, BlockPos pos, ISelectionContext context) {
        return this.getShape(state);
    }

    public VoxelShape func_196247_c(BlockState state, IBlockReader reader, BlockPos pos) {
        return this.getShape(state);
    }

    public void func_180658_a(World worldIn, BlockPos pos, Entity entityIn, float fallDistance) {
        if (entityIn instanceof LivingEntity) {
            float height;
            float strength = 1.0f;
            float maxHeight = 0.0f;
            TileEntity tileEntity = worldIn.func_175625_s(pos);
            if (tileEntity instanceof TrampolineTileEntity) {
                TrampolineTileEntity trampoline = (TrampolineTileEntity)tileEntity;
                strength += (float)trampoline.getCount() / 100.0f;
                maxHeight = (float)trampoline.getCount() * 0.25f;
            }
            if ((height = entityIn.field_70143_R * strength) > 0.0f && !entityIn.func_225608_bj_()) {
                if (height > maxHeight - 0.25f) {
                    height = maxHeight - 0.25f;
                }
                entityIn.func_213317_d(entityIn.func_213322_ci().func_216372_d(1.0, 0.0, 1.0));
                entityIn.func_70024_g(0.0, Math.sqrt(0.22 * (double)(height + 0.25f)), 0.0);
                if (worldIn.field_72995_K) {
                    for (int i = 0; i < 5; ++i) {
                        worldIn.func_195594_a((IParticleData)ParticleTypes.field_197625_r, entityIn.field_70169_q, entityIn.field_70167_r, entityIn.field_70166_s, 1.0, 1.0, 1.0);
                    }
                } else {
                    worldIn.func_184133_a(null, pos, ModSounds.BLOCK_TRAMPOLINE_BOUNCE, SoundCategory.BLOCKS, 1.0f, worldIn.field_73012_v.nextFloat() * 0.2f + 0.9f);
                }
            }
            entityIn.field_70143_R = 0.0f;
        }
    }

    public void func_176216_a(IBlockReader worldIn, Entity entityIn) {
    }

    public boolean addLandingEffects(BlockState state1, ServerWorld worldserver, BlockPos pos, BlockState state2, LivingEntity entity, int numberOfParticles) {
        return true;
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        TileEntity tileEntity;
        if (!worldIn.field_72995_K && (tileEntity = worldIn.func_175625_s(pos)) instanceof TrampolineTileEntity) {
            ((TrampolineTileEntity)tileEntity).updateCount();
        }
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return this.getTrampolineState(super.func_196258_a(context), (IWorld)context.func_195991_k(), context.func_195995_a());
    }

    public BlockState func_196271_a(BlockState state, Direction direction, BlockState newState, IWorld world, BlockPos pos, BlockPos newPos) {
        return this.getTrampolineState(state, world, pos);
    }

    private BlockState getTrampolineState(BlockState state, IWorld world, BlockPos pos) {
        boolean north = world.func_180495_p(pos.func_177978_c()).func_177230_c() == this;
        boolean east = world.func_180495_p(pos.func_177974_f()).func_177230_c() == this;
        boolean south = world.func_180495_p(pos.func_177968_d()).func_177230_c() == this;
        boolean west = world.func_180495_p(pos.func_177976_e()).func_177230_c() == this;
        boolean cornerNorthWest = north && west && world.func_180495_p(pos.func_177978_c().func_177976_e()).func_177230_c() != this;
        boolean cornerNorthEast = north && east && world.func_180495_p(pos.func_177978_c().func_177974_f()).func_177230_c() != this;
        boolean cornerSouthEast = south && east && world.func_180495_p(pos.func_177968_d().func_177974_f()).func_177230_c() != this;
        boolean cornerSouthWest = south && west && world.func_180495_p(pos.func_177968_d().func_177976_e()).func_177230_c() != this;
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.func_206870_a((Property)NORTH, (Comparable)Boolean.valueOf(north))).func_206870_a((Property)EAST, (Comparable)Boolean.valueOf(east))).func_206870_a((Property)SOUTH, (Comparable)Boolean.valueOf(south))).func_206870_a((Property)WEST, (Comparable)Boolean.valueOf(west))).func_206870_a((Property)CORNER_NORTH_WEST, (Comparable)Boolean.valueOf(cornerNorthWest))).func_206870_a((Property)CORNER_NORTH_EAST, (Comparable)Boolean.valueOf(cornerNorthEast))).func_206870_a((Property)CORNER_SOUTH_EAST, (Comparable)Boolean.valueOf(cornerSouthEast))).func_206870_a((Property)CORNER_SOUTH_WEST, (Comparable)Boolean.valueOf(cornerSouthWest));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{NORTH});
        builder.func_206894_a(new Property[]{EAST});
        builder.func_206894_a(new Property[]{SOUTH});
        builder.func_206894_a(new Property[]{WEST});
        builder.func_206894_a(new Property[]{CORNER_NORTH_WEST});
        builder.func_206894_a(new Property[]{CORNER_NORTH_EAST});
        builder.func_206894_a(new Property[]{CORNER_SOUTH_EAST});
        builder.func_206894_a(new Property[]{CORNER_SOUTH_WEST});
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TrampolineTileEntity();
    }
}

