/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.core;

import com.mrcrayfish.furniture.item.crafting.CookingRecipeSerializer;
import com.mrcrayfish.furniture.item.crafting.FreezerSolidifyRecipe;
import com.mrcrayfish.furniture.item.crafting.GrillCookingRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="cfm", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModRecipeSerializers {
    private static final List<IRecipeSerializer> RECIPES = new ArrayList<IRecipeSerializer>();
    public static final CookingRecipeSerializer<GrillCookingRecipe> GRILL_COOKING = ModRecipeSerializers.register("cfm:grill_cooking", new CookingRecipeSerializer<GrillCookingRecipe>(GrillCookingRecipe::new, 100));
    public static final CookingRecipeSerializer<FreezerSolidifyRecipe> FREEZER_SOLIDIFY = ModRecipeSerializers.register("cfm:freezer_solidify", new CookingRecipeSerializer<FreezerSolidifyRecipe>(FreezerSolidifyRecipe::new, 100));

    private static <T extends IRecipeSerializer<? extends IRecipe<?>>> T register(String name, T t) {
        t.setRegistryName(new ResourceLocation(name));
        RECIPES.add(t);
        return t;
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<IRecipeSerializer<?>> event) {
        RECIPES.forEach(item -> event.getRegistry().register((IForgeRegistryEntry)item));
        RECIPES.clear();
    }
}

