/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.configlib;

import com.supermartijn642.configlib.ConfigLib;
import com.supermartijn642.configlib.ModConfig;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class ConfigSyncPacket {
    private String modid;
    private ModConfig.Type type;
    private final Map<String, Object> values = new HashMap<String, Object>();

    protected ConfigSyncPacket(ModConfig config) {
        this.modid = config.getModid();
        this.type = config.getType();
        this.values.putAll(config.getValuesToSync());
    }

    protected ConfigSyncPacket(PacketBuffer buffer) {
        this.decode(buffer);
    }

    protected void encode(PacketBuffer buffer) {
        buffer.func_180714_a(this.modid);
        buffer.func_179249_a((Enum)this.type);
        buffer.writeInt(this.values.size());
        for (Map.Entry<String, Object> entry : this.values.entrySet()) {
            buffer.func_180714_a(entry.getKey());
            Object object = entry.getValue();
            if (object instanceof Boolean) {
                buffer.writeByte(1);
                buffer.writeBoolean(((Boolean)object).booleanValue());
                continue;
            }
            if (object instanceof Integer) {
                buffer.writeByte(2);
                buffer.writeInt(((Integer)object).intValue());
                continue;
            }
            if (object instanceof Double) {
                buffer.writeByte(3);
                buffer.writeDouble(((Double)object).doubleValue());
                continue;
            }
            if (object instanceof Float) {
                buffer.writeByte(4);
                buffer.writeFloat(((Float)object).floatValue());
                continue;
            }
            if (object instanceof Enum) {
                byte[] bytes = null;
                try {
                    ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
                    ObjectOutputStream stream = new ObjectOutputStream(byteStream);
                    stream.writeObject(object);
                    stream.flush();
                    stream.close();
                    bytes = byteStream.toByteArray();
                }
                catch (Exception e) {
                    System.err.println("Failed to write enum: " + object.getClass() + "#" + object);
                    e.printStackTrace();
                    buffer.writeInt(0);
                }
                if (bytes == null) continue;
                buffer.writeByte(5);
                buffer.writeInt(bytes.length);
                buffer.writeBytes(bytes);
                continue;
            }
            System.err.println("Don't know how to write object: " + object.getClass());
            buffer.writeByte(0);
        }
    }

    private void decode(PacketBuffer buffer) {
        this.modid = buffer.func_218666_n();
        this.type = (ModConfig.Type)buffer.func_179257_a(ModConfig.Type.class);
        int size = buffer.readInt();
        for (int i = 0; i < size; ++i) {
            Object object;
            String path = buffer.func_150789_c(Short.MAX_VALUE);
            byte objectType = buffer.readByte();
            switch (objectType) {
                case 1: {
                    object = buffer.readBoolean();
                    break;
                }
                case 2: {
                    object = buffer.readInt();
                    break;
                }
                case 3: {
                    object = buffer.readDouble();
                    break;
                }
                case 4: {
                    object = Float.valueOf(buffer.readFloat());
                    break;
                }
                case 5: {
                    byte[] bytes = new byte[buffer.readInt()];
                    buffer.readBytes(bytes);
                    try {
                        ObjectInputStream stream = new ObjectInputStream(new ByteArrayInputStream(bytes));
                        object = (Enum)stream.readObject();
                    }
                    catch (Exception e) {
                        System.err.println("Failed to decode enum value:");
                        e.printStackTrace();
                        object = null;
                    }
                    break;
                }
                default: {
                    object = null;
                }
            }
            if (object == null) continue;
            this.values.put(path, object);
        }
    }

    public void handle(Supplier<NetworkEvent.Context> contextSupplier) {
        contextSupplier.get().setPacketHandled(true);
        ModConfig config = ConfigLib.getConfig(this.modid, this.type);
        if (config == null) {
            System.out.println("Failed to find config: " + this.modid + "-" + this.type.name().toLowerCase(Locale.ROOT));
        } else {
            for (Map.Entry<String, Object> entry : this.values.entrySet()) {
                config.setSyncValue(entry.getKey(), entry.getValue());
            }
        }
    }
}

