/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.configlib;

import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.supermartijn642.configlib.ModConfigValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ModConfig {
    private final Object threadLock = new Object();
    private final CommentedFileConfig configuration;
    private final String modid;
    private final Type type;
    private final Map<String, ModConfigValue<?>> valuesByPath = new HashMap();
    private final List<ModConfigValue<?>> values;
    private final List<ModConfigValue<?>> updatableValues = new ArrayList();
    private final List<ModConfigValue<?>> syncableValues = new ArrayList();
    private final Map<String, Object> valuesToSync = new HashMap<String, Object>();

    protected ModConfig(CommentedFileConfig configuration, String modid, Type type, List<ModConfigValue<?>> values) {
        this.configuration = configuration;
        this.modid = modid;
        this.type = type;
        this.values = values;
        for (ModConfigValue<?> value : values) {
            if (!value.isGameRestartRequired()) {
                this.updatableValues.add(value);
            }
            if (value.shouldBeSynced()) {
                this.syncableValues.add(value);
            }
            this.valuesByPath.put(value.getFullPath(), value);
        }
    }

    protected String getModid() {
        return this.modid;
    }

    protected Type getType() {
        return this.type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateValues() {
        Object object = this.threadLock;
        synchronized (object) {
            this.configuration.load();
            for (ModConfigValue<?> value : this.updatableValues) {
                value.updateValue();
            }
            this.valuesToSync.clear();
            for (ModConfigValue<?> value : this.syncableValues) {
                this.valuesToSync.put(value.getFullPath(), value.get());
            }
        }
    }

    protected Map<String, Object> getValuesToSync() {
        return this.valuesToSync;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setSyncValue(String path, Object value) {
        Object object = this.threadLock;
        synchronized (object) {
            ModConfigValue<?> configValue = this.valuesByPath.get(path);
            if (configValue != null) {
                configValue.setSyncedValue(value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearSyncedValues() {
        Object object = this.threadLock;
        synchronized (object) {
            for (ModConfigValue<?> value : this.syncableValues) {
                value.clearSyncedValue();
            }
        }
    }

    public String toString() {
        return "ModConfig{modid='" + this.modid + '\'' + ", type=" + (Object)((Object)this.type) + '}';
    }

    public static enum Type {
        CLIENT,
        SERVER,
        COMMON;

    }
}

