/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.configlib;

import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfigBuilder;
import com.supermartijn642.configlib.ConfigLib;
import com.supermartijn642.configlib.ModConfig;
import com.supermartijn642.configlib.ModConfigValue;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;

public class ModConfigBuilder {
    private final List<ModConfigValue<?>> allValues = new ArrayList();
    private final Map<String, String> categoryComments = new HashMap<String, String>();
    private String category = "";
    private String comment = "";
    private boolean requiresGameRestart = false;
    private boolean syncWithClient = true;
    private final String modid;
    private final ModConfig.Type type;

    public ModConfigBuilder(String modid, ModConfig.Type type) {
        this.modid = modid;
        this.type = type;
    }

    public ModConfigBuilder(String modid) {
        this(modid, ModConfig.Type.COMMON);
    }

    public ModConfigBuilder push(String category) {
        if (category == null) {
            throw new IllegalArgumentException("category must not be null");
        }
        if (category.isEmpty()) {
            throw new IllegalArgumentException("category must not be empty");
        }
        if (this.category.isEmpty()) {
            this.category = category;
        }
        this.category = this.category + "." + category;
        return this;
    }

    public ModConfigBuilder pop() {
        if (this.category.isEmpty()) {
            throw new IllegalStateException("no more categories to pop");
        }
        int index = this.category.lastIndexOf(".");
        this.category = index == -1 ? "" : this.category.substring(0, index);
        return this;
    }

    public ModConfigBuilder categoryComment(String comment) {
        if (comment == null) {
            throw new IllegalArgumentException("comment must not be null");
        }
        if (comment.isEmpty()) {
            throw new IllegalArgumentException("comment must not be empty");
        }
        if (this.category.isEmpty()) {
            throw new IllegalStateException("no category pushed");
        }
        if (this.categoryComments.containsKey(this.category)) {
            throw new IllegalStateException("category " + this.category + " already has a comment");
        }
        this.categoryComments.put(this.category, comment);
        return this;
    }

    public ModConfigBuilder gameRestart() {
        this.requiresGameRestart = true;
        return this;
    }

    public ModConfigBuilder dontSync() {
        this.syncWithClient = false;
        return this;
    }

    public ModConfigBuilder comment(String comment) {
        if (comment == null) {
            throw new IllegalArgumentException("comment must not be null");
        }
        if (comment.isEmpty()) {
            throw new IllegalArgumentException("comment must not be empty");
        }
        if (!this.comment.isEmpty()) {
            throw new IllegalStateException("a comment is already specified");
        }
        this.comment = comment;
        return this;
    }

    public Supplier<Boolean> define(String name, boolean defaultValue) {
        ModConfigValue.BooleanValue value = new ModConfigValue.BooleanValue(this.getPath(name), this.comment, this.requiresGameRestart, this.syncWithClient, defaultValue);
        this.allValues.add(value);
        this.resetValues();
        return value::get;
    }

    public Supplier<Integer> define(String name, int defaultValue, int minValue, int maxValue) {
        ModConfigValue.IntegerValue value = new ModConfigValue.IntegerValue(this.getPath(name), this.comment, this.requiresGameRestart, this.syncWithClient, defaultValue, minValue, maxValue);
        this.allValues.add(value);
        this.resetValues();
        return value::get;
    }

    public Supplier<Double> define(String name, double defaultValue, double minValue, double maxValue) {
        ModConfigValue.FloatingValue value = new ModConfigValue.FloatingValue(this.getPath(name), this.comment, this.requiresGameRestart, this.syncWithClient, defaultValue, minValue, maxValue);
        this.allValues.add(value);
        this.resetValues();
        return value::get;
    }

    public <T extends Enum<T>> Supplier<T> define(String name, T defaultValue) {
        ModConfigValue.EnumValue<T> value = new ModConfigValue.EnumValue<T>(this.getPath(name), this.comment, this.requiresGameRestart, this.syncWithClient, defaultValue);
        this.allValues.add(value);
        this.resetValues();
        return value::get;
    }

    private String getPath(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        if (name.isEmpty()) {
            throw new IllegalArgumentException("name must not be empty");
        }
        return (this.category.isEmpty() ? "" : this.category + '.') + name;
    }

    private void resetValues() {
        this.requiresGameRestart = false;
        this.syncWithClient = true;
        this.comment = "";
    }

    public void build() {
        File file = new File(new File("."), "config/" + this.modid + '-' + this.type.name().toLowerCase(Locale.ROOT) + ".toml");
        CommentedFileConfigBuilder builder = CommentedFileConfig.builder((File)file);
        CommentedFileConfig configuration = (CommentedFileConfig)builder.concurrent().build();
        configuration.load();
        this.build(configuration);
        configuration.save();
        ModConfig config = new ModConfig(configuration, this.modid, this.type, this.allValues);
        ConfigLib.addConfig(config);
    }

    private void build(CommentedFileConfig config) {
        for (ModConfigValue<?> modConfigValue : this.allValues) {
            modConfigValue.build(config);
        }
        for (Map.Entry entry : this.categoryComments.entrySet()) {
            config.setComment((String)entry.getKey(), (String)entry.getValue());
        }
    }
}

