/*
 * Decompiled with CFR 0.152.
 */
package com.mcwwindows.kikoz.objects;

import com.mcwwindows.kikoz.objects.Double_Core;
import com.mcwwindows.kikoz.util.parts.DoubleTallPart;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class BlindsTall
extends Double_Core
implements IWaterLoggable {
    private static final EnumProperty<DoubleTallPart> PART = EnumProperty.func_177709_a((String)"part", DoubleTallPart.class);
    private static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    protected static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    public static final BooleanProperty OPEN = BlockStateProperties.field_208193_t;
    String infoname;
    boolean hasTextInfo = true;
    protected static final VoxelShape WEST = Stream.of(Block.func_208617_a((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
    protected static final VoxelShape SOUTH = Stream.of(Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
    protected static final VoxelShape EAST = Stream.of(Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
    protected static final VoxelShape NORTH = Stream.of(Block.func_208617_a((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();

    @Override
    public VoxelShape func_220053_a(BlockState state, IBlockReader blockReader, BlockPos pos, ISelectionContext selectionContext) {
        switch ((Direction)state.func_177229_b((Property)FACING)) {
            case NORTH: {
                if (state.func_177229_b(PART) == DoubleTallPart.LOWER) {
                    return NORTH;
                }
                return NORTH;
            }
            case SOUTH: {
                if (state.func_177229_b(PART) == DoubleTallPart.LOWER) {
                    return SOUTH;
                }
                return SOUTH;
            }
            case EAST: {
                if (state.func_177229_b(PART) == DoubleTallPart.LOWER) {
                    return EAST;
                }
                return EAST;
            }
        }
        if (state.func_177229_b(PART) == DoubleTallPart.LOWER) {
            return WEST;
        }
        return WEST;
    }

    @Override
    public void place(World world, BlockPos pos, Direction direction) {
        BlockState state = (BlockState)((BlockState)this.func_176223_P().func_206870_a(PART, (Comparable)((Object)DoubleTallPart.LOWER))).func_206870_a((Property)FACING, (Comparable)direction);
        world.func_180501_a(pos, state, 3);
        this.place(world, pos, state, direction.func_176734_d());
    }

    @Override
    public void place(World world, BlockPos pos, BlockState state, Direction direction) {
        FluidState middleFluidState = world.func_204610_c(pos.func_177984_a());
        world.func_180501_a(pos.func_177984_a(), (BlockState)((BlockState)state.func_206870_a(PART, (Comparable)((Object)DoubleTallPart.UPPER))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(middleFluidState.func_206886_c() == Fluids.field_204546_a)), 3);
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (this.field_149764_J == Material.field_151573_f) {
            return ActionResultType.PASS;
        }
        state = (BlockState)state.func_235896_a_((Property)OPEN);
        worldIn.func_180501_a(pos, state, 10);
        return ActionResultType.func_233537_a_((boolean)worldIn.field_72995_K);
    }

    public boolean isOpen(BlockState state) {
        return (Boolean)state.func_177229_b((Property)OPEN);
    }

    public void openDoor(World worldIn, BlockState state, BlockPos pos, boolean open) {
        if (state.func_203425_a((Block)this) && (Boolean)state.func_177229_b((Property)OPEN) != open) {
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)OPEN, (Comparable)Boolean.valueOf(open)), 10);
        }
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        if (entity != null) {
            this.place(world, pos, state, entity.func_174811_aO());
        }
    }

    @Override
    public void remove(World world, BlockPos pos, BlockState state) {
        BlockPos FurniturePartPos;
        Direction facing = (Direction)state.func_177229_b((Property)FACING);
        BlockPos FurniturePos = this.getFurniturePos(pos, (DoubleTallPart)((Object)state.func_177229_b(PART)), facing);
        BlockState FurnitureBlockState = world.func_180495_p(FurniturePos);
        if (FurnitureBlockState.func_177230_c() == this && !pos.equals((Object)FurniturePos)) {
            this.removePart(world, FurniturePos, FurnitureBlockState);
        }
        if ((FurnitureBlockState = world.func_180495_p(FurniturePartPos = this.getFurnitureMiddlePos(FurniturePos, facing))).func_177230_c() == this && !pos.equals((Object)FurniturePartPos)) {
            this.removePart(world, FurniturePartPos, FurnitureBlockState);
        }
        if ((FurnitureBlockState = world.func_180495_p(FurniturePartPos = this.getFurnitureMiddlePos(FurniturePos, facing))).func_177230_c() == this && !pos.equals((Object)FurniturePartPos)) {
            this.removePart(world, FurniturePartPos, FurnitureBlockState);
        }
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        boolean flag;
        boolean bl = worldIn.func_175640_z(pos) || worldIn.func_175640_z(pos.func_177972_a(state.func_177229_b(PART) == DoubleTallPart.LOWER ? Direction.UP : Direction.DOWN)) ? true : (flag = false);
        if (blockIn != this) {
            if (flag != (Boolean)state.func_177229_b((Property)OPEN)) {
                // empty if block
            }
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)OPEN, (Comparable)Boolean.valueOf(flag)), 2);
        }
    }

    @Override
    public void func_176208_a(World world, BlockPos pos, BlockState state, PlayerEntity player) {
        this.remove(world, pos, state);
        super.func_176208_a(world, pos, state, player);
    }

    private BlockPos getFurnitureMiddlePos(BlockPos base, Direction facing) {
        switch (facing) {
            case NORTH: {
                return base.func_177984_a();
            }
            case EAST: {
                return base.func_177984_a();
            }
            case SOUTH: {
                return base.func_177984_a();
            }
            case WEST: {
                return base.func_177984_a();
            }
        }
        return base.func_177984_a();
    }

    private BlockPos getFurniturePos(BlockPos pos, DoubleTallPart part, Direction facing) {
        if (part == DoubleTallPart.LOWER) {
            return pos;
        }
        switch (facing) {
            case NORTH: {
                switch (part) {
                    case UPPER: {
                        return pos.func_177977_b();
                    }
                }
                return null;
            }
            case EAST: {
                switch (part) {
                    case UPPER: {
                        return pos.func_177977_b();
                    }
                }
                return null;
            }
            case SOUTH: {
                switch (part) {
                    case UPPER: {
                        return pos.func_177977_b();
                    }
                }
                return null;
            }
            case WEST: {
                switch (part) {
                    case UPPER: {
                        return pos.func_177977_b();
                    }
                }
                return null;
            }
        }
        return null;
    }

    @Override
    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    @Override
    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        DoubleTallPart doubleblockhalf = (DoubleTallPart)((Object)stateIn.func_177229_b(PART));
        if (facing.func_176740_k() == Direction.Axis.Y && doubleblockhalf == DoubleTallPart.LOWER == (facing == Direction.UP)) {
            return facingState.func_203425_a((Block)this) && facingState.func_177229_b(PART) != doubleblockhalf ? (BlockState)((BlockState)stateIn.func_206870_a((Property)FACING, facingState.func_177229_b((Property)FACING))).func_206870_a((Property)OPEN, facingState.func_177229_b((Property)OPEN)) : Blocks.field_150350_a.func_176223_P();
        }
        return doubleblockhalf == DoubleTallPart.LOWER && facing == Direction.DOWN && !stateIn.func_196955_c((IWorldReader)worldIn, currentPos) ? Blocks.field_150350_a.func_176223_P() : super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    private void removePart(World world, BlockPos pos, BlockState state) {
        FluidState fluidState = world.func_204610_c(pos);
        if (fluidState.func_206886_c() == Fluids.field_204546_a) {
            world.func_180501_a(pos, fluidState.func_206883_i(), 35);
        } else {
            world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 35);
        }
    }

    @Override
    public BlockState func_196258_a(BlockItemUseContext context) {
        FluidState ifluidstate = context.func_195991_k().func_204610_c(context.func_195995_a());
        BlockPos pos = context.func_195995_a();
        BlockPos FurnitureMiddlePos = this.getFurnitureMiddlePos(pos, context.func_195992_f().func_176734_d());
        if (pos.func_177956_o() < 255 && FurnitureMiddlePos.func_177956_o() < 255 && context.func_195991_k().func_180495_p(pos.func_177984_a()).func_196953_a(context)) {
            return (BlockState)((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_195992_f().func_176734_d())).func_206870_a((Property)OPEN, (Comparable)Boolean.valueOf(false))).func_206870_a(PART, (Comparable)((Object)DoubleTallPart.LOWER))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.func_206884_a((ITag)FluidTags.field_206959_a) && ifluidstate.func_206882_g() == 8));
        }
        return null;
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{PART, OPEN, FACING, WATERLOGGED});
    }

    public BlindsTall() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d).func_200947_a(SoundType.field_185848_a).func_200948_a(1.5f, 2.0f).func_226896_b_());
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)OPEN, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).func_206870_a(PART, (Comparable)((Object)DoubleTallPart.LOWER)));
    }
}

