/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.chunkloaders;

import com.supermartijn642.chunkloaders.ChunkLoaderTileRenderer;
import com.supermartijn642.chunkloaders.ChunkLoaders;
import com.supermartijn642.chunkloaders.screen.ChunkLoaderScreen;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ClientProxy {
    private static final Map<Block, BiFunction<World, BlockPos, ChunkLoaderScreen>> screens = new HashMap<Block, BiFunction<World, BlockPos, ChunkLoaderScreen>>();

    @SubscribeEvent
    public static void setup(FMLClientSetupEvent e) {
        ClientRegistry.bindTileEntityRenderer(ChunkLoaders.single_chunk_loader_tile, o -> new ChunkLoaderTileRenderer((TileEntityRendererDispatcher)o, ChunkLoaders.single_chunk_loader, false));
        ClientRegistry.bindTileEntityRenderer(ChunkLoaders.basic_chunk_loader_tile, o -> new ChunkLoaderTileRenderer((TileEntityRendererDispatcher)o, ChunkLoaders.basic_chunk_loader, false));
        ClientRegistry.bindTileEntityRenderer(ChunkLoaders.advanced_chunk_loader_tile, o -> new ChunkLoaderTileRenderer((TileEntityRendererDispatcher)o, ChunkLoaders.advanced_chunk_loader, true));
        ClientRegistry.bindTileEntityRenderer(ChunkLoaders.ultimate_chunk_loader_tile, o -> new ChunkLoaderTileRenderer((TileEntityRendererDispatcher)o, ChunkLoaders.ultimate_chunk_loader, true));
        screens.put(ChunkLoaders.single_chunk_loader, (world, pos) -> new ChunkLoaderScreen("single_chunk_loader", (World)world, (BlockPos)pos));
        screens.put(ChunkLoaders.basic_chunk_loader, (world, pos) -> new ChunkLoaderScreen("basic_chunk_loader", (World)world, (BlockPos)pos));
        screens.put(ChunkLoaders.advanced_chunk_loader, (world, pos) -> new ChunkLoaderScreen("advanced_chunk_loader", (World)world, (BlockPos)pos));
        screens.put(ChunkLoaders.ultimate_chunk_loader, (world, pos) -> new ChunkLoaderScreen("ultimate_chunk_loader", (World)world, (BlockPos)pos));
    }

    public static void openScreen(Block block, World world, BlockPos pos) {
        if (screens.containsKey(block)) {
            Minecraft.func_71410_x().func_147108_a((Screen)screens.get(block).apply(world, pos));
        }
    }
}

