/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.chunkloaders.packet;

import com.supermartijn642.chunkloaders.ChunkLoaderTile;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;

public abstract class ChunkLoaderPacket {
    protected BlockPos pos;

    public ChunkLoaderPacket(BlockPos pos) {
        this.pos = pos;
    }

    public ChunkLoaderPacket(PacketBuffer buffer) {
        this.decodeBuffer(buffer);
    }

    public void encode(PacketBuffer buffer) {
        buffer.func_179255_a(this.pos);
    }

    protected void decodeBuffer(PacketBuffer buffer) {
        this.pos = buffer.func_179259_c();
    }

    public void handle(Supplier<NetworkEvent.Context> contextSupplier) {
        contextSupplier.get().setPacketHandled(true);
        ServerPlayerEntity player = contextSupplier.get().getSender();
        if (player == null || player.func_233580_cy_().func_177951_i((Vector3i)this.pos) > 1024.0) {
            return;
        }
        World world = player.field_70170_p;
        if (world == null) {
            return;
        }
        TileEntity tile = world.func_175625_s(this.pos);
        if (tile instanceof ChunkLoaderTile) {
            contextSupplier.get().enqueueWork(() -> this.lambda$handle$0((PlayerEntity)player, world, tile));
        }
    }

    protected abstract void handle(PlayerEntity var1, World var2, ChunkLoaderTile var3);

    private /* synthetic */ void lambda$handle$0(PlayerEntity player, World world, TileEntity tile) {
        this.handle(player, world, (ChunkLoaderTile)tile);
    }
}

