/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.chunkloaders.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.supermartijn642.chunkloaders.ChunkLoaderTile;
import com.supermartijn642.chunkloaders.screen.ChunkButton;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class ChunkLoaderScreen
extends Screen {
    private static final ResourceLocation SCREEN_BACKGROUND = new ResourceLocation("chunkloaders", "textures/gui/background.png");
    protected World world;
    protected BlockPos pos;
    protected int left;
    protected int top;
    private final int backgroundSize;
    private boolean doDrag = false;
    private boolean dragState = false;
    private List<ChunkButton> draggedButtons = new ArrayList<ChunkButton>();

    public ChunkLoaderScreen(String type, World world, BlockPos pos) {
        super((ITextComponent)new TranslationTextComponent("block.chunkloaders." + type));
        this.world = world;
        this.pos = pos;
        ChunkLoaderTile tile = this.getTileOrClose();
        int gridSize = tile == null ? 1 : tile.getGridSize();
        this.backgroundSize = gridSize * 15 + (gridSize - 1) + 16;
    }

    protected void func_231160_c_() {
        ChunkLoaderTile tile = this.getTileOrClose();
        if (tile == null) {
            return;
        }
        this.left = (this.field_230708_k_ - this.backgroundSize) / 2;
        this.top = (this.field_230709_l_ - this.backgroundSize) / 2;
        int radius = (tile.getGridSize() - 1) / 2;
        for (int x = 0; x < tile.getGridSize(); ++x) {
            for (int y = 0; y < tile.getGridSize(); ++y) {
                this.func_230480_a_((Widget)new ChunkButton(this.left + 8 + x * 16, this.top + 8 + y * 16, -radius + x, -radius + y, this::getTileOrClose, this.world, new ChunkPos((this.pos.func_177958_n() >> 4) - radius + x, (this.pos.func_177952_p() >> 4) - radius + y)));
            }
        }
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrixStack);
        this.drawBackgroundLayer(matrixStack, partialTicks, mouseX, mouseY);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        ChunkLoaderTile tile = this.getTileOrClose();
        if (tile == null) {
            return;
        }
        this.field_230710_m_.stream().filter(ChunkButton.class::isInstance).map(ChunkButton.class::cast).forEach(button -> {
            if (button.func_230449_g_()) {
                this.renderToolTip(matrixStack, true, "chunkloaders.gui." + (tile.isLoaded(button.xOffset, button.zOffset) ? "loaded" : "unloaded"), mouseX, mouseY);
            }
        });
    }

    private void drawBackgroundLayer(MatrixStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        ChunkLoaderTile tile = this.getTileOrClose();
        if (tile == null) {
            return;
        }
        ChunkLoaderScreen.drawScreenBackground(matrixStack, this.left, this.top, this.backgroundSize, this.backgroundSize);
    }

    public void renderToolTip(MatrixStack matrixStack, boolean translate, String string, int x, int y) {
        super.func_238652_a_(matrixStack, (ITextComponent)(translate ? new TranslationTextComponent(string) : new StringTextComponent(string)), x, y);
    }

    public ChunkLoaderTile getTileOrClose() {
        TileEntity tile;
        if (this.world != null && this.pos != null && (tile = this.world.func_175625_s(this.pos)) instanceof ChunkLoaderTile) {
            return (ChunkLoaderTile)tile;
        }
        Minecraft.func_71410_x().field_71439_g.func_71053_j();
        return null;
    }

    public boolean func_231177_au__() {
        return false;
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        if (button == 0) {
            for (IGuiEventListener listener : this.field_230705_e_) {
                ChunkButton chunkButton;
                if (!(listener instanceof ChunkButton) || !(chunkButton = (ChunkButton)listener).func_231047_b_(mouseX, mouseY)) continue;
                this.doDrag = true;
                this.dragState = !chunkButton.isLoaded();
                this.draggedButtons.clear();
                this.draggedButtons.add(chunkButton);
                chunkButton.func_230930_b_();
                return true;
            }
        }
        return super.func_231044_a_(mouseX, mouseY, button);
    }

    public boolean func_231045_a_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.doDrag && button == 0) {
            for (IGuiEventListener listener : this.field_230705_e_) {
                ChunkButton chunkButton;
                if (!(listener instanceof ChunkButton) || this.draggedButtons.contains(listener) || !(chunkButton = (ChunkButton)listener).func_231047_b_(mouseX, mouseY) || chunkButton.isLoaded() == this.dragState) continue;
                chunkButton.func_230930_b_();
                this.draggedButtons.add(chunkButton);
                return true;
            }
        }
        return false;
    }

    public boolean func_231048_c_(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.doDrag = false;
        }
        return false;
    }

    public static void drawScreenBackground(MatrixStack matrixStack, float x, float y, float width, float height) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(SCREEN_BACKGROUND);
        ChunkLoaderScreen.drawTexture(matrixStack, x, y, 4.0f, 4.0f, 0.0f, 0.0f, 0.44444445f, 0.44444445f);
        ChunkLoaderScreen.drawTexture(matrixStack, x + width - 4.0f, y, 4.0f, 4.0f, 0.5555556f, 0.0f, 0.44444445f, 0.44444445f);
        ChunkLoaderScreen.drawTexture(matrixStack, x + width - 4.0f, y + height - 4.0f, 4.0f, 4.0f, 0.5555556f, 0.5555556f, 0.44444445f, 0.44444445f);
        ChunkLoaderScreen.drawTexture(matrixStack, x, y + height - 4.0f, 4.0f, 4.0f, 0.0f, 0.5555556f, 0.44444445f, 0.44444445f);
        ChunkLoaderScreen.drawTexture(matrixStack, x + 4.0f, y, width - 8.0f, 4.0f, 0.44444445f, 0.0f, 0.11111111f, 0.44444445f);
        ChunkLoaderScreen.drawTexture(matrixStack, x + 4.0f, y + height - 4.0f, width - 8.0f, 4.0f, 0.44444445f, 0.5555556f, 0.11111111f, 0.44444445f);
        ChunkLoaderScreen.drawTexture(matrixStack, x, y + 4.0f, 4.0f, height - 8.0f, 0.0f, 0.44444445f, 0.44444445f, 0.11111111f);
        ChunkLoaderScreen.drawTexture(matrixStack, x + width - 4.0f, y + 4.0f, 4.0f, height - 8.0f, 0.5555556f, 0.44444445f, 0.44444445f, 0.11111111f);
        ChunkLoaderScreen.drawTexture(matrixStack, x + 4.0f, y + 4.0f, width - 8.0f, height - 8.0f, 0.44444445f, 0.44444445f, 0.11111111f, 0.11111111f);
    }

    public static void drawTexture(MatrixStack matrixStack, float x, float y, float width, float height, float tx, float ty, float twidth, float theight) {
        GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Matrix4f matrix = matrixStack.func_227866_c_().func_227870_a_();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_227888_a_(matrix, x, y + height, 0.0f).func_225583_a_(tx, ty + theight).func_181675_d();
        buffer.func_227888_a_(matrix, x + width, y + height, 0.0f).func_225583_a_(tx + twidth, ty + theight).func_181675_d();
        buffer.func_227888_a_(matrix, x + width, y, 0.0f).func_225583_a_(tx + twidth, ty).func_181675_d();
        buffer.func_227888_a_(matrix, x, y, 0.0f).func_225583_a_(tx, ty).func_181675_d();
        tessellator.func_78381_a();
    }
}

