/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.culinaryconstruct.common.block;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.SimpleNamedContainerProvider;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import top.theillusivec4.culinaryconstruct.common.inventory.CulinaryStationContainer;
import top.theillusivec4.culinaryconstruct.common.tileentity.CulinaryStationTileEntity;

public class CulinaryStationBlock
extends Block {
    private static final ITextComponent CONTAINER_NAME = new TranslationTextComponent("culinaryconstruct.culinary_container");

    public CulinaryStationBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d).func_200943_b(2.5f).func_200947_a(SoundType.field_185848_a));
        this.setRegistryName("culinaryconstruct:culinary_station");
    }

    @Nonnull
    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        player.func_213829_a(state.func_215699_b(worldIn, pos));
        return ActionResultType.SUCCESS;
    }

    public void func_196243_a(BlockState state, @Nonnull World worldIn, @Nonnull BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            TileEntity tileentity = worldIn.func_175625_s(pos);
            if (tileentity instanceof CulinaryStationTileEntity) {
                CulinaryStationTileEntity cte = (CulinaryStationTileEntity)tileentity;
                NonNullList items = NonNullList.func_191196_a();
                cte.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.UP).ifPresent(cap -> {
                    for (int i = 0; i < cap.getSlots(); ++i) {
                        items.add((Object)cap.getStackInSlot(i));
                    }
                });
                cte.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.EAST).ifPresent(cap -> {
                    for (int i = 0; i < cap.getSlots(); ++i) {
                        items.add((Object)cap.getStackInSlot(i));
                    }
                });
                InventoryHelper.func_219961_a((World)worldIn, (BlockPos)pos, (NonNullList)items);
                worldIn.func_175666_e(pos, (Block)this);
            }
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new CulinaryStationTileEntity();
    }

    public INamedContainerProvider func_220052_b(BlockState state, World worldIn, BlockPos pos) {
        return new SimpleNamedContainerProvider((windowId, playerInventory, playerEntity) -> new CulinaryStationContainer(windowId, playerInventory, IWorldPosCallable.func_221488_a((World)worldIn, (BlockPos)pos), worldIn.func_175625_s(pos)), CONTAINER_NAME);
    }
}

