/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.collective.functions;

import com.natamus.collective.functions.RayTraceFunctions;
import com.natamus.collective.functions.WorldFunctions;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.server.ServerWorld;

public class BlockPosFunctions {
    public static List<BlockPos> getBlocksAround(BlockPos pos, boolean down) {
        ArrayList<BlockPos> around = new ArrayList<BlockPos>();
        around.add(pos.func_177978_c());
        around.add(pos.func_177974_f());
        around.add(pos.func_177968_d());
        around.add(pos.func_177976_e());
        around.add(pos.func_177984_a());
        if (down) {
            around.add(pos.func_177977_b());
        }
        return around;
    }

    public static List<BlockPos> getBlocksNextToEachOther(World world, BlockPos startpos, List<Block> possibleblocks) {
        ArrayList<BlockPos> checkedblocks = new ArrayList<BlockPos>();
        ArrayList<BlockPos> theblocksaround = new ArrayList<BlockPos>();
        if (possibleblocks.contains(world.func_180495_p(startpos).func_177230_c())) {
            theblocksaround.add(startpos);
            checkedblocks.add(startpos);
        }
        BlockPosFunctions.recursiveGetNextBlocks(world, startpos, possibleblocks, theblocksaround, checkedblocks);
        return theblocksaround;
    }

    private static void recursiveGetNextBlocks(World world, BlockPos pos, List<Block> possibleblocks, List<BlockPos> theblocksaround, List<BlockPos> checkedblocks) {
        List<BlockPos> possibleblocksaround = BlockPosFunctions.getBlocksAround(pos, true);
        for (BlockPos pba : possibleblocksaround) {
            if (checkedblocks.contains(pba)) continue;
            checkedblocks.add(pba);
            if (!possibleblocks.contains(world.func_180495_p(pba).func_177230_c()) || theblocksaround.contains(pba)) continue;
            theblocksaround.add(pba);
            BlockPosFunctions.recursiveGetNextBlocks(world, pba, possibleblocks, theblocksaround, checkedblocks);
        }
    }

    public static List<BlockPos> getBlocksNextToEachOtherMaterial(World world, BlockPos startpos, List<Material> possiblematerials) {
        ArrayList<BlockPos> checkedblocks = new ArrayList<BlockPos>();
        ArrayList<BlockPos> theblocksaround = new ArrayList<BlockPos>();
        if (possiblematerials.contains(world.func_180495_p(startpos).func_185904_a())) {
            theblocksaround.add(startpos);
            checkedblocks.add(startpos);
        }
        BlockPosFunctions.recursiveGetNextBlocksMaterial(world, startpos, possiblematerials, theblocksaround, checkedblocks);
        return theblocksaround;
    }

    private static void recursiveGetNextBlocksMaterial(World world, BlockPos pos, List<Material> possiblematerials, List<BlockPos> theblocksaround, List<BlockPos> checkedblocks) {
        List<BlockPos> possibleblocksaround = BlockPosFunctions.getBlocksAround(pos, true);
        for (BlockPos pba : possibleblocksaround) {
            if (checkedblocks.contains(pba)) continue;
            checkedblocks.add(pba);
            if (!possiblematerials.contains(world.func_180495_p(pba).func_185904_a()) || theblocksaround.contains(pba)) continue;
            theblocksaround.add(pba);
            BlockPosFunctions.recursiveGetNextBlocksMaterial(world, pba, possiblematerials, theblocksaround, checkedblocks);
        }
    }

    public static BlockPos getSurfaceBlockPos(ServerWorld serverworld, int x, int z) {
        BlockPos returnpos = new BlockPos(x, 255, z);
        if (!WorldFunctions.isNether((World)serverworld)) {
            int maxheight = 256;
            BlockPos pos = new BlockPos(x, maxheight, z);
            for (int y = maxheight; y > 0; --y) {
                BlockState blockstate = serverworld.func_180495_p(pos);
                Material material = blockstate.func_185904_a();
                if (blockstate.func_200016_a((IBlockReader)serverworld, pos) >= 15 || material.equals(Material.field_151588_w) || material.equals(Material.field_151598_x)) {
                    returnpos = pos.func_177984_a().func_185334_h();
                    break;
                }
                pos = pos.func_177977_b();
            }
        } else {
            int maxheight = 128;
            BlockPos pos = new BlockPos(x, 0, z);
            for (int y = 0; y < maxheight; ++y) {
                BlockState upstate;
                BlockState blockstate = serverworld.func_180495_p(pos);
                if (blockstate.func_177230_c().equals(Blocks.field_150350_a) && (upstate = serverworld.func_180495_p(pos.func_177984_a())).func_177230_c().equals(Blocks.field_150350_a)) {
                    returnpos = pos.func_185334_h();
                    break;
                }
                pos = pos.func_177984_a();
            }
        }
        return returnpos;
    }

    public static BlockPos getCenterNearbyVillage(ServerWorld serverworld) {
        BlockPos centerpos = new BlockPos(0, 0, 0);
        BlockPos villagepos = serverworld.func_241117_a_(Structure.field_236381_q_, centerpos, 9999, false);
        if (villagepos == null) {
            return null;
        }
        BlockPos spawnpos = null;
        for (int y = 255; y > 0; --y) {
            BlockPos checkpos = new BlockPos(villagepos.func_177958_n(), y, villagepos.func_177952_p());
            if (serverworld.func_180495_p(checkpos).func_177230_c().equals(Blocks.field_150350_a)) continue;
            spawnpos = checkpos.func_177984_a().func_185334_h();
            break;
        }
        return spawnpos;
    }

    public static BlockPos getCenterBiome(ServerWorld serverworld, Biome biome) {
        BlockPos centerpos = new BlockPos(0, 0, 0);
        BlockPos biomepos = serverworld.func_241116_a_(biome, centerpos, 999999, 0);
        if (biomepos == null) {
            return null;
        }
        BlockPos spawnpos = null;
        for (int y = 255; y > 0; --y) {
            BlockPos checkpos = new BlockPos(biomepos.func_177958_n(), y, biomepos.func_177952_p());
            if (serverworld.func_180495_p(checkpos).func_177230_c().equals(Blocks.field_150350_a)) continue;
            spawnpos = checkpos.func_177984_a().func_185334_h();
            break;
        }
        return spawnpos;
    }

    public static BlockPos getBlockPlayerIsLookingAt(World world, PlayerEntity player, boolean stopOnLiquid) {
        RayTraceResult raytraceresult = RayTraceFunctions.rayTrace(world, player, stopOnLiquid);
        double posX = raytraceresult.func_216347_e().field_72450_a;
        double posY = Math.floor(raytraceresult.func_216347_e().field_72448_b);
        double posZ = raytraceresult.func_216347_e().field_72449_c;
        return new BlockPos(posX, posY, posZ);
    }

    public static Boolean isOnSurface(World world, BlockPos pos) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        int maxheight = world.func_217301_I();
        for (int y0 = y; y0 < maxheight; ++y0) {
            BlockState blockstate = world.func_180495_p(new BlockPos(x, y0, z));
            if (blockstate.func_200016_a((IBlockReader)world, pos) < 15 || blockstate.func_177230_c() instanceof LeavesBlock) continue;
            return false;
        }
        return true;
    }

    public static Boolean isOnSurface(World world, Vector3d vecpos) {
        return BlockPosFunctions.isOnSurface(world, new BlockPos(vecpos.field_72450_a, vecpos.field_72448_b, vecpos.field_72449_c));
    }

    public static Boolean withinDistance(BlockPos start, BlockPos end, int distance) {
        if (BlockPosFunctions.withinDistance(start, end, (double)distance).booleanValue()) {
            return true;
        }
        return false;
    }

    public static Boolean withinDistance(BlockPos start, BlockPos end, double distance) {
        if (start.func_218141_a((Vector3i)end, distance)) {
            return true;
        }
        return false;
    }
}

