/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.connector;

import com.google.common.collect.Maps;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ServerData;
import org.tlauncher.connector.AbstractConnector;
import org.tlauncher.connector.ExtendedServerListData;
import org.tlauncher.util.TypeLocator;

public class ForgeConnector
extends AbstractConnector
implements TypeLocator {
    private static Class<?> guiScreenClass;
    private final Minecraft client;
    private Map<ServerData, ExtendedServerListData> serverDataTag;

    public void showGuiScreen(@Nullable Object clientGuiElement) {
        try {
            Method method = this.client.getClass().getMethod("func_147108_a", guiScreenClass);
            method.invoke((Object)this.client, clientGuiElement);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public void setupServerList() {
        this.serverDataTag = Collections.synchronizedMap(Maps.newHashMap());
    }

    @Override
    public void connectToServer(String host, int port) {
        this.setupServerList();
        ServerData serverData = new ServerData("Command Line", host + ":" + port, false);
        this.connectToServer(null, serverData);
    }

    public void connectToServer(Object guiMultiplayer, ServerData serverEntry) {
        ExtendedServerListData extendedData = this.serverDataTag.get(serverEntry);
        if (extendedData != null && extendedData.isBlocked) {
            this.showGuiScreen(null);
        } else {
            Object clientGuiElement = this.findConstructor(new TypeLocator.ClassNames("net.minecraft.client.multiplayer.GuiConnecting", "net.minecraft.client.gui.screen.ConnectingScreen", "net.minecraft.client.gui.GuiConnecting"), new TypeLocator.ParamsData(guiScreenClass, Minecraft.class, ServerData.class)).newInstance(guiMultiplayer, this.client, serverEntry);
            this.showGuiScreen(clientGuiElement);
        }
    }

    public ForgeConnector(Minecraft client) {
        guiScreenClass = this.findClass("net.minecraft.client.gui.GuiScreen", "net.minecraft.client.gui.screen.Screen");
        this.client = client;
    }
}

