/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.injection.mapping;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import org.tlauncher.injection.mapping.Mappings;
import org.tlauncher.util.TLModCfg;

public class MappingManager {
    private static final MappingManager instance = MappingManager.loadFromStream(MappingManager.class.getResourceAsStream("mappings.json"));
    private final Map<String, Mappings> versions = new HashMap<String, Mappings>();

    public Mappings getMappings() {
        return this.versions.get(TLModCfg.getMinecraftVersion());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static MappingManager loadFromStream(InputStream inputStream) {
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));){
            String line;
            StringBuilder json = new StringBuilder();
            while ((line = bufferedReader.readLine()) != null) {
                json.append(line).append("\n");
            }
            Gson gson = new GsonBuilder().create();
            MappingManager mappingManager = (MappingManager)gson.fromJson(json.toString(), MappingManager.class);
            return mappingManager;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static MappingManager instance() {
        return instance;
    }

    protected Map<String, Mappings> getVersions() {
        return this.versions;
    }
}

