/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.renderer.image;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import javax.imageio.ImageIO;
import net.minecraft.client.renderer.texture.NativeImage;
import org.tlauncher.renderer.image.ImageWrap;
import org.tlauncher.util.TextureUtils;
import org.tlauncher.util.TypeLocator;

public class NativeImageWrap
implements ImageWrap,
TypeLocator {
    private static Method readNativeImage;
    private final NativeImage nativeImage;

    public NativeImageWrap(InputStream inputStream) {
        this.nativeImage = this.readNativeImage(inputStream);
    }

    public NativeImageWrap(int width, int height) {
        this.nativeImage = new NativeImage(width, height, true);
    }

    public NativeImageWrap(BufferedImage bufferedImage) {
        this.nativeImage = this.getNativeImage(bufferedImage);
    }

    private NativeImage getNativeImage(BufferedImage bufferedImage) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)bufferedImage, "png", byteArrayOutputStream);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        return this.readNativeImage(byteArrayInputStream);
    }

    private NativeImage readNativeImage(InputStream inputStream) {
        if (readNativeImage == null) {
            readNativeImage = this.findMethod(NativeImage.class, new TypeLocator.MethodData(true, "a", InputStream.class), new TypeLocator.MethodData(true, "func_195713_a", InputStream.class), new TypeLocator.MethodData(true, "method_4309", InputStream.class));
        }
        return (NativeImage)readNativeImage.invoke(null, inputStream);
    }

    @Override
    public int getWidth() {
        return this.nativeImage.func_195702_a();
    }

    @Override
    public int getHeight() {
        return this.nativeImage.func_195714_b();
    }

    @Override
    public int getRGB(int x, int y) {
        return this.nativeImage.func_195709_a(x, y);
    }

    @Override
    public void setRGB(int x, int y, int color) {
        this.nativeImage.func_195700_a(x, y, color);
    }

    @Override
    public void allocateTexture(int textureId) {
        TextureUtils.prepareImage(textureId, this.getWidth(), this.getHeight());
    }

    @Override
    public void uploadTexture(int textureId) {
        TextureUtils.bindTexture(textureId);
        this.nativeImage.func_195697_a(0, 0, 0, false);
        this.nativeImage.close();
    }

    @Override
    public void close() {
        this.nativeImage.close();
    }
}

