/*
 * Decompiled with CFR 0.152.
 */
package com.flanks255.simplylight.data;

import com.flanks255.simplylight.SimplyLight;
import com.flanks255.simplylight.blocks.LampBlock;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.data.DataGenerator;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;

public class BlockStates
extends BlockStateProvider {
    public BlockStates(DataGenerator gen, ExistingFileHelper exFileHelper) {
        super(gen, "simplylight", exFileHelper);
    }

    protected void registerStatesAndModels() {
        this.generateLampBlock();
        this.generateThinLamps();
        this.myDirectionalBlock((Block)SimplyLight.LIGHTBULB.get(), $ -> this.models().getExistingFile(this.modLoc("block/lightbulb")), 180);
        this.generateRodLamp();
        this.generateWallLamp();
    }

    private void generateWallLamp() {
        ModelFile.ExistingModelFile wallModel = this.models().getExistingFile(this.modLoc("block/wall_lamp"));
        ModelFile.ExistingModelFile floorModel = this.models().getExistingFile(this.modLoc("block/floorlamp"));
        ((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder((Block)SimplyLight.WALL_LAMP.get()).partialState().with((Property)BlockStateProperties.field_208155_H, (Comparable)Direction.UP).modelForState().modelFile((ModelFile)floorModel).addModel()).partialState().with((Property)BlockStateProperties.field_208155_H, (Comparable)Direction.DOWN).modelForState().modelFile((ModelFile)floorModel).rotationX(180).addModel()).partialState().with((Property)BlockStateProperties.field_208155_H, (Comparable)Direction.EAST).modelForState().modelFile((ModelFile)wallModel).rotationY(270).addModel()).partialState().with((Property)BlockStateProperties.field_208155_H, (Comparable)Direction.WEST).modelForState().modelFile((ModelFile)wallModel).rotationY(90).addModel()).partialState().with((Property)BlockStateProperties.field_208155_H, (Comparable)Direction.SOUTH).modelForState().modelFile((ModelFile)wallModel).addModel()).partialState().with((Property)BlockStateProperties.field_208155_H, (Comparable)Direction.NORTH).modelForState().modelFile((ModelFile)wallModel).rotationY(180).addModel();
    }

    private void generateThinLamps() {
        this.myDirectionalBlock((Block)SimplyLight.ILLUMINANTSLAB.get(), $ -> this.models().getExistingFile(this.modLoc("block/illuminant_slab")), 180);
        this.myDirectionalBlock((Block)SimplyLight.ILLUMINANTPANEL.get(), $ -> this.models().getExistingFile(this.modLoc("block/illuminant_panel")), 180);
    }

    void generateRodLamp() {
        Block block = (Block)SimplyLight.RODLAMP.get();
        ModelFile.ExistingModelFile model = this.models().getExistingFile(this.modLoc("block/rodlamp"));
        ((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder(block).partialState().with((Property)RotatedPillarBlock.field_176298_M, (Comparable)Direction.Axis.Y).modelForState().modelFile((ModelFile)model).addModel()).partialState().with((Property)RotatedPillarBlock.field_176298_M, (Comparable)Direction.Axis.Z).modelForState().modelFile((ModelFile)model).rotationX(90).addModel()).partialState().with((Property)RotatedPillarBlock.field_176298_M, (Comparable)Direction.Axis.X).modelForState().modelFile((ModelFile)model).rotationX(90).rotationY(90).addModel();
    }

    private void generateLampBlock() {
        ResourceLocation offTex = this.modLoc("block/illuminant_block");
        ResourceLocation onTex = this.modLoc("block/illuminant_block_on");
        ModelBuilder.ElementBuilder illuminantBlockBuilder = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(((Block)SimplyLight.ILLUMINANTBLOCK.get()).getRegistryName().func_110623_a(), "cube")).texture("all", offTex)).texture("particle", offTex)).ao(false)).element();
        ModelBuilder modelIlluminantBlock = illuminantBlockBuilder.cube("#all").shade(false).end();
        ModelBuilder.ElementBuilder illuminantBlockBuilder_On = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(((Block)SimplyLight.ILLUMINANTBLOCK_ON.get()).getRegistryName().func_110623_a(), "cube")).texture("all", onTex)).texture("particle", onTex)).ao(false)).element();
        ModelBuilder modelIlluminantBlock_on = illuminantBlockBuilder_On.cube("#all").shade(false).end();
        VariantBlockStateBuilder LampBlockBuilder = this.getVariantBuilder((Block)SimplyLight.ILLUMINANTBLOCK.get());
        LampBlockBuilder.partialState().with((Property)LampBlock.ON, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)modelIlluminantBlock_on).addModel();
        LampBlockBuilder.partialState().with((Property)LampBlock.ON, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)modelIlluminantBlock).addModel();
        VariantBlockStateBuilder LampBlockOnBuilder = this.getVariantBuilder((Block)SimplyLight.ILLUMINANTBLOCK_ON.get());
        LampBlockOnBuilder.partialState().with((Property)LampBlock.ON, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)modelIlluminantBlock_on).addModel();
        LampBlockOnBuilder.partialState().with((Property)LampBlock.ON, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)modelIlluminantBlock).addModel();
    }

    public void myDirectionalBlock(Block block, Function<BlockState, ModelFile> modelFunc, int angleOffset) {
        this.getVariantBuilder(block).forAllStatesExcept(state -> {
            Direction dir = (Direction)state.func_177229_b((Property)BlockStateProperties.field_208155_H);
            return ConfiguredModel.builder().modelFile((ModelFile)modelFunc.apply((BlockState)state)).rotationX(dir == Direction.DOWN ? 180 : (dir.func_176740_k().func_176722_c() ? 90 : 0)).rotationY(dir.func_176740_k().func_200128_b() ? 0 : ((int)dir.func_185119_l() + angleOffset) % 360).build();
        }, new Property[]{BlockStateProperties.field_208198_y});
    }
}

