/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.world.chunk;

import com.sk89q.jnbt.ByteArrayTag;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.jnbt.IntTag;
import com.sk89q.jnbt.ListTag;
import com.sk89q.jnbt.NBTUtils;
import com.sk89q.jnbt.Tag;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.world.DataException;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockTypes;
import com.sk89q.worldedit.world.chunk.Chunk;
import com.sk89q.worldedit.world.registry.LegacyMapper;
import com.sk89q.worldedit.world.storage.InvalidFormatException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class OldChunk
implements Chunk {
    private final CompoundTag rootTag;
    private final byte[] blocks;
    private final byte[] data;
    private final int rootX;
    private final int rootZ;
    private Map<BlockVector3, Map<String, Tag>> tileEntities;

    public OldChunk(CompoundTag tag) throws DataException {
        this.rootTag = tag;
        this.blocks = NBTUtils.getChildTag((Map<String, Tag>)this.rootTag.getValue(), "Blocks", ByteArrayTag.class).getValue();
        this.data = NBTUtils.getChildTag((Map<String, Tag>)this.rootTag.getValue(), "Data", ByteArrayTag.class).getValue();
        this.rootX = NBTUtils.getChildTag((Map<String, Tag>)this.rootTag.getValue(), "xPos", IntTag.class).getValue();
        this.rootZ = NBTUtils.getChildTag((Map<String, Tag>)this.rootTag.getValue(), "zPos", IntTag.class).getValue();
        int size = 32768;
        if (this.blocks.length != size) {
            throw new InvalidFormatException("Chunk blocks byte array expected to be " + size + " bytes; found " + this.blocks.length);
        }
        if (this.data.length != size / 2) {
            throw new InvalidFormatException("Chunk block data byte array expected to be " + size + " bytes; found " + this.data.length);
        }
    }

    private void populateTileEntities() throws DataException {
        Object tags = NBTUtils.getChildTag((Map<String, Tag>)this.rootTag.getValue(), "TileEntities", ListTag.class).getValue();
        this.tileEntities = new HashMap<BlockVector3, Map<String, Tag>>();
        Iterator iterator = tags.iterator();
        while (iterator.hasNext()) {
            Tag tag = (Tag)iterator.next();
            if (!(tag instanceof CompoundTag)) {
                throw new InvalidFormatException("CompoundTag expected in TileEntities");
            }
            CompoundTag t = (CompoundTag)tag;
            int x = 0;
            int y = 0;
            int z = 0;
            HashMap values = new HashMap();
            for (Map.Entry entry : t.getValue().entrySet()) {
                switch ((String)entry.getKey()) {
                    case "x": {
                        if (!(entry.getValue() instanceof IntTag)) break;
                        x = ((IntTag)entry.getValue()).getValue();
                        break;
                    }
                    case "y": {
                        if (!(entry.getValue() instanceof IntTag)) break;
                        y = ((IntTag)entry.getValue()).getValue();
                        break;
                    }
                    case "z": {
                        if (!(entry.getValue() instanceof IntTag)) break;
                        z = ((IntTag)entry.getValue()).getValue();
                        break;
                    }
                }
                values.put(entry.getKey(), entry.getValue());
            }
            BlockVector3 vec = BlockVector3.at(x, y, z);
            this.tileEntities.put(vec, values);
        }
    }

    private CompoundTag getBlockTileEntity(BlockVector3 position) throws DataException {
        Map<String, Tag> values;
        if (this.tileEntities == null) {
            this.populateTileEntities();
        }
        if ((values = this.tileEntities.get(position)) == null) {
            return null;
        }
        return new CompoundTag(values);
    }

    @Override
    public BaseBlock getBlock(BlockVector3 position) throws DataException {
        int dataVal;
        byte id;
        if (position.getY() >= 128) {
            return BlockTypes.VOID_AIR.getDefaultState().toBaseBlock();
        }
        int x = position.getX() - this.rootX * 16;
        int y = position.getY();
        int z = position.getZ() - this.rootZ * 16;
        int index = y + (z * 128 + x * 128 * 16);
        try {
            id = this.blocks[index];
        }
        catch (IndexOutOfBoundsException e) {
            throw new DataException("Chunk does not contain position " + position);
        }
        boolean shift = index % 2 == 0;
        index /= 2;
        try {
            dataVal = !shift ? (this.data[index] & 0xF0) >> 4 : this.data[index] & 0xF;
        }
        catch (IndexOutOfBoundsException e) {
            throw new DataException("Chunk does not contain position " + position);
        }
        BlockState state = LegacyMapper.getInstance().getBlockFromLegacy(id, dataVal);
        if (state == null) {
            WorldEdit.logger.warn("Unknown legacy block " + id + ":" + dataVal + " found when loading legacy anvil chunk.");
            return BlockTypes.AIR.getDefaultState().toBaseBlock();
        }
        CompoundTag tileEntity = this.getBlockTileEntity(position);
        if (tileEntity != null) {
            return state.toBaseBlock(tileEntity);
        }
        return state.toBaseBlock();
    }
}

