/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mrcrayfish.furniture.block.FurnitureHorizontalWaterloggedBlock;
import com.mrcrayfish.furniture.core.ModSounds;
import com.mrcrayfish.furniture.util.VoxelShapeHelper;
import java.util.ArrayList;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class BlindsBlock
extends FurnitureHorizontalWaterloggedBlock {
    public static final BooleanProperty OPEN = BooleanProperty.func_177716_a((String)"open");
    public static final BooleanProperty EXTENSION = BooleanProperty.func_177716_a((String)"extension");
    public final ImmutableMap<BlockState, VoxelShape> SHAPES;

    public BlindsBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)DIRECTION, (Comparable)Direction.NORTH)).func_206870_a((Property)OPEN, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)EXTENSION, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.SHAPES = this.generateShapes((ImmutableList<BlockState>)this.func_176194_O().func_177619_a());
    }

    private ImmutableMap<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        VoxelShape[] BOX = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0), Direction.SOUTH));
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (BlockState state : states) {
            Direction direction = (Direction)state.func_177229_b((Property)DIRECTION);
            ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
            shapes.add(BOX[direction.func_176736_b()]);
            builder.put((Object)state, (Object)VoxelShapeHelper.combineAll(shapes));
        }
        return builder.build();
    }

    public boolean func_208619_r() {
        return true;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader reader, BlockPos pos, ISelectionContext context) {
        return (VoxelShape)this.SHAPES.get((Object)state);
    }

    public VoxelShape func_196247_c(BlockState state, IBlockReader reader, BlockPos pos) {
        return (VoxelShape)this.SHAPES.get((Object)state);
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return VoxelShapeHelper.rotate(VoxelShapeHelper.rotate(Block.func_208617_a((double)0.0, (double)1.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0), Direction.SOUTH), (Direction)state.func_177229_b((Property)DIRECTION));
    }

    @Override
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState state = super.func_196258_a(context);
        return this.getBlindState(state, (IWorld)context.func_195991_k(), context.func_195995_a());
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        return this.getBlindState(stateIn, worldIn, currentPos);
    }

    private BlockState getBlindState(BlockState state, IWorld world, BlockPos pos) {
        BlockState aboveState = world.func_180495_p(pos.func_177984_a());
        boolean isExtension = aboveState.func_177230_c() == this && aboveState.func_177229_b((Property)DIRECTION) == state.func_177229_b((Property)DIRECTION);
        return (BlockState)state.func_206870_a((Property)EXTENSION, (Comparable)Boolean.valueOf(isExtension));
    }

    public boolean func_220074_n(BlockState state) {
        return (Boolean)state.func_177229_b((Property)OPEN) == false;
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity playerEntity, Hand hand, BlockRayTraceResult result) {
        this.toggleBlinds(world, pos, (Boolean)state.func_177229_b((Property)OPEN) == false, (Direction)state.func_177229_b((Property)DIRECTION), 5);
        if (!world.field_72995_K) {
            if (((Boolean)state.func_177229_b((Property)OPEN)).booleanValue()) {
                world.func_184133_a(null, pos, ModSounds.BLOCK_BLINDS_CLOSE, SoundCategory.BLOCKS, 0.5f, world.field_73012_v.nextFloat() * 0.1f + 0.8f);
            } else {
                world.func_184133_a(null, pos, ModSounds.BLOCK_BLINDS_OPEN, SoundCategory.BLOCKS, 0.5f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
        }
        return ActionResultType.SUCCESS;
    }

    private void toggleBlinds(World world, BlockPos pos, boolean targetOpen, Direction targetDirection, int depth) {
        if (depth <= 0) {
            return;
        }
        BlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() == this) {
            boolean open = (Boolean)state.func_177229_b((Property)OPEN);
            Direction direction = (Direction)state.func_177229_b((Property)DIRECTION);
            if (open != targetOpen && direction.equals((Object)targetDirection)) {
                world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)OPEN, (Comparable)Boolean.valueOf(targetOpen)), 3);
                this.toggleBlinds(world, pos.func_177972_a(targetDirection.func_176746_e()), targetOpen, targetDirection, depth - 1);
                this.toggleBlinds(world, pos.func_177972_a(targetDirection.func_176735_f()), targetOpen, targetDirection, depth - 1);
                this.toggleBlinds(world, pos.func_177972_a(Direction.UP), targetOpen, targetDirection, depth - 1);
                this.toggleBlinds(world, pos.func_177972_a(Direction.DOWN), targetOpen, targetDirection, depth - 1);
            }
        }
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{OPEN});
        builder.func_206894_a(new Property[]{EXTENSION});
    }
}

