/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mrcrayfish.furniture.block.FurnitureHorizontalWaterloggedBlock;
import com.mrcrayfish.furniture.common.mail.Mail;
import com.mrcrayfish.furniture.common.mail.PostOffice;
import com.mrcrayfish.furniture.tileentity.MailBoxTileEntity;
import com.mrcrayfish.furniture.util.TileEntityUtil;
import com.mrcrayfish.furniture.util.VoxelShapeHelper;
import java.util.ArrayList;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class MailBoxBlock
extends FurnitureHorizontalWaterloggedBlock {
    public final ImmutableMap<BlockState, VoxelShape> SHAPES;

    public MailBoxBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)DIRECTION, (Comparable)Direction.NORTH)).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.SHAPES = this.generateShapes((ImmutableList<BlockState>)this.func_176194_O().func_177619_a());
    }

    private ImmutableMap<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        VoxelShape[] POST = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.func_208617_a((double)6.5, (double)0.0, (double)6.5, (double)9.5, (double)13.0, (double)9.5), Direction.SOUTH));
        VoxelShape[] BOX = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.func_208617_a((double)4.0, (double)13.0, (double)2.0, (double)12.0, (double)22.0, (double)14.0), Direction.SOUTH));
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (BlockState state : states) {
            Direction direction = (Direction)state.func_177229_b((Property)DIRECTION);
            ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
            shapes.add(POST[direction.func_176736_b()]);
            shapes.add(BOX[direction.func_176736_b()]);
            builder.put((Object)state, (Object)VoxelShapeHelper.combineAll(shapes));
        }
        return builder.build();
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader reader, BlockPos pos, ISelectionContext context) {
        return (VoxelShape)this.SHAPES.get((Object)state);
    }

    public VoxelShape func_196247_c(BlockState state, IBlockReader reader, BlockPos pos) {
        return (VoxelShape)this.SHAPES.get((Object)state);
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        TileEntity tileEntity;
        if (entity instanceof ServerPlayerEntity && (tileEntity = world.func_175625_s(pos)) instanceof MailBoxTileEntity) {
            MailBoxTileEntity mailBox = (MailBoxTileEntity)tileEntity;
            mailBox.setId(UUID.randomUUID());
            mailBox.setOwner((ServerPlayerEntity)entity);
            mailBox.setMailBoxName("Mail Box");
            PostOffice.registerMailBox((ServerPlayerEntity)entity, mailBox.getId(), "Mail Box", pos);
            TileEntityUtil.sendUpdatePacket(tileEntity);
        }
    }

    @Override
    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        MailBoxTileEntity mailBox;
        TileEntity tileEntity;
        if (!world.field_72995_K && (tileEntity = world.func_175625_s(pos)) instanceof MailBoxTileEntity && (mailBox = (MailBoxTileEntity)tileEntity).getId() != null && mailBox.getOwnerId() != null) {
            Mail mail;
            Supplier<Mail> supplier = PostOffice.getMailForPlayerMailBox(mailBox.getOwnerId(), mailBox.getId());
            while ((mail = supplier.get()) != null) {
                InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)mail.getStack());
            }
            PostOffice.unregisterMailBox(mailBox.getOwnerId(), mailBox.getId());
        }
        super.func_196243_a(state, world, pos, newState, isMoving);
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity playerEntity, Hand hand, BlockRayTraceResult result) {
        TileEntity tileEntity;
        if (!world.func_201670_d() && (tileEntity = world.func_175625_s(pos)) instanceof MailBoxTileEntity) {
            MailBoxTileEntity mailBox = (MailBoxTileEntity)tileEntity;
            if (playerEntity.func_110124_au().equals(mailBox.getOwnerId()) && !playerEntity.func_200200_C_().getString().equals(mailBox.getOwnerName())) {
                mailBox.setOwnerName(playerEntity.func_200200_C_().getString());
            }
            TileEntityUtil.sendUpdatePacket(tileEntity);
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)playerEntity), (INamedContainerProvider)((INamedContainerProvider)tileEntity), (BlockPos)pos);
        }
        return ActionResultType.SUCCESS;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new MailBoxTileEntity();
    }
}

