/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.tileentity;

import com.mrcrayfish.furniture.core.ModSounds;
import com.mrcrayfish.furniture.core.ModTileEntities;
import com.mrcrayfish.furniture.item.crafting.GrillCookingRecipe;
import com.mrcrayfish.furniture.item.crafting.RecipeType;
import com.mrcrayfish.furniture.network.PacketHandler;
import com.mrcrayfish.furniture.network.message.MessageFlipGrill;
import com.mrcrayfish.furniture.util.ItemStackHelper;
import com.mrcrayfish.furniture.util.TileEntityUtil;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IClearable;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.network.PacketDistributor;

public class GrillTileEntity
extends TileEntity
implements IClearable,
ITickableTileEntity,
ISidedInventory {
    public static final int MAX_FLIPPING_COUNTER = 15;
    public static final int[] ALL_SLOTS = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12};
    public static final int[] GRILL_SLOTS = new int[]{9, 10, 11, 12};
    private final NonNullList<ItemStack> fuel = NonNullList.func_191197_a((int)9, (Object)ItemStack.field_190927_a);
    private final NonNullList<ItemStack> grill = NonNullList.func_191197_a((int)4, (Object)ItemStack.field_190927_a);
    private final int[] cookingTimes = new int[4];
    private final int[] cookingTotalTimes = new int[4];
    private final boolean[] flipped = new boolean[4];
    private final float[] experience = new float[4];
    private final byte[] rotations = new byte[4];
    private int remainingFuel = 0;
    private final boolean[] flipping = new boolean[4];
    private final int[] flippingCounter = new int[4];

    public GrillTileEntity() {
        super(ModTileEntities.GRILL);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setFlipping(int position) {
        this.flipping[position] = true;
        this.flippingCounter[position] = 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isFlipping(int position) {
        return this.flipping[position];
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getFlippingCount(int position) {
        return this.flippingCounter[position];
    }

    public NonNullList<ItemStack> getGrill() {
        return this.grill;
    }

    public NonNullList<ItemStack> getFuel() {
        return this.fuel;
    }

    public byte[] getRotations() {
        return this.rotations;
    }

    public boolean isFlipped(int position) {
        return this.flipped[position];
    }

    public boolean addItem(ItemStack stack, int position, int cookTime, float experience, byte rotation) {
        if (((ItemStack)this.grill.get(position)).func_190926_b()) {
            ItemStack copy = stack.func_77946_l();
            copy.func_190920_e(1);
            this.grill.set(position, (Object)copy);
            this.resetPosition(position, cookTime, experience, rotation);
            World world = this.func_145831_w();
            if (world != null) {
                world.func_184148_a(null, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.0, (double)this.field_174879_c.func_177952_p() + 0.5, ModSounds.BLOCK_GRILL_PLACE, SoundCategory.BLOCKS, 0.75f, world.field_73012_v.nextFloat() * 0.2f + 0.9f);
            }
            return true;
        }
        return false;
    }

    private void resetPosition(int position, int cookTime, float experience, byte rotation) {
        this.cookingTimes[position] = 0;
        this.cookingTotalTimes[position] = cookTime / 2;
        this.flipped[position] = false;
        this.experience[position] = experience;
        this.rotations[position] = rotation;
        CompoundNBT compound = new CompoundNBT();
        this.writeItems(compound);
        this.writeCookingTimes(compound);
        this.writeCookingTotalTimes(compound);
        this.writeFlipped(compound);
        this.writeRotations(compound);
        TileEntityUtil.sendUpdatePacket(this, super.func_189515_b(compound));
    }

    public boolean addFuel(ItemStack stack) {
        for (int i = 0; i < this.fuel.size(); ++i) {
            if (!((ItemStack)this.fuel.get(i)).func_190926_b()) continue;
            ItemStack fuel = stack.func_77946_l();
            fuel.func_190920_e(1);
            this.fuel.set(i, (Object)fuel);
            CompoundNBT compound = new CompoundNBT();
            this.writeFuel(compound);
            TileEntityUtil.sendUpdatePacket(this, super.func_189515_b(compound));
            return true;
        }
        return false;
    }

    public void flipItem(int position) {
        if (!((ItemStack)this.grill.get(position)).func_190926_b()) {
            if (!this.flipped[position] && this.cookingTimes[position] == this.cookingTotalTimes[position]) {
                this.flipped[position] = true;
                this.cookingTimes[position] = 0;
                PacketHandler.instance.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.field_145850_b.func_175726_f(this.field_174879_c)), (Object)new MessageFlipGrill(this.field_174879_c, position));
                CompoundNBT compound = new CompoundNBT();
                this.writeCookingTimes(compound);
                this.writeFlipped(compound);
                TileEntityUtil.sendUpdatePacket(this, super.func_189515_b(compound));
                World world = this.func_145831_w();
                if (world != null) {
                    world.func_184148_a(null, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.0, (double)this.field_174879_c.func_177952_p() + 0.5, ModSounds.BLOCK_GRILL_FLIP, SoundCategory.BLOCKS, 0.75f, 1.0f);
                }
            } else if (this.flipped[position] && this.cookingTimes[position] == this.cookingTotalTimes[position]) {
                this.removeItem(position);
            }
        }
    }

    public void flipItems() {
        for (int i = 0; i < 4; ++i) {
            if (((ItemStack)this.grill.get(i)).func_190926_b() || this.flipped[i] || this.cookingTimes[i] != this.cookingTotalTimes[i]) continue;
            this.flipItem(i);
            return;
        }
    }

    public void removeItem(int position) {
        if (!((ItemStack)this.grill.get(position)).func_190926_b()) {
            double posX = (double)this.field_174879_c.func_177958_n() + 0.3 + 0.4 * (double)(position % 2);
            double posY = (double)this.field_174879_c.func_177956_o() + 1.0;
            double posZ = (double)this.field_174879_c.func_177952_p() + 0.3 + 0.4 * (double)(position / 2);
            ItemEntity entity = new ItemEntity(this.field_145850_b, posX, posY + 0.1, posZ, ((ItemStack)this.grill.get(position)).func_77946_l());
            this.field_145850_b.func_217376_c((Entity)entity);
            this.grill.set(position, (Object)ItemStack.field_190927_a);
            if (this.flipped[position] && this.cookingTimes[position] == this.cookingTotalTimes[position]) {
                int splitAmount;
                for (int amount = (int)this.experience[position]; amount > 0; amount -= splitAmount) {
                    splitAmount = ExperienceOrbEntity.func_70527_a((int)amount);
                    this.field_145850_b.func_217376_c((Entity)new ExperienceOrbEntity(this.field_145850_b, posX, posY, posZ, splitAmount));
                }
            }
            CompoundNBT compound = new CompoundNBT();
            this.writeItems(compound);
            TileEntityUtil.sendUpdatePacket(this, super.func_189515_b(compound));
        }
    }

    public void func_73660_a() {
        block4: {
            block3: {
                if (this.field_145850_b.func_201670_d()) break block3;
                boolean canCook = this.canCook();
                if (this.remainingFuel == 0 && canCook) {
                    for (int i = this.fuel.size() - 1; i >= 0; --i) {
                        if (((ItemStack)this.fuel.get(i)).func_190926_b()) continue;
                        this.remainingFuel = ForgeHooks.getBurnTime((ItemStack)((ItemStack)this.fuel.get(i)));
                        this.fuel.set(i, (Object)ItemStack.field_190927_a);
                        CompoundNBT compound = new CompoundNBT();
                        this.writeFuel(compound);
                        this.writeRemainingFuel(compound);
                        TileEntityUtil.sendUpdatePacket(this, super.func_189515_b(compound));
                        break;
                    }
                }
                if (!canCook || this.remainingFuel <= 0) break block4;
                this.cookItems();
                --this.remainingFuel;
                if (this.remainingFuel != 0) break block4;
                CompoundNBT compound = new CompoundNBT();
                this.writeRemainingFuel(compound);
                TileEntityUtil.sendUpdatePacket(this, super.func_189515_b(compound));
                break block4;
            }
            this.spawnParticles();
            for (int i = 0; i < this.flipping.length; ++i) {
                if (!this.flipping[i] || this.flippingCounter[i] >= 15) continue;
                int n = i;
                this.flippingCounter[n] = this.flippingCounter[n] + 1;
                if (this.flippingCounter[i] != 15) continue;
                this.flipping[i] = false;
            }
        }
    }

    private boolean canCook() {
        for (int i = 0; i < this.grill.size(); ++i) {
            if (((ItemStack)this.grill.get(i)).func_190926_b() || this.cookingTimes[i] == this.cookingTotalTimes[i]) continue;
            return true;
        }
        return false;
    }

    private void cookItems() {
        boolean itemsChanged = false;
        for (int i = 0; i < this.grill.size(); ++i) {
            Optional optional;
            if (((ItemStack)this.grill.get(i)).func_190926_b() || this.cookingTimes[i] >= this.cookingTotalTimes[i]) continue;
            int n = i;
            this.cookingTimes[n] = this.cookingTimes[n] + 1;
            if (this.cookingTimes[i] != this.cookingTotalTimes[i]) continue;
            if (this.flipped[i] && (optional = this.field_145850_b.func_199532_z().func_215371_a(RecipeType.GRILL_COOKING, (IInventory)new Inventory(new ItemStack[]{(ItemStack)this.grill.get(i)}), this.field_145850_b)).isPresent()) {
                this.grill.set(i, (Object)((GrillCookingRecipe)((Object)optional.get())).func_77571_b().func_77946_l());
            }
            itemsChanged = true;
        }
        if (itemsChanged) {
            CompoundNBT compound = new CompoundNBT();
            this.writeItems(compound);
            this.writeCookingTimes(compound);
            TileEntityUtil.sendUpdatePacket(this, super.func_189515_b(compound));
        }
    }

    private void spawnParticles() {
        World world = this.func_145831_w();
        if (world != null) {
            if (this.isCooking() && this.remainingFuel > 0) {
                double posX = (double)this.field_174879_c.func_177958_n() + 0.2 + 0.6 * world.field_73012_v.nextDouble();
                double posY = (double)this.field_174879_c.func_177956_o() + 0.85;
                double posZ = (double)this.field_174879_c.func_177952_p() + 0.2 + 0.6 * world.field_73012_v.nextDouble();
                world.func_195594_a((IParticleData)ParticleTypes.field_197631_x, posX, posY, posZ, 0.0, 0.0, 0.0);
            }
            BlockPos pos = this.func_174877_v();
            for (int i = 0; i < this.grill.size(); ++i) {
                if (((ItemStack)this.grill.get(i)).func_190926_b() || !(world.field_73012_v.nextFloat() < 0.1f)) continue;
                double posX = (double)pos.func_177958_n() + 0.3 + 0.4 * (double)(i % 2);
                double posY = (double)pos.func_177956_o() + 1.0;
                double posZ = (double)pos.func_177952_p() + 0.3 + 0.4 * (double)(i / 2);
                if (this.flipped[i] || this.cookingTimes[i] != this.cookingTotalTimes[i]) continue;
                for (int j = 0; j < 4; ++j) {
                    world.func_195594_a((IParticleData)ParticleTypes.field_197601_L, posX, posY, posZ, 0.0, 5.0E-4, 0.0);
                }
            }
        }
    }

    private boolean isCooking() {
        for (int i = 0; i < this.grill.size(); ++i) {
            if (((ItemStack)this.grill.get(i)).func_190926_b() || this.cookingTimes[i] == this.cookingTotalTimes[i] && this.flipped[i]) continue;
            return true;
        }
        return false;
    }

    public Optional<GrillCookingRecipe> findMatchingRecipe(ItemStack input) {
        return this.grill.stream().noneMatch(ItemStack::func_190926_b) ? Optional.empty() : this.field_145850_b.func_199532_z().func_215371_a(RecipeType.GRILL_COOKING, (IInventory)new Inventory(new ItemStack[]{input}), this.field_145850_b);
    }

    public int func_70302_i_() {
        return this.fuel.size() + this.grill.size();
    }

    public boolean func_191420_l() {
        for (ItemStack stack : this.fuel) {
            if (stack.func_190926_b()) continue;
            return false;
        }
        for (ItemStack stack : this.grill) {
            if (stack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int index) {
        if (index - this.fuel.size() >= 0) {
            return (ItemStack)this.grill.get(index - this.fuel.size());
        }
        return (ItemStack)this.fuel.get(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        if (index - this.fuel.size() >= 0) {
            ItemStack result = net.minecraft.inventory.ItemStackHelper.func_188382_a(this.grill, (int)(index -= this.fuel.size()), (int)count);
            if (((ItemStack)this.grill.get(index)).func_190926_b() && this.flipped[index] && this.cookingTimes[index] == this.cookingTotalTimes[index]) {
                int splitAmount;
                double posX = (double)this.field_174879_c.func_177958_n() + 0.3 + 0.4 * (double)(index % 2);
                double posY = (double)this.field_174879_c.func_177956_o() + 1.0;
                double posZ = (double)this.field_174879_c.func_177952_p() + 0.3 + 0.4 * (double)(index / 2);
                for (int amount = (int)this.experience[index]; amount > 0; amount -= splitAmount) {
                    splitAmount = ExperienceOrbEntity.func_70527_a((int)amount);
                    this.field_145850_b.func_217376_c((Entity)new ExperienceOrbEntity(this.field_145850_b, posX, posY, posZ, splitAmount));
                }
            }
            CompoundNBT compound = new CompoundNBT();
            this.writeItems(compound);
            TileEntityUtil.sendUpdatePacket(this, super.func_189515_b(compound));
            return result;
        }
        ItemStack result = net.minecraft.inventory.ItemStackHelper.func_188382_a(this.fuel, (int)index, (int)count);
        CompoundNBT compound = new CompoundNBT();
        this.writeFuel(compound);
        TileEntityUtil.sendUpdatePacket(this, super.func_189515_b(compound));
        return result;
    }

    public ItemStack func_70304_b(int index) {
        if (index - this.fuel.size() >= 0) {
            return net.minecraft.inventory.ItemStackHelper.func_188383_a(this.grill, (int)(index - this.fuel.size()));
        }
        return net.minecraft.inventory.ItemStackHelper.func_188383_a(this.fuel, (int)index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        NonNullList<ItemStack> inventory = this.fuel;
        if (index - this.fuel.size() >= 0) {
            inventory = this.grill;
            int finalIndex = index -= this.fuel.size();
            Optional optional = this.field_145850_b.func_199532_z().func_215371_a(RecipeType.GRILL_COOKING, (IInventory)new Inventory(new ItemStack[]{stack}), this.field_145850_b);
            if (optional.isPresent()) {
                GrillCookingRecipe recipe = (GrillCookingRecipe)((Object)optional.get());
                this.resetPosition(finalIndex, recipe.func_222137_e(), recipe.func_222138_b(), (byte)0);
            }
        }
        inventory.set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        CompoundNBT compound = new CompoundNBT();
        this.writeItems(compound);
        this.writeFuel(compound);
        TileEntityUtil.sendUpdatePacket(this, super.func_189515_b(compound));
    }

    public int func_70297_j_() {
        return 1;
    }

    public void func_174888_l() {
        this.fuel.clear();
        this.grill.clear();
    }

    public void func_230337_a_(BlockState blockState, CompoundNBT compound) {
        int i;
        int[] cookingTimes;
        super.func_230337_a_(blockState, compound);
        if (compound.func_150297_b("Grill", 9)) {
            this.grill.clear();
            ItemStackHelper.loadAllItems("Grill", compound, this.grill);
        }
        if (compound.func_150297_b("Fuel", 9)) {
            this.fuel.clear();
            ItemStackHelper.loadAllItems("Fuel", compound, this.fuel);
        }
        if (compound.func_150297_b("RemainingFuel", 3)) {
            this.remainingFuel = compound.func_74762_e("RemainingFuel");
        }
        if (compound.func_150297_b("CookingTimes", 11)) {
            cookingTimes = compound.func_74759_k("CookingTimes");
            System.arraycopy(cookingTimes, 0, this.cookingTimes, 0, Math.min(this.cookingTotalTimes.length, cookingTimes.length));
        }
        if (compound.func_150297_b("CookingTotalTimes", 11)) {
            cookingTimes = compound.func_74759_k("CookingTotalTimes");
            System.arraycopy(cookingTimes, 0, this.cookingTotalTimes, 0, Math.min(this.cookingTotalTimes.length, cookingTimes.length));
        }
        if (compound.func_150297_b("Flipped", 7)) {
            byte[] flipped = compound.func_74770_j("Flipped");
            for (i = 0; i < Math.min(this.flipped.length, flipped.length); ++i) {
                this.flipped[i] = flipped[i] == 1;
            }
        }
        if (compound.func_150297_b("Experience", 11)) {
            int[] experience = compound.func_74759_k("Experience");
            for (i = 0; i < Math.min(this.experience.length, experience.length); ++i) {
                this.experience[i] = Float.intBitsToFloat(experience[i]);
            }
        }
        if (compound.func_150297_b("Rotations", 7)) {
            byte[] rotations = compound.func_74770_j("Rotations");
            System.arraycopy(rotations, 0, this.rotations, 0, Math.min(this.rotations.length, rotations.length));
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        this.writeItems(compound);
        this.writeFuel(compound);
        this.writeCookingTimes(compound);
        this.writeCookingTotalTimes(compound);
        this.writeFlipped(compound);
        this.writeExperience(compound);
        this.writeRemainingFuel(compound);
        this.writeRotations(compound);
        return super.func_189515_b(compound);
    }

    private CompoundNBT writeItems(CompoundNBT compound) {
        ItemStackHelper.saveAllItems("Grill", compound, this.grill, true);
        return compound;
    }

    private CompoundNBT writeFuel(CompoundNBT compound) {
        ItemStackHelper.saveAllItems("Fuel", compound, this.fuel, true);
        return compound;
    }

    private CompoundNBT writeRemainingFuel(CompoundNBT compound) {
        compound.func_74768_a("RemainingFuel", this.remainingFuel);
        return compound;
    }

    private CompoundNBT writeCookingTimes(CompoundNBT compound) {
        compound.func_74783_a("CookingTimes", this.cookingTimes);
        return compound;
    }

    private CompoundNBT writeCookingTotalTimes(CompoundNBT compound) {
        compound.func_74783_a("CookingTotalTimes", this.cookingTotalTimes);
        return compound;
    }

    private CompoundNBT writeFlipped(CompoundNBT compound) {
        byte[] flipped = new byte[this.flipped.length];
        for (int i = 0; i < this.flipped.length; ++i) {
            flipped[i] = (byte)(this.flipped[i] ? 1 : 0);
        }
        compound.func_74773_a("Flipped", flipped);
        return compound;
    }

    private CompoundNBT writeExperience(CompoundNBT compound) {
        int[] experience = new int[this.experience.length];
        for (int i = 0; i < this.experience.length; ++i) {
            experience[i] = Float.floatToIntBits(experience[i]);
        }
        compound.func_74783_a("Experience", experience);
        return compound;
    }

    private CompoundNBT writeRotations(CompoundNBT compound) {
        compound.func_74773_a("Rotations", this.rotations);
        return compound;
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        CompoundNBT compound = pkt.func_148857_g();
        this.func_230337_a_(this.func_195044_w(), compound);
    }

    public boolean func_70300_a(PlayerEntity player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) == this && player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public int[] func_180463_a(Direction side) {
        return side == Direction.DOWN ? GRILL_SLOTS : ALL_SLOTS;
    }

    public boolean func_180462_a(int index, ItemStack stack, @Nullable Direction direction) {
        if (!this.func_70301_a(index).func_190926_b()) {
            return false;
        }
        if (index - this.fuel.size() >= 0) {
            return this.field_145850_b.func_199532_z().func_215371_a(RecipeType.GRILL_COOKING, (IInventory)new Inventory(new ItemStack[]{stack}), this.field_145850_b).isPresent();
        }
        return stack.func_77973_b() == Items.field_151044_h || stack.func_77973_b() == Items.field_196155_l;
    }

    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        if (direction == Direction.DOWN && index - this.fuel.size() >= 0 && this.flipped[index -= this.fuel.size()] && this.cookingTimes[index] == this.cookingTotalTimes[index]) {
            Optional optional = this.field_145850_b.func_199532_z().func_215371_a(RecipeType.GRILL_COOKING, (IInventory)new Inventory(new ItemStack[]{stack}), this.field_145850_b);
            return !optional.isPresent();
        }
        return false;
    }
}

