/*
 * Decompiled with CFR 0.152.
 */
package top.seraphjack.simplelogin;

import java.util.Collections;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class SLConfig {
    static final ForgeConfigSpec SERVER_SPEC;
    public static final Server SERVER;

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Server::new);
        SERVER_SPEC = (ForgeConfigSpec)specPair.getRight();
        SERVER = (Server)specPair.getLeft();
    }

    public static class Server {
        public final ForgeConfigSpec.IntValue secs;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> commandNames;
        public final ForgeConfigSpec.ConfigValue<String> storageMethod;
        public final ForgeConfigSpec.IntValue defaultGameType;
        public final ForgeConfigSpec.BooleanValue protectPlayerCoord;

        Server(ForgeConfigSpec.Builder builder) {
            builder.push("server");
            this.secs = builder.comment("Login Timeout(s)").defineInRange("secs", 60, 0, 1200);
            this.commandNames = builder.comment("Commands in whitelist can be executed before player login.").defineList("commandNames", Collections.emptyList(), o -> o instanceof String);
            this.storageMethod = builder.comment("Available storage method: file(json file) / capability(save in player nbt)").define("storageMethod", (Object)"file");
            this.defaultGameType = builder.comment("Default game type switched after player login").defineInRange("defaultGameType", 0, 0, 3);
            this.protectPlayerCoord = builder.comment("Protect player's coordinates").define("protectPlayerCoord", false);
            builder.pop();
        }
    }
}

