/*
 * Decompiled with CFR 0.152.
 */
package top.seraphjack.simplelogin.client;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.UUID;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import top.seraphjack.simplelogin.SimpleLogin;

@OnlyIn(value=Dist.CLIENT)
public final class PasswordHolder {
    private static PasswordHolder INSTANCE;
    public static final Path PASSWORD_FILE_PATH;
    private String password = UUID.randomUUID().toString();

    public static PasswordHolder instance() {
        if (INSTANCE == null) {
            INSTANCE = new PasswordHolder();
        }
        return INSTANCE;
    }

    private PasswordHolder() {
        if (Files.exists(PASSWORD_FILE_PATH, new LinkOption[0])) {
            this.read();
        } else {
            this.save();
        }
    }

    private void read() {
        try {
            this.password = new String(Files.readAllBytes(PASSWORD_FILE_PATH), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            SimpleLogin.logger.error("Failed to load password", (Throwable)e);
        }
    }

    private void save() {
        try {
            Files.write(PASSWORD_FILE_PATH, this.password.getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException e) {
            SimpleLogin.logger.error("Failed to save password", (Throwable)e);
        }
    }

    public void set(String o) {
        this.password = o;
        this.save();
    }

    public String password() {
        return this.password;
    }

    static {
        PASSWORD_FILE_PATH = Paths.get(".", ".sl_password");
    }
}

